/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.MessageServer;
import java.io.IOException;
import java.io.OutputStream;

public class ServerFileOutputStream
extends OutputStream {
    private MessageServer m_msgServer;
    private boolean m_opened;
    private int m_fileId;
    private byte[] m_writeBuffer;
    private int m_writeIndex;
    private boolean m_eof;
    private static final int BLOCKSIZE = 51200;

    public ServerFileOutputStream(int a_fileId, MessageServer a_service) {
        this.m_msgServer = a_service;
        this.m_opened = true;
        this.m_fileId = a_fileId;
        this.m_writeBuffer = null;
        this.m_writeIndex = 0;
        this.m_eof = false;
    }

    @Override
    public void write(int a_oneByte) throws IOException {
        if (this.m_opened) {
            if (this.m_writeBuffer == null) {
                this.m_writeBuffer = new byte[51200];
                this.m_writeIndex = 0;
            }
            this.m_writeBuffer[this.m_writeIndex] = (byte)a_oneByte;
            ++this.m_writeIndex;
            if (this.m_writeIndex == this.m_writeBuffer.length) {
                this.flush();
            }
        } else {
            throw new IOException("Stream already closed");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_writeBuffer != null) {
            if (this.m_writeIndex != this.m_writeBuffer.length) {
                byte[] buffer = new byte[this.m_writeIndex];
                System.arraycopy(this.m_writeBuffer, 0, buffer, 0, this.m_writeIndex);
                this.m_writeBuffer = buffer;
            }
            this.m_msgServer.fileWriteBlock(this.m_fileId, this.m_eof, this.m_writeBuffer);
            this.m_writeBuffer = null;
            this.m_writeIndex = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_opened) {
            this.m_eof = true;
            this.flush();
            this.m_msgServer.fileClose(this.m_fileId);
            this.m_opened = false;
        }
    }
}

