/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.MessageServer;
import java.io.IOException;
import java.io.InputStream;

public class ServerFileInputStream
extends InputStream {
    private MessageServer m_msgServer;
    private boolean m_opened;
    private boolean m_eofReached;
    private int m_fileId;
    private byte[] m_readBuffer;
    private int m_readIndex;

    public ServerFileInputStream(int a_fileId, MessageServer a_service) {
        this.m_msgServer = a_service;
        this.m_opened = true;
        this.m_fileId = a_fileId;
        this.m_readBuffer = null;
        this.m_readIndex = 0;
        this.m_eofReached = false;
    }

    @Override
    public int read() throws IOException {
        int retVal = -1;
        if (!this.m_opened) {
            throw new IOException("already closed");
        }
        if (this.m_readBuffer == null && !this.m_eofReached) {
            boolean[] eof = new boolean[1];
            this.m_readBuffer = this.m_msgServer.fileReadBlock(this.m_fileId, eof);
            this.m_eofReached = eof[0];
            this.m_readIndex = 0;
        }
        if (this.m_readBuffer != null) {
            if (this.m_readBuffer.length > 0) {
                retVal = this.m_readBuffer[this.m_readIndex] & 0xFF;
                ++this.m_readIndex;
            }
            if (this.m_readIndex == this.m_readBuffer.length) {
                this.m_readBuffer = null;
            }
        }
        return retVal;
    }

    @Override
    public int available() throws IOException {
        if (this.m_readBuffer != null) {
            return this.m_readBuffer.length - this.m_readIndex;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.m_opened) {
            this.m_msgServer.fileClose(this.m_fileId);
            this.m_opened = false;
        }
    }
}

