/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.SSLStoreParameters;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLFactoryCache {
    private static SSLFactoryCache s_instance = null;
    private Map<SSLStoreParameters, SSLSocketFactory> m_factoryMap = new HashMap<SSLStoreParameters, SSLSocketFactory>();

    private SSLFactoryCache() {
    }

    public static synchronized SSLFactoryCache getInstance() {
        if (s_instance == null) {
            s_instance = new SSLFactoryCache();
        }
        return s_instance;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory(SSLStoreParameters storeParameters) throws BaanConnectionException {
        SSLSocketFactory sslSocketFactory = this.m_factoryMap.get(storeParameters);
        if (sslSocketFactory == null) {
            sslSocketFactory = this.createFactory(storeParameters);
            this.m_factoryMap.put(storeParameters, sslSocketFactory);
        }
        return sslSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory createFactory(SSLStoreParameters storeParameters) throws BaanConnectionException {
        String keyStore = storeParameters.getKeyStore();
        String trustStore = storeParameters.getTrustStore();
        if (keyStore == null && trustStore == null) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            KeyManager[] km = null;
            TrustManager[] tm = null;
            if (keyStore != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore ks = KeyStore.getInstance(storeParameters.getKeyStoreType());
                String keyStorePW = storeParameters.getKeyStorePassword();
                char[] keystorePassword = null;
                if (keyStorePW != null) {
                    keystorePassword = keyStorePW.toCharArray();
                }
                try (FileInputStream ksStream = null;){
                    ksStream = new FileInputStream(keyStore);
                    ks.load(ksStream, keystorePassword);
                    kmf.init(ks, keystorePassword);
                    km = kmf.getKeyManagers();
                }
            }
            if (trustStore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore ts = KeyStore.getInstance(storeParameters.getTrustStoreType());
                char[] trustStorePassword = null;
                String trustStorePW = storeParameters.getTrustStorePassword();
                if (trustStorePW != null) {
                    trustStorePassword = trustStorePW.toCharArray();
                }
                try (FileInputStream tsStream = null;){
                    tsStream = new FileInputStream(trustStore);
                    ts.load(tsStream, trustStorePassword);
                    tmf.init(ts);
                    tm = tmf.getTrustManagers();
                }
            }
            sc.init(km, tm, null);
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            throw new BaanConnectionException("Error during SSLFactory initialization", 6, e);
        }
    }
}

