/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.Connector;
import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.EISMetaData;
import com.infor.erpln.protocol.EISMetaDataImpl;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.JcaHandlerImpl;
import com.infor.erpln.protocol.Listener;
import com.infor.erpln.protocol.NetReader;
import com.infor.erpln.protocol.RequestToken;
import com.infor.erpln.protocol.ServerFileInputStream;
import com.infor.erpln.protocol.ServerFileOutputStream;
import com.infor.erpln.protocol.ThreeGLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class MessageServer
extends Thread {
    private final RequestToken m_token;
    private final Hashtable<Integer, JcaHandler> m_bdeManagers;
    protected NetReader m_netReader;
    private Socket m_socket;
    protected boolean m_running;
    private boolean m_replyReceived;
    protected Connector m_connector;
    protected Exception m_exception;
    protected Vector<String> m_errors = new Vector();
    private JcaHandler m_bdeManager;
    private EISMetaData m_eisMetaData;
    private Listener m_listener;
    private int m_fileId;
    private byte[] m_readBuffer;
    private int m_returnValue;
    protected final ConnectionConfig m_connectData;
    private static final int BDE_INIT_TIMEOUT = 40000;
    private static final int JCA_INIT_TIMEOUT = 300000;
    private static final Logger LOG = ESAPI.getLogger(MessageServer.class);

    public MessageServer(Socket a_socket, NetReader a_netReader, ConnectionConfig a_connectData) {
        super("MessageServer");
        this.m_socket = a_socket;
        this.m_netReader = a_netReader;
        this.m_connectData = a_connectData;
        this.m_exception = null;
        this.m_connector = null;
        this.m_token = new RequestToken();
        this.m_bdeManagers = new Hashtable();
    }

    public synchronized void setConnectorObject(Connector a_connector) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setConnectorObject()");
        this.m_connector = a_connector;
        this.m_replyReceived = true;
        this.notify();
    }

    @Override
    public void start() {
        this.m_running = true;
        this.m_errors.clear();
        super.start();
    }

    public void stopServer() {
        this.m_running = false;
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcaHandler getBdeManager(int iCompany) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: getBdeManager()");
        if (iCompany != -1) {
            this.assertProtocolVersion(2);
        }
        JcaHandler bdeManager = this.m_bdeManager;
        if (this.m_connector != null) {
            try {
                this.m_token.getRequestToken();
                MessageServer messageServer = this;
                synchronized (messageServer) {
                    this.m_bdeManager = null;
                    this.m_exception = null;
                    this.m_connector.sendOpenBdeRequest(iCompany);
                    this.waitForReply(40000);
                    bdeManager = this.m_bdeManager;
                }
            }
            finally {
                this.m_token.releaseRequestToken();
            }
        }
        if (bdeManager == null) {
            this.throwBaanException();
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: getBdeManager()");
        return bdeManager;
    }

    public InputStream openForRead(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        return this.openForRead(a_serverFile, a_textMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openForRead(String a_serverFile, boolean a_textMode, boolean a_polling) throws IOException, BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: openForRead()");
        int minProtocolVersion = a_polling ? 5 : 3;
        this.assertProtocolVersion(minProtocolVersion);
        if (this.m_connector == null) {
            throw new BaanConnectionException("Not connected", 6);
        }
        int mode = 1;
        if (a_textMode) {
            mode |= 0x10;
        }
        int fileId = 0;
        try {
            this.m_token.getRequestToken();
            MessageServer messageServer = this;
            synchronized (messageServer) {
                this.m_exception = null;
                this.m_fileId = 0;
                this.m_connector.sendOpenFileRequest(a_serverFile, mode, a_polling);
                this.waitForReply(-1);
                fileId = this.m_fileId;
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        if (fileId < 0) {
            throw new IOException("Open of server file failed");
        }
        ServerFileInputStream is = new ServerFileInputStream(fileId, this);
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: openForRead()");
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: openForWrite()");
        this.assertProtocolVersion(3);
        if (this.m_connector == null) {
            throw new BaanConnectionException("Not connected", 6);
        }
        int mode = 2;
        if (a_textMode) {
            mode |= 0x10;
        }
        int fileId = 0;
        try {
            this.m_token.getRequestToken();
            MessageServer messageServer = this;
            synchronized (messageServer) {
                this.m_exception = null;
                this.m_fileId = 0;
                this.m_connector.sendOpenFileRequest(a_serverFile, mode, false);
                this.waitForReply(-1);
                fileId = this.m_fileId;
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        if (fileId < 0) {
            throw new IOException("Open of server file failed");
        }
        ServerFileOutputStream os = new ServerFileOutputStream(fileId, this);
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: openForWrite()");
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fileReadBlock(int a_fileId, boolean[] a_eofReached) throws IOException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: fileReadBlock()");
        int returnValue = 0;
        byte[] readBuffer = null;
        try {
            this.m_token.getRequestToken();
            MessageServer messageServer = this;
            synchronized (messageServer) {
                this.m_connector.sendReadRequest(a_fileId);
                this.m_readBuffer = null;
                this.m_returnValue = 0;
                try {
                    this.waitForReply(-1);
                    returnValue = this.m_returnValue;
                    readBuffer = this.m_readBuffer;
                }
                catch (BaanConnectionException e) {
                    throw new IOException("Connection broken: " + e.toString());
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        if (returnValue < 0) {
            throw new IOException("Read of server file failed");
        }
        a_eofReached[0] = returnValue == 1;
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: fileReadBlock()");
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileWriteBlock(int a_fileId, boolean a_eof, byte[] a_buffer) throws IOException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: fileWriteBlock()");
        int returnValue = 0;
        try {
            this.m_token.getRequestToken();
            MessageServer messageServer = this;
            synchronized (messageServer) {
                this.m_connector.sendWriteRequest(a_fileId, a_eof, a_buffer);
                this.m_returnValue = 0;
                try {
                    this.waitForReply(-1);
                    returnValue = this.m_returnValue;
                }
                catch (BaanConnectionException e) {
                    throw new IOException("Connection broken: " + e.toString());
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        if (returnValue < 0) {
            throw new IOException("Write of server file failed");
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: fileWriteBlock()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileClose(int a_fileId) throws IOException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: fileClose()");
        int returnValue = 0;
        try {
            this.m_token.getRequestToken();
            MessageServer messageServer = this;
            synchronized (messageServer) {
                this.m_connector.sendCloseRequest(a_fileId);
                this.m_returnValue = 0;
                try {
                    this.waitForReply(-1);
                    returnValue = this.m_returnValue;
                }
                catch (BaanConnectionException e) {
                    throw new IOException("Connection broken: " + e.toString());
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        if (returnValue < 0) {
            throw new IOException("Close of server file failed");
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: fileClose()");
    }

    public EISMetaData getMetaData() {
        return this.m_eisMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EISMetaData initProtocol(int a_protocolVersion, ConnectionConfig a_connectData) throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: initProtocol()");
        if (this.m_connector != null) {
            try {
                this.m_token.getRequestToken();
                MessageServer messageServer = this;
                synchronized (messageServer) {
                    this.m_exception = null;
                    this.m_eisMetaData = null;
                    this.m_connector.sendInitProtocol(a_protocolVersion, a_connectData);
                    this.waitForReply(300000);
                }
            }
            finally {
                this.m_token.releaseRequestToken();
            }
        }
        if (this.m_eisMetaData == null) {
            this.throwBaanException();
        }
        this.m_connector.setProtocolVersion(this.m_eisMetaData.getEISprotocolVersion());
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: initProtocol()");
        return this.m_eisMetaData;
    }

    private void waitForReply(int timeout) throws BaanConnectionException {
        if (!this.m_running) {
            LOG.error(Logger.EVENT_FAILURE, "MessageServer not running anymore");
            throw new BaanConnectionException("Bshell connection is lost", 4);
        }
        this.m_exception = null;
        this.m_errors.clear();
        this.m_replyReceived = false;
        long start = System.currentTimeMillis();
        while (!this.m_replyReceived && this.m_exception == null) {
            try {
                if (timeout > 0) {
                    this.wait(timeout);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (timeout <= 0 || System.currentTimeMillis() - start < (long)timeout) continue;
            this.m_exception = new IOException("Timeout on backend reply");
        }
        if (this.m_exception != null) {
            this.throwBaanException();
        }
    }

    public void dispatchReplyMessage(DsMessage dsMess) throws ThreeGLException {
        Hashtable attributes = dsMess.getAttributes();
        int frameIndicator = 0;
        String productName = "";
        String productVersion = "";
        String eisUsername = "";
        int eisProtocolVersion = 0;
        int returnValue = -1;
        int errorCode = -1;
        int fileId = -1;
        byte[] buffer = null;
        String returnMessage = "";
        Enumeration e = attributes.elements();
        block21: while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            int attributeType = attribute.getType();
            switch (attributeType) {
                case 353: {
                    frameIndicator = attribute.getValueInt();
                    break;
                }
                case 223: {
                    eisProtocolVersion = attribute.getValueInt();
                    break;
                }
                case 15: {
                    eisUsername = attribute.getValueString();
                    break;
                }
                case 200: {
                    productName = attribute.getValueString();
                    break;
                }
                case 62: {
                    productVersion = attribute.getValueString();
                    break;
                }
                case 52: {
                    returnValue = attribute.getValueInt();
                    break;
                }
                case 274: {
                    returnMessage = attribute.getValueString();
                    break;
                }
                case 349: {
                    fileId = attribute.getValueInt();
                    break;
                }
                case 215: {
                    buffer = attribute.getValueVoid();
                    break;
                }
                case 8: {
                    errorCode = attribute.getValueInt();
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    continue block21;
                }
            }
            attributes.remove(new Integer(attributeType));
        }
        switch (frameIndicator) {
            case 15: {
                this.receiveInitReply(eisUsername, productName, productVersion, eisProtocolVersion, returnValue, returnMessage);
                break;
            }
            case 4: {
                this.receiveFileOpenAck(fileId);
                break;
            }
            case 6: {
                this.receiveFileReadAck(fileId, returnValue, buffer);
                break;
            }
            case 8: {
                this.receiveFileWriteAck(fileId, returnValue);
                break;
            }
            case 10: {
                this.receiveFileCloseAck(fileId, returnValue);
                break;
            }
            case 17: {
                this.startBdeManagerFailed(errorCode);
                break;
            }
            default: {
                throw new ThreeGLException("Not supported value for DsNaction: " + frameIndicator);
            }
        }
    }

    public void dispatchPubMessage(DsMessage dsMess) throws ThreeGLException {
        Hashtable attributes = dsMess.getAttributes();
        int frameIndicator = 0;
        byte[] messageArea = null;
        byte[] headerArea = null;
        int producerVersion = 0;
        Enumeration e = attributes.elements();
        block10: while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            int attributeType = attribute.getType();
            switch (attributeType) {
                case 353: {
                    frameIndicator = attribute.getValueInt();
                    break;
                }
                case 33: {
                    headerArea = attribute.getValueVoid();
                    break;
                }
                case 215: {
                    messageArea = attribute.getValueVoid();
                    break;
                }
                case 223: {
                    producerVersion = attribute.getValueInt();
                    break;
                }
                default: {
                    continue block10;
                }
            }
            attributes.remove(new Integer(attributeType));
        }
        switch (frameIndicator) {
            case 32: {
                this.handlePubInitRequest(producerVersion);
                break;
            }
            case 34: {
                this.handlePubBdeRequest(messageArea);
                break;
            }
            default: {
                throw new ThreeGLException("Not supported value for DsNaction: " + frameIndicator);
            }
        }
    }

    private synchronized void receiveInitReply(String a_eisUserName, String a_productName, String a_productVersion, int a_eisProtcolVersion, int a_returnValue, String a_returnMessage) {
        if (a_returnValue > 0) {
            this.m_eisMetaData = new EISMetaDataImpl(a_eisUserName, a_productName, a_productVersion, a_eisProtcolVersion);
        } else {
            this.m_errors.add(new String("Failed to initialize protocol"));
            this.m_errors.add(this.errorCodeToString(a_returnValue));
            this.m_errors.add(a_returnMessage);
            this.m_exception = new IOException();
        }
        LOG.debug(Logger.EVENT_UNSPECIFIED, "receiveInitReply()");
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void setBdeManager(JcaHandler a_manager) {
        this.m_bdeManager = a_manager;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setBdeManager()");
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void startBdeManagerFailed(int a_errorCode) {
        this.m_errors.add(new String("Failed to start bdemanager"));
        this.m_errors.add(this.errorCodeToString(a_errorCode));
        this.m_exception = new IOException();
        LOG.debug(Logger.EVENT_UNSPECIFIED, "startBdeManagerFailed()");
        this.m_replyReceived = true;
        this.notify();
    }

    private String errorCodeToString(int a_errorCode) {
        String reason = "reason: ";
        switch (a_errorCode) {
            case -1: {
                reason = reason + "Company not available";
                break;
            }
            case -2: {
                reason = reason + "No permission to change to this company.";
                break;
            }
            case -3: {
                reason = reason + "Package combination does not correspond with new company number.";
                break;
            }
            case -4: {
                reason = reason + "First day of the week does not correspond to first day of the week of original company.";
                break;
            }
            case -5: {
                reason = reason + "Wrong internal state";
                break;
            }
            case -6: {
                reason = reason + "Activation failure";
                break;
            }
            case -7: {
                reason = reason + "Authentication failure";
                break;
            }
            default: {
                reason = reason + "Error code: " + a_errorCode;
            }
        }
        return reason;
    }

    public void addBdeManager(JcaHandlerImpl a_bdeMan) {
        this.m_bdeManagers.put(new Integer(a_bdeMan.getBdeManId()), a_bdeMan);
    }

    public void removeBdeManager(JcaHandlerImpl a_bdeMan) {
        this.m_bdeManagers.remove(new Integer(a_bdeMan.getBdeManId()));
    }

    public synchronized void receiveFileOpenAck(int a_fileId) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "receiveFileOpenAck()");
        this.m_fileId = a_fileId;
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void receiveFileReadAck(int a_fileId, int a_returnValue, byte[] a_readBuffer) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "receiveFileReadAck()");
        this.m_fileId = a_fileId;
        this.m_returnValue = a_returnValue;
        this.m_readBuffer = a_readBuffer;
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void receiveFileWriteAck(int a_fileId, int a_returnValue) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "receiveFileWriteAck()");
        this.m_fileId = a_fileId;
        this.m_returnValue = a_returnValue;
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void receiveFileCloseAck(int a_fileId, int a_returnValue) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "receiveFileCloseAck()");
        this.m_fileId = a_fileId;
        this.m_returnValue = a_returnValue;
        this.m_replyReceived = true;
        this.notify();
    }

    public void setListener(Listener a_listener) {
        this.m_listener = a_listener;
    }

    public Listener getListener() {
        return this.m_listener;
    }

    public void getAndClearAllErrors(Vector<String> a_errors) {
        a_errors.addAll(this.m_errors);
        this.m_errors.clear();
    }

    public void assertProtocolVersion(int a_minimalVersion) throws BaanConnectionException {
        if (this.m_eisMetaData.getEISprotocolVersion() < a_minimalVersion) {
            throw new BaanConnectionException("Backend protocol version too old, currently: " + this.m_eisMetaData.getEISprotocolVersion() + ", must be at least: " + a_minimalVersion, 6);
        }
    }

    public void setDsMessageCollecting() {
    }

    public void fillDsMessageOutputStream(OutputStream a_dsMessages) {
    }

    private synchronized void handlePubInitRequest(int a_producerVersion) {
        byte[] metaData;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "handlePubInitRequest(), producerVersion: " + Integer.toString(a_producerVersion));
        int returnValue = 1;
        if (this.m_listener == null) {
            returnValue = -1;
            metaData = new byte[]{};
        } else {
            metaData = this.m_listener.getMetaData();
        }
        this.m_connector.sendPubInitAck(1, returnValue, metaData);
    }

    private void handlePubBdeRequest(byte[] a_bdeMessage) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "handlePubBdeRequest()");
        int returnValue = -1;
        if (this.m_listener != null) {
            returnValue = this.m_listener.onBDEMessage(a_bdeMessage);
        }
        this.m_connector.sendPubBdeAck(returnValue);
    }

    protected synchronized void signalException(Exception a_exception) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "signalException: " + a_exception);
        this.m_exception = a_exception;
        this.m_running = false;
        this.notify();
        Enumeration<JcaHandler> bdeManagers = this.m_bdeManagers.elements();
        while (bdeManagers.hasMoreElements()) {
            JcaHandlerImpl bdeMan = (JcaHandlerImpl)bdeManagers.nextElement();
            bdeMan.signalException(a_exception);
        }
        if (this.m_listener != null) {
            this.m_listener.removeMessageServer(this);
        }
    }

    protected void throwBaanException() throws BaanConnectionException {
        StringBuffer sb = new StringBuffer();
        for (String error : this.m_errors) {
            sb.append(error).append('\n');
        }
        if (this.m_exception == null) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "throwBaanException(): exception not set, Bshell message: " + sb.toString());
            throw new BaanConnectionException(sb.toString(), 4);
        }
        LOG.debug(Logger.EVENT_UNSPECIFIED, "throwBaanException(): throwing exception: " + this.m_exception.toString());
        if (this.m_exception instanceof IOException) {
            sb.insert(0, "Communication failure\n");
            throw new BaanConnectionException(sb.toString(), 5, this.m_exception);
        }
        if (this.m_exception instanceof ThreeGLException) {
            throw new BaanConnectionException(sb.toString(), 7, this.m_exception);
        }
        sb.insert(0, "Unknown exception in MessageServer\n");
        throw new BaanConnectionException(sb.toString(), 6, this.m_exception);
    }

    protected void logConnectionData() {
        if (this.m_connectData != null && LOG.isDebugEnabled()) {
            try {
                String message = "Backend='" + this.m_connectData.getBackend() + "', User='" + this.m_connectData.getUser() + "', BSE='" + this.m_connectData.getBSE() + "', Bshell='" + this.m_connectData.getBshellName() + "', Port=" + this.m_connectData.getPort() + ", Company=" + this.m_connectData.getCompany();
                if (this.m_connectData.getTenant() != null && this.m_connectData.getTenant().length() > 0) {
                    message = message + ", Tenant=" + this.m_connectData.getTenant();
                }
                LOG.debug(Logger.EVENT_UNSPECIFIED, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

