/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.BODResponse;
import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.jca.RestResponse;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.BdeConnector;
import com.infor.erpln.protocol.DispatchBODResultImpl;
import com.infor.erpln.protocol.DispatchBdeResult;
import com.infor.erpln.protocol.DispatchBdeResultImpl;
import com.infor.erpln.protocol.DispatchRestResultImpl;
import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.LogUtil;
import com.infor.erpln.protocol.MessageServer;
import com.infor.erpln.protocol.RequestToken;
import com.infor.erpln.protocol.ThreeGLException;
import com.infor.erpln.util.StringUtils;
import com.infor.erpln.util.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class JcaHandlerImpl
implements JcaHandler {
    private MessageServer m_msgServer;
    private BdeConnector m_bdeConnector;
    private int m_bdeManId;
    private Exception m_exception;
    private int m_returnValue;
    private DispatchBdeResult m_BDEResult;
    private BODResponse m_BODResult;
    private RestResponse m_restResult;
    private boolean m_replyReceived;
    private boolean m_closed;
    private byte[] m_result;
    private RequestToken m_token;
    private static final int DISCONNECT_TIMEOUT = 40000;
    private int m_replyTimeout = 0;
    private static final Logger LOG = ESAPI.getLogger(JcaHandlerImpl.class);

    JcaHandlerImpl(MessageServer a_msgServer, BdeConnector a_bdeConnector, int a_bdeManId) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Construct JcaHandlerImpl");
        this.m_msgServer = a_msgServer;
        this.m_bdeConnector = a_bdeConnector;
        this.m_bdeManId = a_bdeManId;
        this.m_closed = false;
        this.m_token = new RequestToken();
        this.m_msgServer.addBdeManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DispatchBdeResult dispatchBDE(String a_bdeName, String a_bdeMethod, byte[] a_request) throws BaanConnectionException {
        DispatchBdeResult output = null;
        long start = 0L;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "dispatchBDE BdeName='" + a_bdeName + "' Method='" + a_bdeMethod + "'\n" + XmlUtil.getPrettyXml(a_request));
                    start = System.currentTimeMillis();
                }
                this.m_bdeConnector.sendDispatchBde(this.m_bdeManId, a_bdeName, a_bdeMethod, a_request);
                this.waitForReply(false);
                output = this.m_BDEResult;
                this.m_BDEResult = null;
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_SUCCESS, "BDE return value: '" + Integer.toString(output.getReturnValue()) + "'; duration (ms): " + (System.currentTimeMillis() - start) + "\n" + XmlUtil.getPrettyXml(output.getResponse()));
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BODResponse dispatchBOD(byte[] a_header, byte[] a_request) throws BaanConnectionException {
        BODResponse output = null;
        long start = 0L;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "dispatchBOD()\n-BOD Header- \n" + StringUtils.getString(a_header) + "\n-BOD message- \n" + XmlUtil.getPrettyXml(a_request));
                    start = System.currentTimeMillis();
                }
                this.m_msgServer.assertProtocolVersion(7);
                this.m_bdeConnector.sendDispatchHTTP(this.m_bdeManId, 28, a_header, a_request);
                this.waitForReply(false);
                output = this.m_BODResult;
                this.m_BODResult = null;
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_SUCCESS, "BOD HTTP Status code: '" + Integer.toString(output.getHTTPStatusCode()) + "'; duration (ms): " + (System.currentTimeMillis() - start) + "\n" + StringUtils.getString(output.getResponse()));
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponse dispatchRest(byte[] a_header, byte[] a_body) throws BaanConnectionException {
        RestResponse output = null;
        long start = 0L;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "dispatchRest()\n-Request-Header-\n" + StringUtils.getString(a_header) + "\n-Request-Body-\n" + StringUtils.getString(a_body) + "\n");
                    start = System.currentTimeMillis();
                }
                this.m_msgServer.assertProtocolVersion(8);
                this.m_bdeConnector.sendDispatchHTTP(this.m_bdeManId, 48, a_header, a_body);
                this.waitForReply(false);
                output = this.m_restResult;
                this.m_restResult = null;
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_SUCCESS, "Rest HTTP Status code: '" + Integer.toString(output.getHTTPStatusCode()) + "'; duration (ms): " + (System.currentTimeMillis() - start) + "\n-Reply-Header-\n" + StringUtils.getString(output.getHeaders()) + "\n-Reply-Body-\n" + StringUtils.getString(output.getBody()) + "\n");
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] executeBaanDll(byte[] a_request, Vector<String> a_errors, OutputStream a_dsMessages, Set<MessageOption> a_options) throws BaanConnectionException {
        byte[] result = null;
        long start = 0L;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                StringBuilder logMessage;
                if (LOG.isInfoEnabled()) {
                    logMessage = new StringBuilder("executeBaanDll() request");
                    LogUtil.appendXml(logMessage, a_options.contains((Object)MessageOption.HIDE_REQUEST_LOG), a_request);
                    LOG.info(Logger.EVENT_UNSPECIFIED, logMessage.toString());
                    start = System.currentTimeMillis();
                }
                this.m_msgServer.assertProtocolVersion(3);
                if (a_dsMessages != null) {
                    this.m_msgServer.setDsMessageCollecting();
                }
                this.m_result = null;
                this.m_bdeConnector.sendExecuteDll(this.m_bdeManId, a_request);
                this.waitForReply(false);
                result = this.m_result;
                if (a_errors != null) {
                    this.m_msgServer.getAndClearAllErrors(a_errors);
                }
                if (a_dsMessages != null) {
                    this.m_msgServer.fillDsMessageOutputStream(a_dsMessages);
                }
                if (LOG.isInfoEnabled()) {
                    logMessage = new StringBuilder("executeBaanDll() duration (ms): ");
                    logMessage.append(Long.toString(System.currentTimeMillis() - start)).append("; response");
                    LogUtil.appendXml(logMessage, a_options.contains((Object)MessageOption.HIDE_RESPONSE_LOG), this.m_result);
                    LOG.info(Logger.EVENT_SUCCESS, logMessage.toString());
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] executeSQLQuery(byte[] a_request, Vector<String> a_errors) throws BaanConnectionException {
        byte[] result = null;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "executeSQLQuery() request: \n\n" + XmlUtil.getPrettyXml(a_request));
                }
                this.m_msgServer.assertProtocolVersion(4);
                this.m_result = null;
                this.m_bdeConnector.sendExecuteQuery(this.m_bdeManId, a_request);
                this.waitForReply(false);
                result = this.m_result;
                if (a_errors != null) {
                    this.m_msgServer.getAndClearAllErrors(a_errors);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(Logger.EVENT_SUCCESS, "executeSQLQuery() response: \n\n" + XmlUtil.getPrettyXml(this.m_result));
                }
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startLocalTransaction() throws BaanConnectionException {
        int retVal = -1;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: startLocalTransaction()");
                this.m_returnValue = 0;
                this.m_bdeConnector.sendSimpleCommand(this.m_bdeManId, 20);
                this.waitForReply(false);
                retVal = this.m_returnValue;
                LOG.debug(Logger.EVENT_SUCCESS, "Leave: startLocalTransaction()");
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int abortLocalTransaction() throws BaanConnectionException {
        int retVal = -1;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: abortLocalTransaction()");
                this.m_returnValue = 0;
                this.m_bdeConnector.sendSimpleCommand(this.m_bdeManId, 22);
                this.waitForReply(false);
                retVal = this.m_returnValue;
                LOG.debug(Logger.EVENT_SUCCESS, "Leave: abortLocalTransaction()");
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commitLocalTransaction() throws BaanConnectionException {
        int retVal = -1;
        try {
            this.m_token.getRequestToken();
            JcaHandlerImpl jcaHandlerImpl = this;
            synchronized (jcaHandlerImpl) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: commitLocalTransaction()");
                this.m_returnValue = 0;
                this.m_bdeConnector.sendSimpleCommand(this.m_bdeManId, 24);
                this.waitForReply(false);
                retVal = this.m_returnValue;
                LOG.debug(Logger.EVENT_SUCCESS, "Leave: commitLocalTransaction()");
            }
        }
        finally {
            this.m_token.releaseRequestToken();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() throws BaanConnectionException {
        int retVal = -1;
        if (this.proceedWithClose()) {
            try {
                this.m_token.getRequestToken();
                JcaHandlerImpl jcaHandlerImpl = this;
                synchronized (jcaHandlerImpl) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: close()");
                    this.m_returnValue = 0;
                    this.m_bdeConnector.sendSimpleCommand(this.m_bdeManId, 26);
                    this.waitForReply(true);
                    retVal = this.m_returnValue;
                    LOG.debug(Logger.EVENT_SUCCESS, "Leave: close()");
                }
            }
            finally {
                this.m_token.releaseRequestToken();
            }
        }
        this.m_msgServer.removeBdeManager(this);
        return retVal;
    }

    @Override
    public boolean isRunning() {
        return !this.m_closed && this.m_msgServer.isRunning();
    }

    @Override
    public void setReplyTimeout(int timeout) {
        this.m_replyTimeout = timeout > 0 ? timeout * 1000 : 0;
    }

    private synchronized boolean proceedWithClose() {
        boolean retVal = false;
        if (this.isRunning()) {
            if (this.m_token.isBusy()) {
                this.signalException(new BaanConnectionException("Request still pending", 5));
            } else {
                retVal = true;
            }
        }
        return retVal;
    }

    private void waitForReply(boolean a_expectClose) throws BaanConnectionException {
        if (this.m_closed) {
            throw new BaanConnectionException("BdeManager Interface already closed", 6);
        }
        if (!this.m_msgServer.isRunning()) {
            this.checkForSessionTimeout(this.getErrorMessage());
            throw new BaanConnectionException("Bshell connection is lost", 5);
        }
        this.m_exception = null;
        this.m_replyReceived = false;
        while (!this.m_replyReceived && this.m_exception == null) {
            int waitTime = a_expectClose ? 40000 : this.m_replyTimeout;
            long timeoutTime = System.currentTimeMillis() + (long)waitTime;
            try {
                this.wait(waitTime);
                if (System.currentTimeMillis() < timeoutTime) continue;
                String error = "Waiting for reply timed out after " + waitTime / 1000 + " s";
                LOG.error(Logger.EVENT_FAILURE, error);
                this.m_exception = new IOException(error);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_exception != null) {
            this.throwBaanException();
        }
        if (!a_expectClose && this.m_closed) {
            String errorMessage = this.getErrorMessage();
            this.checkForSessionTimeout(errorMessage);
            throw new BaanConnectionException("Unexpected close of BDEManager" + errorMessage, 6);
        }
    }

    private void checkForSessionTimeout(String errorMessage) throws BaanConnectionException {
        if (errorMessage != null && errorMessage.toLowerCase().contains("session timeout timer")) {
            throw new BaanConnectionException("Bshell connection is lost (session timeout)", 8);
        }
    }

    private String getErrorMessage() {
        Vector<String> errors = new Vector<String>();
        this.m_msgServer.getAndClearAllErrors(errors);
        StringBuffer sb = new StringBuffer();
        if (!errors.isEmpty()) {
            Enumeration<String> elements = errors.elements();
            while (elements.hasMoreElements()) {
                sb.append('\n').append(elements.nextElement());
            }
        }
        return sb.toString();
    }

    public void dispatchReplyMessage(DsMessage dsMess) throws ThreeGLException {
        Hashtable attributes = dsMess.getAttributes();
        int frameIndicator = 0;
        int returnValue = 0;
        byte[] response = null;
        byte[] data = null;
        Enumeration e = attributes.elements();
        block17: while (e.hasMoreElements()) {
            DsAttribute attribute = (DsAttribute)e.nextElement();
            int attributeType = attribute.getType();
            switch (attributeType) {
                case 353: {
                    frameIndicator = attribute.getValueInt();
                    break;
                }
                case 52: {
                    returnValue = attribute.getValueInt();
                    break;
                }
                case 215: {
                    response = attribute.getValueVoid();
                    break;
                }
                case 33: {
                    data = attribute.getValueVoid();
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    continue block17;
                }
            }
            attributes.remove(new Integer(attributeType));
        }
        switch (frameIndicator) {
            case 27: {
                this.receiveBdeCloseReply(returnValue);
                break;
            }
            case 19: {
                this.receiveBdeDispReply(returnValue, response);
                break;
            }
            case 29: {
                this.receiveBodDispReply(returnValue, response);
                break;
            }
            case 49: {
                this.receiveRestDispReply(returnValue, data, response);
                break;
            }
            case 2: {
                this.receiveExecDllReply(response);
                break;
            }
            case 31: {
                this.receiveExecSqlReply(response);
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                this.receiveBdeSimpleReply(returnValue);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new ThreeGLException("Not supported value for DsNaction: " + frameIndicator);
            }
        }
    }

    public synchronized void receiveBdeSimpleReply(int a_returnValue) {
        this.m_returnValue = a_returnValue;
        this.m_replyReceived = true;
        this.notify();
    }

    public synchronized void receiveBdeCloseReply(int a_returnValue) {
        this.m_returnValue = a_returnValue;
        this.m_closed = true;
        this.m_replyReceived = true;
        this.notify();
    }

    private synchronized void receiveBdeDispReply(int a_returnValue, byte[] a_response) {
        this.m_BDEResult = new DispatchBdeResultImpl(a_returnValue, a_response);
        this.m_replyReceived = true;
        this.notify();
    }

    private synchronized void receiveBodDispReply(int a_httpStatusCode, byte[] a_response) {
        this.m_BODResult = new DispatchBODResultImpl(a_httpStatusCode, a_response);
        this.m_replyReceived = true;
        this.notify();
    }

    private synchronized void receiveRestDispReply(int a_httpStatusCode, byte[] a_headers, byte[] a_body) {
        this.m_restResult = new DispatchRestResultImpl(a_httpStatusCode, a_headers, a_body);
        this.m_replyReceived = true;
        this.notify();
    }

    private synchronized void receiveExecDllReply(byte[] a_response) {
        this.m_result = a_response;
        this.m_replyReceived = true;
        this.notify();
    }

    private synchronized void receiveExecSqlReply(byte[] a_response) {
        this.m_result = a_response;
        this.m_replyReceived = true;
        this.notify();
    }

    public int getBdeManId() {
        return this.m_bdeManId;
    }

    public synchronized void signalException(Exception a_exception) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "signalException");
        if (this.m_token.isBusy()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, "signalException notify waiting thread");
            this.m_exception = a_exception;
            this.notify();
        }
    }

    protected void throwBaanException() throws BaanConnectionException {
        if (this.m_exception instanceof IOException) {
            throw new BaanConnectionException(this.m_exception.toString(), 5);
        }
        if (this.m_exception instanceof ThreeGLException) {
            throw new BaanConnectionException(this.m_exception.toString(), 7);
        }
        throw new BaanConnectionException(this.m_exception.toString(), 6);
    }
}

