/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.DsConfig;
import com.infor.erpln.protocol.DsMessageServer;
import com.infor.erpln.protocol.DsNetReader;
import com.infor.erpln.protocol.DsNetWriter;
import com.infor.erpln.protocol.EISMetaData;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.QuotedStringTokenizer;
import com.infor.erpln.protocol.SSLFactoryCache;
import com.infor.erpln.protocol.SSLStoreParameters;
import com.infor.erpln.protocol.SessionLayer;
import com.infor.erpln.util.StringUtils;
import com.infor.erpln.util.encryption.PasswordEncryption;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class DsSessionLayer
implements SessionLayer {
    private static final Logger LOG = ESAPI.getLogger(DsSessionLayer.class);
    private Socket m_socket;
    private DataInputStream m_is;
    private DataOutputStream m_os;
    private Vector<String> m_ipcboot_args;
    private DsMessageServer m_mesServer;
    private int m_state;
    private String m_backend;
    private int m_portNumber;
    private int m_method;
    private String m_user;
    private String m_password;
    private String m_startupMessages;
    private final SSLStoreParameters m_storeParameters;
    private static final int MAXSTRLEN = 1024;
    private static final String IPC_BOOT = "/bin/ipc_boot";
    private static final String IPC_BOOT_VERSION = "6.2";
    private static final String BL_REQUEST_TAG = "BaaNLogin";
    private static final String BL_SAML_TAG = "SamlBaaNLogin";
    private static final int BL_PROTOCOL_VERSION_1 = 1;
    private static final int BL_PROTOCOL_VERSION_2 = 2;
    private static final int BL_ENCRYPT_CYPHER = 3;
    private static final int BL_LOGIN_USER = 1;
    private static final int BL_LOGIN_TENANT = 5;
    private static final int BL_VALIDATE_ONLY = 0;
    private static final int IDLE = 0;
    private static final int VALIDATED = 1;
    private static final int ESTABLISHED = 2;

    public DsSessionLayer(SSLStoreParameters storeParameters) {
        this.m_storeParameters = storeParameters;
        this.m_state = 0;
        LOG.info(Logger.EVENT_UNSPECIFIED, "Construct DsSessionLayer, initial state=" + this.getState());
    }

    @Override
    public boolean isValid() {
        return this.m_state == 2 && this.m_mesServer != null && this.m_mesServer.isRunning() && this.m_mesServer.getNumberProcesses() > 1;
    }

    @Override
    public void connect(ConnectionConfig a_connectData) throws BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            StringBuffer logmess = new StringBuffer();
            logmess.append("Setup connection: HOST='").append(a_connectData.getBackend()).append("', TYPE='").append(a_connectData.getConnectionMethodString()).append("(").append(a_connectData.getPort()).append(")', BSE='").append(a_connectData.getBSE()).append("'");
            StringUtils.addToBuf(logmess, "TENANT", a_connectData.getTenant());
            StringUtils.addToBuf(logmess, "CLIENTHOST", a_connectData.getClientLocationHost());
            StringUtils.addToBuf(logmess, "CLIENTIP", a_connectData.getClientLocationIP());
            StringUtils.addToBuf(logmess, "CLIENTLANGUAGE", a_connectData.getClientLanguage());
            StringUtils.addToBuf(logmess, "CLIENTLOCALE", a_connectData.getClientLocale());
            LOG.info(Logger.EVENT_UNSPECIFIED, logmess.toString());
        }
        if (this.m_state != 1 || this.m_socket == null || this.m_method != a_connectData.getConnectionMethod() || !this.m_user.equals(a_connectData.getUser()) || !this.m_password.equals(a_connectData.getPassword())) {
            this.connectSetup(a_connectData);
        }
        this.handleIpcBoot(a_connectData);
        this.handleBshellSetup(a_connectData);
        this.m_mesServer = new DsMessageServer(this.m_socket, new DsNetReader(this.m_is), new DsNetWriter(this.m_os), a_connectData);
        this.m_mesServer.start();
        Vector<String> errors = this.m_mesServer.waitForConnectorCreation();
        try {
            this.m_mesServer.initProtocol(4, a_connectData);
        }
        catch (BaanConnectionException e) {
            LOG.error(Logger.EVENT_FAILURE, "initProtocol failed", (Throwable)e);
            this.close();
            throw e;
        }
        this.m_state = 2;
        LOG.info(Logger.EVENT_SUCCESS, "connect: state changed to " + this.getState());
        if (!errors.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            Enumeration<String> e = errors.elements();
            while (e.hasMoreElements()) {
                String message = e.nextElement();
                buffer.append(message).append("\n");
                LOG.info(Logger.EVENT_UNSPECIFIED, message);
            }
            this.m_startupMessages = buffer.toString();
        }
    }

    @Override
    public void validate(ConnectionConfig a_connectData) throws BaanConnectionException {
        if (this.m_state != 0) {
            throw new BaanConnectionException("Illegal state for validate method, state=" + this.getState(), 6);
        }
        this.connectSetup(a_connectData);
        if (a_connectData.getConnectionMethod() == 1) {
            this.handleIpcBoot(a_connectData);
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.m_mesServer != null) {
            if (this.m_mesServer.isRunning()) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "close: stop message server");
                this.m_mesServer.stopServer();
            }
            this.m_mesServer = null;
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_socket = null;
        this.m_state = 0;
        LOG.info(Logger.EVENT_SUCCESS, "close: state changed to " + this.getState());
    }

    @Override
    public void activateListener(BDEConsumer iConsumer, byte[] iConsumerMetaData) throws BaanConnectionException {
        throw new BaanConnectionException("Not yet implemented", 6);
    }

    @Override
    public JcaHandler getBdeManager(int iCompany) throws BaanConnectionException {
        if (this.m_state != 2) {
            throw new BaanConnectionException("Not (yet) ready to accept requests, state=" + this.getState(), 6);
        }
        JcaHandler manager = this.m_mesServer.getBdeManager(iCompany);
        return manager;
    }

    @Override
    public InputStream openForRead(String a_serverFile, boolean a_textMode, boolean a_polling) throws IOException, BaanConnectionException {
        if (this.m_state != 2) {
            throw new BaanConnectionException("Not (yet) ready to accept requests, state=" + this.getState(), 6);
        }
        InputStream is = this.m_mesServer.openForRead(a_serverFile, a_textMode, a_polling);
        return is;
    }

    @Override
    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        if (this.m_state != 2) {
            throw new BaanConnectionException("Not (yet) ready to accept requests, state=" + this.getState(), 6);
        }
        OutputStream os = this.m_mesServer.openForWrite(a_serverFile, a_textMode);
        return os;
    }

    @Override
    public EISMetaData getMetaData() {
        return this.m_mesServer.getMetaData();
    }

    @Override
    public String getStartupMessages() {
        return this.m_startupMessages;
    }

    private String getState() {
        switch (this.m_state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "VALIDATED";
            }
            case 2: {
                return "ESTABLISHED";
            }
        }
        return "UNKNOWN";
    }

    private void connectSetup(ConnectionConfig a_connectData) throws BaanConnectionException {
        this.close();
        this.m_backend = a_connectData.getBackend();
        this.m_method = a_connectData.getConnectionMethod();
        this.m_user = a_connectData.getUser();
        this.m_password = a_connectData.getPassword();
        this.m_portNumber = this.m_method == 1 ? 512 : a_connectData.getPort();
        try {
            LOG.info(Logger.EVENT_UNSPECIFIED, "Creating socket connection; timeout = " + DsConfig.CONNECTION_TIMEOUT + " ms");
            this.m_socket = new Socket(this.m_backend, this.m_portNumber);
            this.m_socket.setTcpNoDelay(true);
            this.m_socket.setSoTimeout(DsConfig.CONNECTION_TIMEOUT);
            this.m_is = new DataInputStream(this.m_socket.getInputStream());
            this.m_os = new DataOutputStream(new BufferedOutputStream(this.m_socket.getOutputStream()));
        }
        catch (IOException e) {
            String message = "Connect with " + this.m_backend + " (port=" + this.m_portNumber + ") failed";
            LOG.error(Logger.EVENT_FAILURE, message, (Throwable)e);
            throw new BaanConnectionException(message, 1, e);
        }
        switch (a_connectData.getConnectionMethod()) {
            case 2: {
                if (a_connectData.getTenant() != null && a_connectData.getTenant().length() > 0) {
                    this.baanLogin2(a_connectData);
                    break;
                }
                this.baanLogin1(a_connectData);
                break;
            }
            case 8: {
                this.baanLoginSSL(a_connectData);
                break;
            }
            case 1: {
                this.rexec(a_connectData);
                break;
            }
            default: {
                throw new BaanConnectionException("Unsupported connection method: " + a_connectData.getConnectionMethod(), 1);
            }
        }
        this.m_state = 1;
        LOG.info(Logger.EVENT_SUCCESS, "connectSetup: state changed to " + this.getState());
    }

    private void rexec(ConnectionConfig a_connectData) throws BaanConnectionException {
        String response;
        if (a_connectData.getTenant() != null && a_connectData.getTenant().length() > 0) {
            throw new BaanConnectionException("Tenant not supported with rexec protocol", 6);
        }
        String cmd = a_connectData.getBSE() + IPC_BOOT + IPC_BOOT_VERSION;
        try {
            this.WriteNullString("");
            this.WriteNullString(a_connectData.getUser());
            this.WriteNullString(a_connectData.getPassword());
            this.WriteNullString(cmd);
            response = this.ReadNullString();
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connection broken during login", 5, e);
        }
        if (!response.equals("")) {
            throw new BaanConnectionException("Failed to login on Application Server\nResponse: " + response, 2);
        }
    }

    private void baanLogin1(ConnectionConfig a_connectData) throws BaanConnectionException {
        String response;
        String crptUsername = PasswordEncryption.getEncryptionPassword(a_connectData.getUser());
        String crptPassword = PasswordEncryption.getEncryptionPassword(a_connectData.getPassword());
        String cmd = a_connectData.getBSE() + IPC_BOOT;
        int sizeBlockBody = 2 + crptUsername.length() + 1 + crptPassword.length() + 1 + 2 + cmd.length() + 1 + IPC_BOOT_VERSION.length() + 1;
        try {
            this.WriteNullString(BL_REQUEST_TAG);
            this.m_os.writeShort(1);
            this.m_os.writeShort(sizeBlockBody);
            this.m_os.writeShort(3);
            this.WriteNullString(crptUsername);
            this.WriteNullString(crptPassword);
            this.m_os.writeShort(1);
            this.WriteNullString(cmd);
            this.WriteNullString(IPC_BOOT_VERSION);
            short protocolVersion = this.m_is.readShort();
            short restSize = this.m_is.readShort();
            if (protocolVersion != 1) {
                throw new BaanConnectionException("illegal BaanLogin protocol version:" + protocolVersion, 6);
            }
            short returnCode = this.m_is.readShort();
            response = this.ReadNullString();
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connection broken during login", 5, e);
        }
        if (!response.equals("")) {
            throw new BaanConnectionException("Failed to login on Application Server\nResponse: " + response, 2);
        }
    }

    private void baanLogin2(ConnectionConfig a_connectData) throws BaanConnectionException {
        String response;
        short returnCode;
        String crptUsername = PasswordEncryption.getEncryptionPassword(a_connectData.getUser());
        String crptAuthentication = PasswordEncryption.getEncryptionPassword(a_connectData.getPassword());
        String hostname = a_connectData.getBackend();
        String bse = a_connectData.getBSE();
        String tenant = a_connectData.getTenant();
        int sizeBlockBody = 2 + crptUsername.length() + 1 + crptAuthentication.length() + 1 + 2 + hostname.length() + 1 + bse.length() + 1 + tenant.length() + 1;
        try {
            this.WriteNullString(BL_REQUEST_TAG);
            this.m_os.writeShort(2);
            this.m_os.writeShort(sizeBlockBody);
            this.m_os.writeShort(3);
            this.WriteNullString(crptUsername);
            this.WriteNullString(crptAuthentication);
            this.m_os.writeShort(5);
            this.WriteNullString(hostname);
            this.WriteNullString(bse);
            this.WriteNullString(tenant);
            short protocolVersion = this.m_is.readShort();
            short restSize = this.m_is.readShort();
            if (protocolVersion != 1) {
                throw new BaanConnectionException("illegal BaanLogin protocol version:" + protocolVersion, 6);
            }
            returnCode = this.m_is.readShort();
            response = this.ReadNullString();
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connection broken during login", 5, e);
        }
        if (returnCode != 0) {
            throw new BaanConnectionException("Failed to login on Application Server\nReturnCode: " + returnCode + "\nResponse: " + response, 2);
        }
    }

    private void baanLoginSSL(ConnectionConfig a_connectData) throws BaanConnectionException {
        String response;
        short returnCode;
        String username = a_connectData.getUser();
        String saml = a_connectData.getPassword();
        String bse = a_connectData.getBSE();
        String tenant = a_connectData.getTenant();
        boolean hasTenant = tenant != null && tenant.length() > 0;
        try {
            short protocolVersion;
            this.WriteNullString(BL_SAML_TAG);
            this.m_os.writeShort(hasTenant ? 2 : 1);
            this.m_os.flush();
            SSLSocket sslSocket = this.getSSLClientSocket();
            LOG.debug(Logger.EVENT_UNSPECIFIED, "Start SSL Handshake");
            sslSocket.startHandshake();
            LOG.debug(Logger.EVENT_SUCCESS, "SSL Handshake Completed");
            DataInputStream isSaved = this.m_is;
            DataOutputStream osSaved = this.m_os;
            this.m_is = new DataInputStream(sslSocket.getInputStream());
            this.m_os = new DataOutputStream(new BufferedOutputStream(sslSocket.getOutputStream()));
            this.m_os.writeShort(1);
            this.WriteNullString(username);
            this.WriteNullString(saml);
            this.WriteNullString(bse);
            if (hasTenant) {
                this.WriteNullString(tenant);
            }
            if ((protocolVersion = this.m_is.readShort()) != 1) {
                throw new BaanConnectionException("illegal BaanLogin protocol version:" + protocolVersion, 6);
            }
            returnCode = this.m_is.readShort();
            response = this.ReadNullString();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Received BaanLogin reply, code: '" + returnCode + "' Response: " + response);
            }
            this.emptyInputStream();
            sslSocket.close();
            this.m_is = isSaved;
            this.m_os = osSaved;
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connection broken during login", 5, e);
        }
        if (returnCode != 0) {
            throw new BaanConnectionException("Failed to login on Application Server\nResponse: " + response, 2);
        }
    }

    private SSLSocket getSSLClientSocket() throws BaanConnectionException, IOException {
        SSLSocketFactory sslSocketFactory = this.getSSLSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.m_socket, this.m_socket.getInetAddress().getHostAddress(), this.m_socket.getPort(), false);
        sslSocket.setUseClientMode(true);
        return sslSocket;
    }

    private void WriteNullString(String str) throws IOException {
        String outputStr = str + "\u0000";
        byte[] byteBuffer = outputStr.getBytes("UTF-8");
        this.m_os.write(byteBuffer);
        this.m_os.flush();
    }

    private String ReadNullString() throws IOException {
        int i;
        byte[] buffer = new byte[1024];
        int c = this.m_is.read();
        for (i = 0; i < 1024 && c > 0; ++i) {
            buffer[i] = (byte)c;
            c = this.m_is.read();
        }
        String retstr = i > 0 ? new String(buffer, 0, i) : new String("");
        return retstr;
    }

    private void emptyInputStream() throws IOException {
        int c = this.m_is.read();
        while (c >= 0) {
            c = this.m_is.read();
        }
    }

    private void handleIpcBoot(ConnectionConfig a_connectData) throws BaanConnectionException {
        String response;
        try {
            this.initIPCargs(a_connectData);
            this.sendIPCargs();
            response = this.ReadNullString();
        }
        catch (IOException e) {
            throw new BaanConnectionException("Connection broken during ipc_boot", 3, e);
        }
        if (!response.equals("ipc_boot oke")) {
            throw new BaanConnectionException("Failed to connect to ipc_boot\nipc_boot returned: " + response, 3);
        }
    }

    private void initIPCargs(ConnectionConfig a_connectData) {
        String token;
        Object st;
        this.m_ipcboot_args = new Vector(14);
        this.m_ipcboot_args.addElement(a_connectData.getBshellName());
        this.m_ipcboot_args.addElement("0");
        this.m_ipcboot_args.addElement("549");
        this.m_ipcboot_args.addElement(a_connectData.getBSE());
        this.m_ipcboot_args.addElement(a_connectData.getUser());
        this.m_ipcboot_args.addElement(a_connectData.getUser());
        this.m_ipcboot_args.addElement("0");
        this.m_ipcboot_args.addElement("0");
        String id = a_connectData.getUser() + "@" + a_connectData.getClientLocationHost() + ":" + this.m_socket.getLocalPort();
        String s = id + "/SOCKET<" + id + ">";
        this.m_ipcboot_args.addElement(s);
        this.m_ipcboot_args.addElement("-dsunicode");
        this.m_ipcboot_args.addElement("-nodebug");
        if (a_connectData.getCommand() != null) {
            st = new QuotedStringTokenizer(a_connectData.getCommand());
            while (((QuotedStringTokenizer)st).hasMoreTokens()) {
                token = new String(((QuotedStringTokenizer)st).nextToken());
                if (token.equals("--")) continue;
                this.m_ipcboot_args.addElement(token);
            }
        }
        this.m_ipcboot_args.addElement("-set");
        this.m_ipcboot_args.addElement("BSHELL_TAG=" + a_connectData.getBshellName());
        this.m_ipcboot_args.addElement("ottstpjcadaemon");
        if (a_connectData.getDaemonOptions() != null) {
            st = new StringTokenizer(a_connectData.getDaemonOptions());
            while (((StringTokenizer)st).hasMoreTokens()) {
                token = new String(((StringTokenizer)st).nextToken());
                this.m_ipcboot_args.addElement(token);
            }
        }
    }

    private void sendIPCargs() throws IOException {
        int i = this.m_ipcboot_args.size();
        this.WriteNullString(Integer.toString(i));
        while (i > 0) {
            this.WriteNullString(this.m_ipcboot_args.elementAt(--i));
        }
    }

    private void handleBshellSetup(ConnectionConfig a_connectData) throws BaanConnectionException {
        try {
            String response = this.ReadNullString();
            if (!response.equals("server oke")) {
                throw new BaanConnectionException("Failed to connect to bshell: " + a_connectData.getBshellName() + "\nbshell returned: " + response, 4);
            }
            this.WriteNullString(a_connectData.getBackend() + "!" + a_connectData.getBshellName());
            response = this.ReadNullString();
            if ("OK SSL".equals(response)) {
                this.upgradeToSSL();
            } else if (!"O.K.".equals(response)) {
                throw new BaanConnectionException("Failed to connect to bshell: " + a_connectData.getBshellName() + "\nbshell returned: " + response, 4);
            }
            this.WriteNullString("O.K.");
            this.m_socket.setSoTimeout(0);
        }
        catch (IOException e) {
            throw new BaanConnectionException("Failed to connect to bshell: " + a_connectData.getBshellName(), 5, e);
        }
    }

    private void upgradeToSSL() throws BaanConnectionException, IOException {
        SSLSocket sslSocket = this.getSSLClientSocket();
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Start SSL Handshake with Bshell");
        sslSocket.startHandshake();
        LOG.debug(Logger.EVENT_SUCCESS, "SSL Handshake Completed with Bshell");
        this.m_is = new DataInputStream(sslSocket.getInputStream());
        this.m_os = new DataOutputStream(new BufferedOutputStream(sslSocket.getOutputStream()));
    }

    private SSLSocketFactory getSSLSocketFactory() throws BaanConnectionException {
        SSLFactoryCache factoryCache = SSLFactoryCache.getInstance();
        return factoryCache.getSSLSocketFactory(this.m_storeParameters);
    }
}

