/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.ThreeGLException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class DsNetWriter {
    private DataOutputStream m_os;
    private static final Logger LOG = ESAPI.getLogger(DsNetWriter.class);
    private static final int SHORT_PARAM = 0;
    private static final int INT_PARAM = 1;
    private static int[][] s_mouseParams = new int[][]{{3, 0}, {4, 0}, {271, 1}, {270, 1}, {115, 0}, {116, 0}};
    private static int[][] s_motionParams = new int[][]{{3, 0}, {4, 0}, {270, 1}, {115, 0}, {116, 0}};
    private static int[][] s_keyPressParams = new int[][]{{52, 1}, {270, 0}};
    private static int[][] s_resizeWindowParams = new int[][]{{20, 0}, {19, 0}, {5, 0}, {6, 0}};
    private static int[][] s_selectParams = new int[][]{{52, 0}};
    private static int[][] s_buttonParams = new int[][]{{271, 0}, {270, 0}, {58, 0}};
    private static int[][] s_scrollbarSelectParams = new int[][]{{88, 0}, {52, 1}};
    private static int[][] s_listboxSelectParams = new int[][]{{87, 1}, {137, 1}, {252, 0}};
    private static int[][] s_changeFocusParams = new int[][]{{52, 1}};
    private static int[][] s_gridEventParams = new int[][]{{17, 1}, {18, 1}, {5, 1}, {6, 1}, {183, 1}, {185, 1}, {184, 1}, {186, 1}, {50, 0}, {252, 0}};
    private static int[][] s_helpEventParams = new int[][]{{52, 1}, {17, 1}, {18, 1}, {252, 1}};
    private static int[][] s_terminationParams = new int[][]{{252, 1}, {245, 1}};
    private static int[][] s_oleEventParams = new int[][]{{252, 1}, {39, 1}, {244, 1}, {25, 1}};
    private static int[][] s_noEventParams = new int[0][];
    private static final Hashtable<Integer, int[][]> s_events = new Hashtable(25);

    public DsNetWriter(DataOutputStream os) {
        this.m_os = os;
    }

    public synchronized void writeMessage(DsMessage dsMes) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Logger.EVENT_UNSPECIFIED, dsMes.toString());
        }
        this.writeMessNumber();
        int family = dsMes.getFamily();
        this.m_os.writeShort(family);
        switch (family) {
            case 1: 
            case 3: 
            case 5: 
            case 10: {
                this.writeCommonMessage(dsMes);
                break;
            }
            case 4: {
                this.writeEvent(dsMes);
                break;
            }
            case 6: {
                this.writeSignal(dsMes);
                break;
            }
            case 8: {
                this.writeFatalError(dsMes);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new IOException("Not supported message family: " + family);
            }
        }
        if (dsMes.getFlush()) {
            this.m_os.flush();
        }
    }

    private void writeMessNumber() throws IOException {
        this.m_os.writeByte(154);
        this.m_os.writeByte(234);
    }

    private void writeCommonMessage(DsMessage dsMes) throws IOException {
        this.m_os.writeShort(dsMes.getType());
        this.m_os.writeInt(dsMes.getPid());
        this.m_os.writeInt(dsMes.getOid());
        Hashtable attributes = dsMes.getAttributes();
        if (attributes != null) {
            int numAttributes = attributes.size();
            this.m_os.writeInt(numAttributes);
            Enumeration e = attributes.elements();
            while (e.hasMoreElements()) {
                DsAttribute attr = (DsAttribute)e.nextElement();
                this.writeAttribute(attr);
            }
        } else {
            this.m_os.writeInt(0);
        }
    }

    private void writeAttribute(DsAttribute attr) throws IOException {
        int attrType = attr.getType();
        this.m_os.writeShort(attrType);
        int dataType = attr.getDataType();
        switch (dataType) {
            case 1: 
            case 2: {
                this.m_os.writeInt(attr.getValueInt());
                break;
            }
            case 3: {
                try {
                    this.writeString(attr.getValueString());
                }
                catch (ThreeGLException threeGLException) {}
                break;
            }
            case 4: {
                this.writeVoid(attr.getValueVoid());
                break;
            }
            case 5: {
                this.writeShortArray(attr.getValueShortArray());
                break;
            }
            case 6: 
            case 8: {
                this.writeIntArray(attr.getValueIntArray());
                break;
            }
            default: {
                throw new IOException("Illegal attribute datatype: " + dataType + "for attribute: " + attrType);
            }
        }
    }

    private void writeString(String str) throws IOException {
        this.m_os.writeUTF(str);
    }

    private void writeVoid(byte[] value) throws IOException {
        this.m_os.writeInt(value.length);
        this.m_os.write(value, 0, value.length);
    }

    private void writeShortArray(short[] value) throws IOException {
        this.m_os.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.m_os.writeShort(value[i]);
        }
    }

    private void writeIntArray(int[] value) throws IOException {
        this.m_os.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.m_os.writeInt(value[i]);
        }
    }

    private void writeEvent(DsMessage dsMes) throws IOException {
        this.m_os.writeShort(dsMes.getType());
        this.m_os.writeInt(dsMes.getPid());
        this.m_os.writeInt(dsMes.getOid());
        int[][] eventParams = s_events.get(new Integer(dsMes.getType()));
        if (eventParams != null) {
            for (int i = 0; i < eventParams.length; ++i) {
                DsAttribute attr = dsMes.getAttribute(eventParams[i][0]);
                int value = 0;
                if (attr != null) {
                    value = attr.getValueInt();
                }
                if (eventParams[i][1] == 1) {
                    this.m_os.writeInt(value);
                    continue;
                }
                this.m_os.writeShort(value);
            }
        }
    }

    private void writeSignal(DsMessage dsMes) throws IOException {
        this.m_os.writeShort(dsMes.getType());
        this.m_os.writeInt(dsMes.getPid());
        this.m_os.writeInt(dsMes.getOid());
    }

    private void writeFatalError(DsMessage dsMes) throws IOException {
        this.m_os.writeInt(dsMes.getPid());
        this.m_os.writeInt(dsMes.getOid());
    }

    static {
        s_events.put(new Integer(1), s_mouseParams);
        s_events.put(new Integer(14), s_mouseParams);
        s_events.put(new Integer(2), s_mouseParams);
        s_events.put(new Integer(3), s_motionParams);
        s_events.put(new Integer(4), s_keyPressParams);
        s_events.put(new Integer(6), s_resizeWindowParams);
        s_events.put(new Integer(7), s_selectParams);
        s_events.put(new Integer(17), s_buttonParams);
        s_events.put(new Integer(31), s_selectParams);
        s_events.put(new Integer(8), s_noEventParams);
        s_events.put(new Integer(9), s_scrollbarSelectParams);
        s_events.put(new Integer(21), s_scrollbarSelectParams);
        s_events.put(new Integer(23), s_listboxSelectParams);
        s_events.put(new Integer(33), s_listboxSelectParams);
        s_events.put(new Integer(20), s_changeFocusParams);
        s_events.put(new Integer(12), s_noEventParams);
        s_events.put(new Integer(29), s_gridEventParams);
        s_events.put(new Integer(32), s_helpEventParams);
        s_events.put(new Integer(28), s_terminationParams);
        s_events.put(new Integer(27), s_oleEventParams);
    }
}

