/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsConfig;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.DsNetReader;
import com.infor.erpln.protocol.DsNetWriter;
import com.infor.erpln.protocol.DsObject;
import com.infor.erpln.protocol.DsProcess;
import com.infor.erpln.protocol.MessageServer;
import com.infor.erpln.protocol.ThreeGLException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class DsMessageServer
extends MessageServer {
    private DsNetWriter m_netWriter;
    private Hashtable<Integer, DsProcess> m_processTable = new Hashtable();
    private Vector<DsMessage> m_dsMessageCollector;
    private static final Logger LOG = ESAPI.getLogger(DsMessageServer.class);
    private static final int DS_BW = 3;
    private static final int DS_OSWEBTOP = 5;
    private static final String PORTINGSET = "6.2.01";
    private static final int DS_GRAPHICS = 1;
    private static final int DS_HAS_MENUS = 2;
    private static final int DS_HAS_BUTTONS = 4;
    private static final int DS_RESIZABLE = 8;
    private static final int DS_MESSAGE = 1;
    private static final int DS_WARNING = 2;
    private static final int DS_ERROR = 3;
    private static final int DS_FATAL_ERROR = 4;

    public DsMessageServer(Socket a_socket, DsNetReader a_netReader, DsNetWriter a_netWriter, ConnectionConfig a_connectData) {
        super(a_socket, a_netReader, a_connectData);
        this.m_netWriter = a_netWriter;
    }

    public int getNumberProcesses() {
        return this.m_processTable.size();
    }

    public boolean processExists(String name) {
        Enumeration<DsProcess> e = this.m_processTable.elements();
        while (e.hasMoreElements()) {
            DsProcess process = e.nextElement();
            if (!process.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized Vector<String> waitForConnectorCreation() throws BaanConnectionException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: waitForConnectorCreation()");
        Vector<String> result = new Vector<String>();
        while (this.m_running && this.m_connector == null && this.m_exception == null) {
            long timeoutTime = System.currentTimeMillis() + (long)DsConfig.CONNECTION_TIMEOUT;
            try {
                this.wait(DsConfig.CONNECTION_TIMEOUT);
                if (System.currentTimeMillis() < timeoutTime) continue;
                String errorMsg = "Connection Timeout (" + DsConfig.CONNECTION_TIMEOUT + " ms)";
                LOG.error(Logger.EVENT_FAILURE, errorMsg);
                this.m_exception = new IOException(errorMsg);
                this.stopServer();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_exception != null) {
            this.throwBaanException();
        }
        if (!this.m_errors.isEmpty()) {
            result.addAll(this.m_errors);
        }
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: waitForConnectorCreation()");
        return result;
    }

    public void removeObject(DsObject object) {
        Enumeration<DsProcess> e = this.m_processTable.elements();
        while (e.hasMoreElements()) {
            DsProcess process = e.nextElement();
            process.removeObject(object);
        }
    }

    public DsProcess getProcess(int pid) {
        return this.m_processTable.get(new Integer(pid));
    }

    public void sendEvent(DsMessage event) {
        try {
            this.m_netWriter.writeMessage(event);
        }
        catch (IOException e) {
            this.signalException(e);
        }
    }

    public int objectReferenceCount(int oid) {
        int retval = 0;
        Enumeration<DsProcess> e = this.m_processTable.elements();
        while (e.hasMoreElements()) {
            DsProcess process = e.nextElement();
            if (process.getObject(oid) == null) continue;
            ++retval;
        }
        return retval;
    }

    public void killProcess(int pid, String feature) {
        DsMessage signal = new DsMessage();
        signal.setSignal(1, pid, 0);
        try {
            this.m_netWriter.writeMessage(signal);
        }
        catch (IOException e) {
            this.signalException(e);
        }
    }

    @Override
    public void run() {
        this.logConnectionData();
        while (this.m_running) {
            try {
                DsMessage request = this.m_netReader.readMessage();
                DsMessage reply = null;
                try {
                    reply = this.handleIncomingMessage(request);
                }
                catch (ThreeGLException e) {
                    this.m_errors.add(new String("3GL programming error for " + request.getName() + ": " + e.getMessage()));
                    if (request.expectReply()) {
                        reply = new DsMessage();
                        reply.setErrorReply(request);
                    }
                    this.signalException(e);
                }
                if (reply == null) continue;
                this.logConnectionData();
                this.m_netWriter.writeMessage(reply);
            }
            catch (IOException e) {
                if (!this.m_running) continue;
                this.signalException(e);
            }
        }
    }

    @Override
    public synchronized void stopServer() {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Enter: stopServer()");
        if (this.m_connector != null) {
            this.m_connector.sendStopConnector();
            try {
                this.wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.stopServer();
        LOG.debug(Logger.EVENT_SUCCESS, "Leave: stopServer()");
    }

    @Override
    public void setDsMessageCollecting() {
        this.m_dsMessageCollector = new Vector();
    }

    @Override
    public void fillDsMessageOutputStream(OutputStream a_dsMessages) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "fillDsMessageOutputStream()");
        if (this.m_dsMessageCollector != null) {
            try {
                DsNetWriter writer = new DsNetWriter(new DataOutputStream(a_dsMessages));
                for (DsMessage mess : this.m_dsMessageCollector) {
                    writer.writeMessage(mess);
                }
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "IOException caught in fillDsMessageOutputStream()", (Throwable)e);
            }
            this.m_dsMessageCollector.clear();
            this.m_dsMessageCollector = null;
        }
    }

    private DsMessage handleIncomingMessage(DsMessage request) throws ThreeGLException {
        DsMessage reply = null;
        block0 : switch (request.getFamily()) {
            case 1: {
                if (this.m_dsMessageCollector != null) {
                    this.handleCharMessage(request);
                }
                switch (request.getType()) {
                    case 0: {
                        reply = this.initServer(request);
                        break block0;
                    }
                    case 10: {
                        this.closeServer(request);
                        break block0;
                    }
                    case 1: {
                        this.createProcess(request);
                        break block0;
                    }
                    case 8: {
                        this.destroyProcess(request);
                        break block0;
                    }
                    case 20: {
                        this.logConnectionData();
                        this.sendMessage(request);
                        break block0;
                    }
                    case 34: {
                        reply = DsObject.getObjectClassList(request);
                        break block0;
                    }
                    case 35: {
                        reply = DsObject.getObjectClass(request);
                        break block0;
                    }
                    case 36: {
                        reply = DsObject.getSubObjectClass(request);
                        break block0;
                    }
                    case 37: {
                        reply = DsAttribute.getResource(request);
                        break block0;
                    }
                    case 39: {
                        reply = DsMessage.getEventClass(request);
                        break block0;
                    }
                    case 2: 
                    case 7: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 18: {
                        reply = this.dispatchToProcess(request);
                        break block0;
                    }
                    case 11: 
                    case 19: {
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 12: 
                    case 16: 
                    case 17: 
                    case 21: 
                    case 22: 
                    case 33: 
                    case 38: 
                    case 40: 
                    case 41: {
                        throw new ThreeGLException("request no longer supported");
                    }
                }
                reply = this.dispatchToProcess(request);
                break;
            }
            case 7: {
                reply = request;
            }
        }
        return reply;
    }

    private void handleCharMessage(DsMessage request) throws ThreeGLException {
        boolean add = false;
        int pid = request.getPid();
        switch (request.getType()) {
            case 23: {
                DsAttribute title;
                DsAttribute attrType = request.getAttribute(67);
                if (attrType == null || attrType.getValueInt() != 2 || (title = request.getAttribute(15)) == null || !"charwindow".equals(title.getValueString())) break;
                add = true;
                break;
            }
            case 24: {
                DsAttribute processGroup = request.getAttribute(55);
                if (processGroup == null) break;
                pid = processGroup.getValueInt();
                break;
            }
            case 25: 
            case 30: 
            case 31: {
                return;
            }
        }
        DsProcess process = this.getProcess(pid);
        if (add || process != null && process.isCharmode()) {
            this.m_dsMessageCollector.addElement(request.clone());
        }
    }

    private DsMessage initServer(DsMessage request) throws ThreeGLException {
        String clientLocale;
        DsProcess initProcess = new DsProcess(this, request.getPid(), "init process");
        this.m_processTable.put(new Integer(request.getPid()), initProcess);
        DsMessage reply = new DsMessage();
        reply.setReply(request);
        short[] displayInfo = new short[]{1024, 768, 0, 0, Short.MAX_VALUE, 128, 5, 0};
        DsAttribute shortArray = new DsAttribute(42);
        shortArray.setValue(displayInfo);
        reply.addAttribute(shortArray);
        DsAttribute serverType = new DsAttribute(61);
        serverType.setValue(3);
        reply.addAttribute(serverType);
        DsAttribute serverVersion = new DsAttribute(62);
        serverVersion.setValue(PORTINGSET);
        reply.addAttribute(serverVersion);
        DsAttribute progId = new DsAttribute(210);
        progId.setValue("Baan.Application");
        reply.addAttribute(progId);
        DsAttribute flags = new DsAttribute(50);
        flags.setValue(15);
        reply.addAttribute(flags);
        DsAttribute clientAddr = new DsAttribute(14);
        clientAddr.setValue(this.m_connectData.getClientLocationIP());
        reply.addAttribute(clientAddr);
        String clientLanguage = this.m_connectData.getClientLanguage();
        if (clientLanguage.length() > 0) {
            DsAttribute clientLang = new DsAttribute(22);
            clientLang.setValue(clientLanguage);
            reply.addAttribute(clientLang);
        }
        if ((clientLocale = this.m_connectData.getClientLocale()).length() > 0) {
            DsAttribute clientLoc = new DsAttribute(200);
            clientLoc.setValue(clientLocale);
            reply.addAttribute(clientLoc);
        }
        return reply;
    }

    private synchronized void closeServer(DsMessage request) {
        this.m_running = false;
        Enumeration<DsProcess> e = this.m_processTable.elements();
        while (e.hasMoreElements()) {
            DsProcess process = e.nextElement();
            process.dispose();
        }
        this.notify();
    }

    private void createProcess(DsMessage request) throws ThreeGLException {
        int pid = request.getPid();
        DsAttribute attr = request.getAttribute(14);
        if (attr == null) {
            throw new ThreeGLException("Process " + pid + " has no name");
        }
        String procName = attr.getValueString();
        DsProcess newProcess = new DsProcess(this, pid, procName);
        if (procName.equals("ttaad4500") || procName.equals("ttaad4100") || procName.equals("ottstpmess")) {
            newProcess.setCharmode(true);
        }
        this.m_processTable.put(new Integer(pid), newProcess);
    }

    private void destroyProcess(DsMessage request) throws ThreeGLException {
        int pid = request.getPid();
        DsProcess process = this.m_processTable.get(new Integer(pid));
        if (process == null) {
            throw new ThreeGLException("Invalid process identifier " + pid);
        }
        process.dispose();
        this.m_processTable.remove(new Integer(pid));
    }

    private void sendMessage(DsMessage request) throws ThreeGLException {
        StringBuffer sb = new StringBuffer();
        int pid = request.getPid();
        if (pid != 0) {
            sb.append("Process " + pid + " - ");
        }
        DsAttribute type = request.getAttribute(36);
        int msgType = 3;
        if (type != null) {
            msgType = type.getValueInt();
        }
        switch (msgType) {
            case 1: {
                sb.append("Message");
                break;
            }
            case 2: {
                sb.append("Warning");
                break;
            }
            case 4: {
                sb.append("Fatal Error");
                break;
            }
            default: {
                sb.append("Error");
            }
        }
        sb.append(" : ");
        DsAttribute text = request.getAttribute(11);
        String msgText = "?";
        if (text != null) {
            msgText = text.getValueString();
        }
        sb.append(msgText);
        this.m_errors.add(new String(sb));
    }

    private DsMessage dispatchToProcess(DsMessage request) throws ThreeGLException {
        int pid = request.getPid();
        DsProcess process = this.m_processTable.get(new Integer(pid));
        if (process == null) {
            throw new ThreeGLException("Invalid process identifier " + pid);
        }
        return process.handleIncomingMessage(request);
    }
}

