/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.protocol.Connector;
import com.infor.erpln.protocol.DsAttribute;
import com.infor.erpln.protocol.DsMessage;
import com.infor.erpln.protocol.DsMessageServer;
import com.infor.erpln.protocol.DsObject;
import com.infor.erpln.protocol.ThreeGLException;
import java.util.Hashtable;

public class DsConnector
extends DsObject
implements Connector {
    private static final int[][] s_attributeList = new int[][]{{67, 4}, {7, 3}, {215, 2}, {353, 2}, {349, 2}, {50, 2}, {244, 2}, {223, 2}, {200, 2}, {8, 2}, {62, 2}, {15, 2}, {52, 2}, {274, 2}};
    private static final Hashtable s_attributeTable = DsConnector.createAttributeHashTable(s_attributeList);
    private int m_pid;
    private int m_protocolVersion = 1;

    public DsConnector(DsMessageServer msgServer, int oid, String name) {
        super(msgServer, oid, name);
        this.m_type = 61;
    }

    public static int[][] getAttributeList() {
        return s_attributeList;
    }

    @Override
    protected Hashtable getAttributeTable() {
        return s_attributeTable;
    }

    @Override
    protected void initObject(DsMessage request) throws ThreeGLException {
        this.m_msgServer.setConnectorObject(this);
    }

    @Override
    protected void changeObject(DsMessage request) throws ThreeGLException {
        if (request.getType() == 24) {
            this.m_msgServer.dispatchReplyMessage(request);
        } else {
            Hashtable attributes = request.getAttributes();
            attributes.remove(new Integer(7));
        }
        super.changeObject(request);
    }

    public void setPid(int a_pid) {
        this.m_pid = a_pid;
    }

    @Override
    protected int getProcessGroup() {
        return this.m_pid;
    }

    @Override
    public void sendInitProtocol(int a_protocolVersion, ConnectionConfig a_connectData) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(14);
        event.addAttribute(attr);
        attr = new DsAttribute(223);
        attr.setValue(a_protocolVersion);
        event.addAttribute(attr);
        attr = new DsAttribute(343);
        attr.setValue(a_connectData.getCompany());
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendOpenBdeRequest(int iCompany) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(16);
        event.addAttribute(attr);
        if (this.m_protocolVersion > 1) {
            attr = new DsAttribute(343);
            attr.setValue(iCompany);
            event.addAttribute(attr);
        }
        this.sendEvent(event, true);
    }

    @Override
    public void sendOpenFileRequest(String a_serverFile, int a_mode, boolean a_polling) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        if (a_polling) {
            attr.setValue(12);
        } else {
            attr.setValue(3);
        }
        event.addAttribute(attr);
        attr = new DsAttribute(246);
        attr.setValue(a_serverFile);
        event.addAttribute(attr);
        attr = new DsAttribute(38);
        attr.setValue(a_mode);
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendReadRequest(int a_fileId) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(5);
        event.addAttribute(attr);
        attr = new DsAttribute(349);
        attr.setValue(a_fileId);
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendWriteRequest(int a_fileId, boolean a_eof, byte[] a_buffer) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(7);
        event.addAttribute(attr);
        attr = new DsAttribute(349);
        attr.setValue(a_fileId);
        event.addAttribute(attr);
        attr = new DsAttribute(50);
        attr.setValue(a_eof ? 1 : 0);
        event.addAttribute(attr);
        attr = new DsAttribute(215);
        attr.setValue(a_buffer);
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendCloseRequest(int a_fileId) {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(9);
        event.addAttribute(attr);
        attr = new DsAttribute(349);
        attr.setValue(a_fileId);
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendStopConnector() {
        DsMessage event = new DsMessage();
        event.setOleEvent();
        DsAttribute attr = new DsAttribute(353);
        attr.setValue(11);
        event.addAttribute(attr);
        this.sendEvent(event, true);
    }

    @Override
    public void sendPubInitAck(int a_consumerVersion, int a_returnValue, byte[] a_metaData) {
    }

    @Override
    public void sendPubBdeAck(int a_returnValue) {
    }

    @Override
    public void setProtocolVersion(int iVersion) {
        this.m_protocolVersion = iVersion;
    }

    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }
}

