/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.protocol;

public class BaanConnectionException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int HOST_ERROR = 1;
    public static final int LOGIN_ERROR = 2;
    public static final int IPCBOOT_ERROR = 3;
    public static final int BSHELL_ERROR = 4;
    public static final int COMM_ERROR_BSHELL = 5;
    public static final int COMM_ERROR_HANDLER = 6;
    public static final int APPL_ERROR = 7;
    public static final int SESSION_TIMEOUT = 8;
    private int m_reason;

    public BaanConnectionException(String a_message, int a_reason, Exception e_cause) {
        super(a_message, e_cause);
        this.m_reason = a_reason;
    }

    public BaanConnectionException(String a_message, int a_reason) {
        super(a_message);
        this.m_reason = a_reason;
    }

    public int getReason() {
        return this.m_reason;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("com.infor.erpln.protocol.BaanConnectionException[").append(this.reasonToStr()).append("]: ");
        toString.append(this.getMessage());
        return toString.toString();
    }

    private String reasonToStr() {
        switch (this.m_reason) {
            case 1: {
                return "HOST_ERROR";
            }
            case 2: {
                return "LOGIN_ERROR";
            }
            case 3: {
                return "IPCBOOT_ERROR";
            }
            case 4: {
                return "BSHELL_ERROR";
            }
            case 5: {
                return "COMM_ERROR_BSHELL";
            }
            case 6: {
                return "COMM_ERROR_HANDLER";
            }
            case 7: {
                return "APPL_ERROR";
            }
            case 8: {
                return "SESSION_TIMEOUT";
            }
        }
        return "<unknown>";
    }
}

