/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.StandardLevel;
import org.owasp.esapi.Logger;

public class Log4J2Logger
implements Logger {
    private final org.apache.logging.log4j.Logger m_logger;

    public Log4J2Logger(Class clazz) {
        this.m_logger = LogManager.getLogger((Class)clazz);
    }

    public Log4J2Logger(String moduleName) {
        this.m_logger = LogManager.getLogger((String)moduleName);
    }

    Log4J2Logger(org.apache.logging.log4j.Logger logger) {
        this.m_logger = logger;
    }

    public void setLevel(int level) {
        throw new UnsupportedOperationException("This method must be implemented in a subclass.");
    }

    protected org.apache.logging.log4j.Logger getLog4JLogger() {
        return this.m_logger;
    }

    protected static Level convertESAPILeveltoLoggerLevel(int level) {
        switch (level) {
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
            case 1000: {
                return Level.FATAL;
            }
            case 800: {
                return Level.ERROR;
            }
            case 600: {
                return Level.WARN;
            }
            case 400: {
                return Level.INFO;
            }
            case 200: {
                return Level.DEBUG;
            }
            case 100: {
                return Level.TRACE;
            }
            case -2147483648: {
                return Level.ALL;
            }
        }
        throw new IllegalArgumentException("Invalid logging level. Value was: " + level);
    }

    public int getESAPILevel() {
        int level = this.m_logger.getLevel().getStandardLevel().intLevel();
        int esapiLevel = level == StandardLevel.OFF.intLevel() ? Integer.MAX_VALUE : (level == StandardLevel.FATAL.intLevel() ? 1000 : (level == StandardLevel.ERROR.intLevel() ? 800 : (level == StandardLevel.WARN.intLevel() ? 600 : (level == StandardLevel.INFO.intLevel() ? 400 : (level == StandardLevel.DEBUG.intLevel() ? 200 : (level == StandardLevel.TRACE.intLevel() ? 100 : Integer.MIN_VALUE))))));
        return esapiLevel;
    }

    public void fatal(Logger.EventType type, String message) {
        this.m_logger.atFatal().log(this.getFullMessage(type, Log4J2Logger.sanitized(message)));
    }

    public void fatal(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atFatal().log(this.getFullMessage(type, Log4J2Logger.sanitized(message), throwable));
    }

    public boolean isFatalEnabled() {
        return this.m_logger.isFatalEnabled();
    }

    public void error(Logger.EventType type, String message) {
        this.m_logger.atError().log(this.getFullMessage(type, Log4J2Logger.sanitized(message)));
    }

    public void error(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atError().log(this.getFullMessage(type, Log4J2Logger.sanitized(message), throwable));
    }

    public boolean isErrorEnabled() {
        return this.m_logger.isErrorEnabled();
    }

    public void warning(Logger.EventType type, String message) {
        this.m_logger.atWarn().log(this.getFullMessage(type, Log4J2Logger.sanitized(message)));
    }

    public void warning(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atWarn().log(this.getFullMessage(type, Log4J2Logger.sanitized(message), throwable));
    }

    public boolean isWarningEnabled() {
        return this.m_logger.isWarnEnabled();
    }

    public void info(Logger.EventType type, String message) {
        this.m_logger.atInfo().log(this.getFullMessage(type, message));
    }

    public void info(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atInfo().log(this.getFullMessage(type, message, throwable));
    }

    public boolean isInfoEnabled() {
        return this.m_logger.isInfoEnabled();
    }

    public void debug(Logger.EventType type, String message) {
        this.m_logger.atDebug().log(this.getFullMessage(type, message));
    }

    public void debug(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atDebug().log(this.getFullMessage(type, message, throwable));
    }

    public boolean isDebugEnabled() {
        return this.m_logger.isDebugEnabled();
    }

    public void trace(Logger.EventType type, String message) {
        this.m_logger.atTrace().log(this.getFullMessage(type, Log4J2Logger.sanitized(message)));
    }

    public void trace(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.atTrace().log(this.getFullMessage(type, Log4J2Logger.sanitized(message), throwable));
    }

    public boolean isTraceEnabled() {
        return this.m_logger.isTraceEnabled();
    }

    public void always(Logger.EventType type, String message) {
        this.m_logger.always().log(this.getFullMessage(type, Log4J2Logger.sanitized(message)));
    }

    public void always(Logger.EventType type, String message, Throwable throwable) {
        this.m_logger.always().log(this.getFullMessage(type, Log4J2Logger.sanitized(message), throwable));
    }

    protected String getFullMessage(Logger.EventType type, String message) {
        StringBuilder writer = new StringBuilder();
        if (message == null) {
            message = "";
        }
        writer.append('[').append(type).append("] ").append(message);
        return writer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFullMessage(Logger.EventType type, String message, Throwable throwable) {
        String typeAndMessage = this.getFullMessage(type, message);
        if (throwable == null) {
            return typeAndMessage;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter writer = new PrintWriter(baos);){
            writer.append(typeAndMessage).append('\n');
            throwable.printStackTrace(writer);
            writer.flush();
            String string = baos.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private static String sanitized(String message) {
        if (message != null) {
            return message.replace('\n', '_').replace('\r', '_');
        }
        return message;
    }
}

