/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.sqlclient;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.sqlclient.BaanSQLQueryException;
import com.infor.erpln.util.DomSerializer;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BaanSQLQuery {
    protected static final Logger LOG = ESAPI.getLogger(BaanSQLQuery.class);
    private String mQuery;
    private String mQueryId;
    private Element mParameters;
    private Element mLayout;
    private Element mSubConstructor;
    private int mFetchSize = BaanSQLQuery.getDefaultIteratorSize();
    private String mCursorPosition = null;
    private String mCursorId = null;
    private Connection mConnection;
    private DocumentBuilder mDocBuilder;
    private Vector<String> mErrors;
    private Vector<Element> mDataset;

    public BaanSQLQuery() {
        this.init();
    }

    public BaanSQLQuery(Connection iConnection, DocumentBuilder iDocBuilder) {
        this.mConnection = iConnection;
        this.mDocBuilder = iDocBuilder;
        this.init();
    }

    private void init() {
        this.mErrors = new Vector();
        if (this.mDocBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                this.mDocBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
    }

    public void setQuery(String id, String query) {
        this.mQueryId = id;
        this.mQuery = query;
    }

    public void setAdditionalInfo(Element parameters, Element Layout, Element SubConstructor) {
        this.mLayout = Layout;
        this.mParameters = parameters;
        this.mSubConstructor = SubConstructor;
    }

    public void setFetchSize(int fetchSize) {
        this.mFetchSize = fetchSize;
    }

    public void execute() throws BaanSQLQueryException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Calling 'execute' on BaanSQLQuery for query " + this.mQueryId + "::" + this.mQuery);
        if (this.mConnection == null) {
            throw new BaanSQLQueryException("No connection with backend");
        }
        this.mErrors.clear();
        boolean moreToFetch = true;
        Element receivedConstructor = null;
        this.mDataset = new Vector();
        while (moreToFetch) {
            DomSerializer serializer = null;
            try {
                ConnectionImpl connection;
                byte[] result;
                ByteArrayInputStream response;
                Document doc;
                if (receivedConstructor == null) {
                    receivedConstructor = this.createRequestElement();
                }
                if ((receivedConstructor = this.handleResponse((doc = this.mDocBuilder.parse(response = new ByteArrayInputStream(result = (connection = (ConnectionImpl)this.mConnection).executeSQLQuery((serializer = new DomSerializer(receivedConstructor)).getBytes(), this.mErrors)))).getDocumentElement())) != null) continue;
                moreToFetch = false;
            }
            catch (ResourceException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("ResourceException during execute", e, true);
            }
            catch (SAXException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("SAXException during execute", e, false);
            }
            catch (IOException e) {
                this.mDataset = null;
                throw new BaanSQLQueryException("IOException during execute", e, false);
            }
            finally {
                if (serializer == null) continue;
                serializer.close();
            }
        }
    }

    public boolean executeSingleFetch() throws BaanSQLQueryException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Calling 'execute' on BaanSQLQuery for query " + this.mQueryId + "::" + this.mQuery);
        if (this.mConnection == null) {
            throw new BaanSQLQueryException("No connection with backend");
        }
        this.mErrors.clear();
        boolean moreToFetch = true;
        Element constructor = this.createRequestElement();
        this.mDataset = new Vector();
        try (DomSerializer serializer = null;){
            serializer = new DomSerializer(constructor);
            ConnectionImpl connection = (ConnectionImpl)this.mConnection;
            byte[] result = connection.executeSQLQuery(serializer.getBytes(), this.mErrors);
            ByteArrayInputStream response = new ByteArrayInputStream(result);
            Document doc = this.mDocBuilder.parse(response);
            Element receivedConstructor = this.handleResponse(doc.getDocumentElement());
            if (receivedConstructor == null) {
                moreToFetch = false;
            }
        }
        return moreToFetch;
    }

    private Element handleResponse(Element iResponse) throws BaanSQLQueryException {
        if (iResponse.getNodeName().equals("reply")) {
            return this.handleReply(iResponse);
        }
        if (iResponse.getNodeName().equals("error")) {
            throw this.handleErrorResponse(iResponse);
        }
        throw new BaanSQLQueryException("Unexpected toplevel tag: " + iResponse.getNodeName());
    }

    private Element handleReply(Element iReply) throws BaanSQLQueryException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "handle BaanSQL Reply");
        Element eConstructor = null;
        HashMap<String, Element> refMap = new HashMap<String, Element>();
        NodeList tupleNodes = iReply.getChildNodes();
        for (int i = 0; i < tupleNodes.getLength(); ++i) {
            Node tuple = tupleNodes.item(i);
            String nodeName = tuple.getNodeName();
            if (nodeName.equals("tuple")) {
                Node idAttr;
                Node old = tuple.getFirstChild();
                Node data = old.getFirstChild();
                Element bo = (Element)data;
                NamedNodeMap attributes = tuple.getAttributes();
                if (attributes != null && (idAttr = attributes.getNamedItem("id")) != null) {
                    String id = idAttr.getNodeValue();
                    refMap.put(id, bo);
                    continue;
                }
                this.mDataset.add(bo);
                continue;
            }
            if (nodeName.equals("constructor")) {
                eConstructor = (Element)tuple;
                continue;
            }
            if (!nodeName.equals("error")) continue;
            throw this.handleErrorResponse((Element)tuple);
        }
        if (refMap.size() > 0) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "found associated data, make this aggregated");
            for (Element bo : this.mDataset) {
                this.aggregateData(bo, refMap);
            }
        }
        if (eConstructor != null) {
            Element receivedCursor = (Element)eConstructor.getElementsByTagName("cursor").item(0);
            this.mCursorId = receivedCursor.getAttribute("id");
            this.mCursorPosition = receivedCursor.getAttribute("position");
            if ("".equals(this.mCursorPosition)) {
                this.mCursorId = null;
                this.mCursorPosition = null;
                return null;
            }
        }
        return eConstructor;
    }

    private BaanSQLQueryException handleErrorResponse(Element iError) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "handleErrorResponse");
        Vector<String> errorMessages = new Vector<String>();
        Element messageElement = XmlUtil.getFirstChildElement(iError);
        while (messageElement != null) {
            errorMessages.add(XmlUtil.getTextForNode(messageElement));
            messageElement = XmlUtil.getNextSiblingElement(messageElement);
        }
        return new BaanSQLQueryException(errorMessages);
    }

    private Element createRequestElement() {
        Document doc = XmlUtil.newDocument();
        Element request = doc.createElement("constructor");
        request.setAttribute("language", "BaanSQL");
        request.setAttribute("id", this.mQueryId);
        XmlUtil.createChildElementWithText(request, "query", this.mQuery);
        Document ownerDocument = request.getOwnerDocument();
        if (this.mLayout != null) {
            request.appendChild(ownerDocument.adoptNode(this.mLayout));
        }
        if (this.mSubConstructor != null) {
            NodeList childNodes = this.mSubConstructor.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                request.appendChild(ownerDocument.importNode(childNodes.item(i), true));
            }
        }
        if (this.mParameters != null) {
            request.appendChild(ownerDocument.adoptNode(this.mParameters));
        }
        Element cursor = XmlUtil.createChildElement(request, "cursor");
        cursor.setAttribute("numRows", "" + this.mFetchSize);
        if (this.mCursorId != null) {
            cursor.setAttribute("id", this.mCursorId);
        }
        if (this.mCursorPosition != null) {
            cursor.setAttribute("position", this.mCursorPosition);
        }
        return request;
    }

    public Vector<Element> getDataset() {
        return this.mDataset;
    }

    public void attachConnection(Connection iConnection) {
        this.mConnection = iConnection;
    }

    public Connection detachConnection() {
        Connection retVal = this.mConnection;
        this.mConnection = null;
        return retVal;
    }

    public static int getDefaultIteratorSize() {
        int iteratorSize = 10;
        String iSize = System.getProperty("default.iterator.size");
        if (iSize != null) {
            try {
                iteratorSize = Integer.parseInt(iSize);
            }
            catch (NumberFormatException e) {
                LOG.error(Logger.EVENT_FAILURE, "Invalid value for default.iterator.size", (Throwable)e);
            }
        }
        LOG.info(Logger.EVENT_UNSPECIFIED, "Default iterator fetch size set to " + iteratorSize);
        return iteratorSize;
    }

    private void aggregateData(Node parent, HashMap<String, Element> refMap) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node hrefAttr;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            NamedNodeMap attributes = child.getAttributes();
            if (attributes != null && (hrefAttr = attributes.getNamedItem("href")) != null) {
                String href = hrefAttr.getNodeValue();
                String id = href.substring(1);
                Element association = refMap.get(id);
                if (association != null) {
                    Node newChild = association.cloneNode(true);
                    parent.replaceChild(newChild, child);
                    child = newChild;
                } else {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "Reference to undefined association with href=" + href);
                    parent.removeChild(child);
                    child = null;
                }
            }
            if (child == null) continue;
            this.aggregateData(child, refMap);
        }
    }
}

