/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.dllclient;

import com.infor.erpln.util.DomSerializer;
import com.infor.erpln.util.XmlUtil;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Parameter {
    private static final Logger LOG = ESAPI.getLogger(Parameter.class);
    public static final String SCOPE_IN = "in";
    public static final String SCOPE_OUT = "out";
    public static final String SCOPE_IN_OUT = "inout";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "i8";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATETIME = "dateTime";
    public static final String TYPE_DOUBLE = "r8";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NODE = "node";
    public static final String TYPE_XMLSTRING = "xmlstring";
    public static final String TYPE_BINARY = "bin.base64";
    public static final String TYPE_XMLNODE = "xml.node";
    public static final String TYPE_BUSINESS_OBJECT = "elements";
    public static final String TYPE_VOID = "void";
    private String mName;
    private String mScope;
    private Object mValue;
    private String mType;
    private int mStringLength = 0;
    private boolean mBusinessElement = false;

    public Parameter(String iName, String iScope) {
        this.mName = iName;
        this.mScope = iScope;
        this.mType = TYPE_STRING;
    }

    public void setIsBusinessElement() {
        this.mBusinessElement = true;
    }

    public void setScope(String iScope) {
        this.mScope = iScope;
    }

    public void setValue(Node iXmlValue) {
        this.setType(TYPE_NODE);
        this.mValue = new MyNode(iXmlValue);
    }

    public void setValue(String iStringValue) {
        this.setType(TYPE_STRING);
        this.mValue = iStringValue;
        if (this.mStringLength == 0) {
            this.setStringLength(iStringValue.length());
        }
    }

    public void setValue(int iIntValue) {
        this.setType(TYPE_INT);
        this.mValue = new Integer(iIntValue);
    }

    public void setValue(long iLongValue) {
        this.setType(TYPE_LONG);
        this.mValue = new Long(iLongValue);
    }

    public void setValue(boolean iBooleanValue) {
        this.setType(TYPE_BOOLEAN);
        this.mValue = new Boolean(iBooleanValue);
    }

    public void setValue(double iDoubleValue) {
        this.setType(TYPE_DOUBLE);
        this.mValue = new Double(iDoubleValue);
    }

    public void setXMLValue(String iXmlString) {
        this.setType(TYPE_XMLSTRING);
        this.mValue = new MyNode(iXmlString);
    }

    void setReplyValue(Element iElement) {
        if (this.isNode()) {
            this.mValue = new MyNode(iElement);
        } else {
            this.changeValue(XmlUtil.getTextForNode(iElement));
        }
    }

    public void setName(String iName) {
        this.mName = iName;
    }

    public void changeValue(String iNewValue) {
        if (this.mType.equals(TYPE_BOOLEAN)) {
            this.mValue = iNewValue.equals("1") ? new Boolean(true) : (iNewValue.equals("0") ? new Boolean(false) : Boolean.valueOf(iNewValue));
        } else if (this.mType.equals(TYPE_DOUBLE)) {
            if (iNewValue == null || iNewValue.equals("")) {
                this.mValue = new Double(0.0);
            } else {
                try {
                    this.mValue = Double.valueOf(iNewValue);
                }
                catch (NumberFormatException ex) {
                    LOG.error(Logger.EVENT_FAILURE, "Error parsing double value: " + iNewValue, (Throwable)ex);
                }
            }
        } else if (this.mType.equals(TYPE_INT)) {
            if (iNewValue == null || iNewValue.equals("")) {
                this.mValue = new Integer(0);
            } else {
                try {
                    this.mValue = Integer.valueOf(iNewValue);
                }
                catch (NumberFormatException ex) {
                    LOG.error(Logger.EVENT_FAILURE, "Error parsing int value: " + iNewValue, (Throwable)ex);
                }
            }
        } else if (this.mType.equals(TYPE_LONG)) {
            if (iNewValue == null || iNewValue.equals("")) {
                this.mValue = new Long(0L);
            } else {
                try {
                    this.mValue = Long.valueOf(iNewValue);
                }
                catch (NumberFormatException ex) {
                    LOG.error(Logger.EVENT_FAILURE, "Error parsing long value: " + iNewValue, (Throwable)ex);
                }
            }
        } else if (this.mType.equals(TYPE_STRING)) {
            this.mValue = iNewValue == null ? "" : iNewValue;
        } else if (this.mType.equals(TYPE_NODE) || this.mType.equals(TYPE_XMLSTRING)) {
            this.mValue = iNewValue == null ? new MyNode("") : new MyNode(iNewValue);
        } else if (this.mType.equals(TYPE_CHAR)) {
            this.mValue = iNewValue;
        } else if (this.mType.equals(TYPE_DATE)) {
            this.mValue = iNewValue;
        } else if (this.mType.equals(TYPE_DATETIME)) {
            this.mValue = iNewValue;
        } else if (this.mType.equals(TYPE_BINARY)) {
            this.mValue = iNewValue;
        } else if (this.mType.equals(TYPE_XMLNODE)) {
            this.mValue = iNewValue;
        }
    }

    public int getIntValue() {
        if (this.mValue == null) {
            return 0;
        }
        return (Integer)this.mValue;
    }

    public long getLongValue() {
        if (this.mValue == null) {
            return 0L;
        }
        return (Long)this.mValue;
    }

    public String getStringValue() {
        return (String)this.mValue;
    }

    public boolean getBooleanValue() {
        if (this.mValue == null) {
            return false;
        }
        return (Boolean)this.mValue;
    }

    public double getDoubleValue() {
        if (this.mValue == null) {
            return 0.0;
        }
        return (Double)this.mValue;
    }

    public Node getXMLValue() {
        if (this.mValue == null) {
            return null;
        }
        return ((MyNode)this.mValue).asNode();
    }

    public String getXMLValueAsString() {
        if (this.mValue == null) {
            return "";
        }
        return ((MyNode)this.mValue).asString();
    }

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public String getScope() {
        return this.mScope;
    }

    public void setType(String iType) {
        this.mType = iType;
        if (iType.equals(TYPE_BUSINESS_OBJECT)) {
            this.setIsBusinessElement();
        }
    }

    public boolean isNode() {
        return this.mType.equals(TYPE_NODE) || this.mType.equals(TYPE_XMLSTRING) || this.mBusinessElement;
    }

    public boolean isOutput() {
        return this.mScope.equals(SCOPE_OUT) || this.mScope.equals(SCOPE_IN_OUT);
    }

    public boolean isInput() {
        return this.mScope.equals(SCOPE_IN) || this.mScope.equals(SCOPE_IN_OUT);
    }

    public boolean hasValue() {
        return this.mValue != null;
    }

    public String toString() {
        if (this.mType.equals(TYPE_BOOLEAN)) {
            if (this.mValue == null) {
                return "0";
            }
            return this.mValue.toString().equals("true") ? "1" : "0";
        }
        if (this.mValue == null) {
            return "";
        }
        return this.mValue.toString();
    }

    public String toNormalizedString() {
        if (this.mType.equals(TYPE_STRING)) {
            return XmlUtil.escapeAttributeValue(this.toString());
        }
        return this.toString();
    }

    public int getStringLength() {
        return this.mStringLength;
    }

    public void setStringLength(int iStringLength) {
        this.mStringLength = iStringLength;
    }

    static class MyNode {
        private Node mNode;
        private String mString;
        private boolean mNodeValid = false;
        private boolean mStringValid = false;

        MyNode(Node iNode) {
            this.mNode = iNode;
            this.mNodeValid = true;
        }

        MyNode(String iString) {
            this.mString = iString;
            this.mStringValid = true;
        }

        String asString() {
            if (!this.mStringValid) {
                this.printNodeToString();
            }
            return this.mString;
        }

        Node asNode() {
            if (!this.mNodeValid) {
                this.parseStringToNode();
            }
            return this.mNode;
        }

        public String toString() {
            return this.asString();
        }

        private void printNodeToString() {
            try (DomSerializer serializer = null;){
                serializer = new DomSerializer(this.mNode);
                this.mString = serializer.toString();
                this.mStringValid = true;
            }
        }

        private void parseStringToNode() {
            this.mNode = XmlUtil.convertStringToNode(this.mString);
            this.mNodeValid = true;
        }
    }
}

