/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca.dllclient;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import com.infor.erpln.util.DomSerializer;
import com.infor.erpln.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.util.EnumSet;
import java.util.Set;
import java.util.Vector;
import javax.resource.cci.Connection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaanDLLCall {
    protected static final String TAG_PARAMETERS = "parameters";
    private static final Logger LOG = ESAPI.getLogger(BaanDLLCall.class);
    protected Connection mConnection;
    protected String mDllName;
    protected String mFunctionName;
    protected Parameter[] mParameterArray;
    private Parameter mReturnValue;
    protected Vector<String> mErrors;
    protected DocumentBuilder mDocBuilder;
    private Element mResponseElement;

    public BaanDLLCall() {
        this.init();
    }

    public BaanDLLCall(Connection iConnection, DocumentBuilder iDocBuilder) {
        this.mConnection = iConnection;
        this.mDocBuilder = iDocBuilder;
        this.init();
    }

    private void init() {
        this.mReturnValue = new Parameter("", "out");
        this.mErrors = new Vector();
        if (this.mDocBuilder == null) {
            try {
                this.mDocBuilder = XmlUtil.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void attachConnection(Connection iConnection) {
        this.mConnection = iConnection;
    }

    public Connection detachConnection() {
        Connection retVal = this.mConnection;
        this.mConnection = null;
        return retVal;
    }

    public void setDLL(String iDllName) {
        this.mDllName = iDllName;
    }

    public void setFunction(String iFunctionName) {
        this.mFunctionName = iFunctionName;
        this.mReturnValue.setName(iFunctionName.toLowerCase());
    }

    public void setReturnType(String iReturnType) {
        this.mReturnValue.setType(iReturnType);
    }

    public void setParameters(Parameter[] iParameterArray) {
        this.mParameterArray = iParameterArray;
    }

    public void execute() throws BaanDLLCallException {
        this.execute(EnumSet.noneOf(MessageOption.class));
    }

    public void execute(Set<MessageOption> iOptions) throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "Calling 'execute' on BaanDLLCall " + this.mDllName + "::" + this.mFunctionName);
        if (this.mConnection == null) {
            throw new BaanDLLCallException("No connection with backend");
        }
        this.mResponseElement = null;
        this.mErrors.clear();
        Element request = this.createRequestElement();
        try (DomSerializer serializer = null;){
            serializer = new DomSerializer(request);
            ConnectionImpl connection = (ConnectionImpl)this.mConnection;
            byte[] result = connection.executeBaanDll(serializer.getBytes(), this.mErrors, null, iOptions);
            ByteArrayInputStream response = new ByteArrayInputStream(result);
            Document doc = this.mDocBuilder.parse(response);
            this.handleResponse(doc.getDocumentElement());
        }
    }

    protected Element createRequestElement() {
        String returnType;
        Element request = this.mDocBuilder.newDocument().createElement("constructor");
        request.setAttribute("language", "BaanDLL");
        XmlUtil.createChildElementWithText(request, "dll", this.mDllName);
        Element method = XmlUtil.createChildElementWithText(request, "method", this.mFunctionName);
        if (this.mReturnValue != null && !(returnType = this.mReturnValue.getType()).equals("void")) {
            method.setAttribute("scope", "out");
            if (this.mReturnValue.isNode()) {
                method.setAttribute("ct", "elements");
            } else {
                method.setAttribute("dt", returnType);
            }
        }
        if (this.mParameterArray != null) {
            Element parameters = XmlUtil.createChildElement(request, TAG_PARAMETERS);
            for (int i = 0; i < this.mParameterArray.length; ++i) {
                this.addParameter(parameters, this.mParameterArray[i]);
            }
        }
        return request;
    }

    private void addParameter(Element oParameters, Parameter iParameter) {
        if (iParameter.isNode()) {
            Element parElement = iParameter.isInput() && iParameter.hasValue() ? (Element)XmlUtil.appendChild(oParameters, iParameter.getXMLValue()) : XmlUtil.createChildElement(oParameters, iParameter.getName());
            parElement.setAttribute("scope", iParameter.getScope());
            parElement.setAttribute("ct", "elements");
        } else {
            Element parElement = XmlUtil.createChildElement(oParameters, iParameter.getName());
            parElement.setAttribute("scope", iParameter.getScope());
            parElement.setAttribute("dt", iParameter.getType());
            if (iParameter.getType().equals("string")) {
                parElement.setAttribute("dims", Integer.toString(iParameter.getStringLength()));
            }
            if (iParameter.isInput() && iParameter.hasValue()) {
                XmlUtil.appendText(parElement, iParameter.toString());
            }
        }
    }

    private void handleResponse(Element iResponse) throws BaanDLLCallException {
        if (!iResponse.getNodeName().equals("reply")) {
            if (iResponse.getNodeName().equals("error")) {
                throw this.handleErrorResponse(iResponse);
            }
            throw new BaanDLLCallException("Unexpected toplevel tag: " + iResponse.getNodeName());
        }
        this.mResponseElement = XmlUtil.getFirstChildElement(iResponse);
        this.handleSuccessResponse(this.mResponseElement);
    }

    private void handleSuccessResponse(Element iResponse) throws BaanDLLCallException {
        LOG.info(Logger.EVENT_UNSPECIFIED, "handleSuccessResponse");
        if (!iResponse.getNodeName().equalsIgnoreCase(this.mFunctionName)) {
            if (iResponse.getNodeName().equals("error")) {
                throw this.handleErrorResponse(iResponse);
            }
            throw new BaanDLLCallException("Unexpected tag within reply: " + iResponse.getNodeName());
        }
        Element method = XmlUtil.getFirstChildElement(iResponse);
        if (method != null) {
            Element paramElem = null;
            String name = method.getNodeName();
            if (name.equalsIgnoreCase(this.mFunctionName)) {
                this.mReturnValue.setReplyValue(method);
                paramElem = XmlUtil.getNextSiblingElement(method);
            } else {
                paramElem = method;
            }
            Vector<Parameter> vOut = new Vector<Parameter>();
            if (this.mParameterArray != null) {
                for (int iP = 0; iP < this.mParameterArray.length; ++iP) {
                    if (!this.mParameterArray[iP].isOutput()) continue;
                    vOut.add(this.mParameterArray[iP]);
                }
            }
            int iOut = 0;
            while (paramElem != null) {
                Parameter param = (Parameter)vOut.get(iOut);
                param.setReplyValue(paramElem);
                paramElem = XmlUtil.getNextSiblingElement(paramElem);
                ++iOut;
            }
        }
    }

    protected BaanDLLCallException handleErrorResponse(Element iError) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "handleErrorResponse");
        Vector<String> errorMessages = new Vector<String>();
        Element messageElement = XmlUtil.getFirstChildElement(iError);
        while (messageElement != null) {
            errorMessages.add(XmlUtil.getTextForNode(messageElement));
            messageElement = XmlUtil.getNextSiblingElement(messageElement);
        }
        return new BaanDLLCallException(errorMessages);
    }

    public Vector<String> getErrors() {
        return (Vector)this.mErrors.clone();
    }

    public boolean hasErrors() {
        return !this.mErrors.isEmpty();
    }

    public String getErrorsAsString() {
        if (this.hasErrors()) {
            StringBuilder buffer = new StringBuilder();
            for (String errorMessage : this.mErrors) {
                if (buffer.length() > 0) {
                    buffer.append('\n');
                }
                buffer.append(errorMessage);
            }
            return buffer.toString();
        }
        return null;
    }

    public int getReturnIntValue() {
        return this.mReturnValue.getIntValue();
    }

    public long getReturnLongValue() {
        return this.mReturnValue.getLongValue();
    }

    public String getReturnStringValue() {
        return this.mReturnValue.getStringValue();
    }

    public boolean getReturnBooleanValue() {
        return this.mReturnValue.getBooleanValue();
    }

    public double getReturnDoubleValue() {
        return this.mReturnValue.getDoubleValue();
    }

    public Node getReturnXMLValue() {
        return this.mReturnValue.getXMLValue();
    }

    public String getReturnXMLValueAsString() {
        return this.mReturnValue.getXMLValueAsString();
    }

    public String getDLL() {
        return this.mDllName;
    }

    public String getFunction() {
        return this.mFunctionName;
    }

    public String getReturnType() {
        return this.mReturnValue.getType();
    }

    public Parameter[] getParameters() {
        return this.mParameterArray;
    }

    public Document getResponseXMLDocument() {
        return this.mResponseElement.getOwnerDocument();
    }

    public Parameter getReturnParameter() {
        return this.mReturnValue;
    }

    public Parameter getParameter(String iParameterName) {
        Parameter result = null;
        if (this.mParameterArray != null) {
            boolean found = false;
            for (int index = 0; !found && index < this.mParameterArray.length; ++index) {
                if (!iParameterName.equals(this.mParameterArray[index].getName())) continue;
                found = true;
                result = this.mParameterArray[index];
            }
        }
        return result;
    }
}

