/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.PrincipalMapEntry;
import com.infor.erpln.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PrincipalMap
extends DefaultHandler {
    private static final String MISSING_ATTRIBUTE_TEXT = "Missing attribute: ";
    private static final String BACKEND_TAG = "backend";
    private static final String ENTRY_TAG = "entry";
    private static final String HOSTNAME_ATTR = "hostname";
    private static final String INITIATOR_ATTR = "initiator";
    private static final String USER_ATTR = "user";
    private static final String PASSWORD_ATTR = "password";
    private static final String WILDCARD = "*";
    private final Map<String, BackendMap> mBackendMap = new HashMap<String, BackendMap>();
    private BackendMap mCurBackend;
    private URL mUrl;
    private static final Logger LOG = ESAPI.getLogger(PrincipalMap.class);

    public PrincipalMap(URL iUrl) {
        this.mUrl = iUrl;
    }

    public boolean init() {
        boolean retVal = false;
        if (this.mUrl != null) {
            try (InputStream in = this.mUrl.openStream();){
                SAXParserFactory factory = XmlUtil.createSAXParserFactory();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(in, (DefaultHandler)this);
                LOG.debug(Logger.EVENT_SUCCESS, "Parsing principal map succeeded");
                retVal = true;
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to read: " + this.mUrl.toString(), (Throwable)e);
            }
            catch (SAXException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to parse: " + this.mUrl.toString() + " Cause: " + e.getMessage(), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed to create parser", (Throwable)e);
            }
        }
        return retVal;
    }

    @Override
    public void startElement(String iNamespaceURI, String iSimpleName, String iQualifiedName, Attributes iAttrs) throws SAXException {
        if (iQualifiedName.equals(BACKEND_TAG)) {
            String hostname = iAttrs.getValue(HOSTNAME_ATTR);
            if (hostname == null) {
                throw new SAXException("Missing attribute: hostname");
            }
            this.mCurBackend = new BackendMap();
            BackendMap previousValue = this.mBackendMap.put(hostname, this.mCurBackend);
            if (previousValue != null) {
                LOG.info(Logger.EVENT_SUCCESS, "Previous map entry for backend: " + hostname + " replaced");
            }
        } else if (iQualifiedName.equals(ENTRY_TAG)) {
            String initiator = iAttrs.getValue(INITIATOR_ATTR);
            String user = iAttrs.getValue(USER_ATTR);
            String password = iAttrs.getValue(PASSWORD_ATTR);
            if (this.mCurBackend == null) {
                throw new SAXException("Tag: entry must be inside tag: backend");
            }
            this.checkAttributes(initiator, user, password);
            PrincipalMapEntry entry = new PrincipalMapEntry(initiator, user, password);
            PrincipalMapEntry previousValue = this.mCurBackend.addEntry(entry);
            if (previousValue != null) {
                LOG.info(Logger.EVENT_SUCCESS, "Previous map entry for user: " + initiator + " replaced");
            }
        }
    }

    private void checkAttributes(String initiator, String user, String password) throws SAXException {
        if (initiator == null) {
            throw new SAXException("Missing attribute: initiator");
        }
        if (user == null) {
            throw new SAXException("Missing attribute: user");
        }
        if (password == null) {
            throw new SAXException("Missing attribute: password");
        }
    }

    public PrincipalMapEntry getEntry(String iHostname, String iPrincipal) {
        PrincipalMapEntry entry = null;
        BackendMap backend = this.mBackendMap.get(iHostname);
        if (backend != null) {
            entry = backend.getEntry(iPrincipal);
        }
        return entry;
    }

    private class BackendMap {
        private final HashMap<String, PrincipalMapEntry> mMap = new HashMap();

        private BackendMap() {
        }

        public PrincipalMapEntry addEntry(PrincipalMapEntry iNewEntry) {
            PrincipalMapEntry previousValue = this.mMap.put(iNewEntry.getPrincipal(), iNewEntry);
            return previousValue;
        }

        public PrincipalMapEntry getEntry(String iPrincipal) {
            PrincipalMapEntry entry = this.mMap.get(iPrincipal);
            if (entry == null) {
                entry = this.mMap.get(PrincipalMap.WILDCARD);
            }
            return entry;
        }
    }
}

