/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.BDEConsumer;
import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.ConnectionManagerPerUser;
import com.infor.erpln.jca.ConnectionMetaDataImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.ManagedConnectionFactoryImpl;
import com.infor.erpln.jca.TimerCloseTask;
import com.infor.erpln.protocol.BaanConnectionException;
import com.infor.erpln.protocol.JcaHandler;
import com.infor.erpln.protocol.SessionLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ManagedConnectionImpl
implements ManagedConnection {
    private ManagedConnectionFactoryImpl mManagedConnectionFactory;
    private ConnectionSpecImpl mConfigSpec;
    private ActivationSpec mActivationSpec;
    private ArrayList<ConnectionImpl> mOpenConnections;
    private ArrayList<ConnectionImpl> mClosedConnections;
    private PrintWriter mPrintWriter;
    private ArrayList<ConnectionEventListener> mListeners = new ArrayList();
    private SessionLayer mSession;
    private TimerCloseTask mTask;
    private boolean mFromPool = false;
    private static final Logger LOG = ESAPI.getLogger(ManagedConnectionImpl.class);
    private final boolean mListenMode;
    private static final String PUBLISHER_META_TAG = "publishingInfo";

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl iManagedConnectionFactory, ConnectionSpecImpl iConnectConfig, SessionLayer iSession) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "ManagedConnectionImpl(ManagedConnectionFactoryImpl,ConnectionSpecImpl,SessionLayer)");
        this.mManagedConnectionFactory = iManagedConnectionFactory;
        this.mConfigSpec = iConnectConfig;
        this.mOpenConnections = new ArrayList();
        this.mClosedConnections = new ArrayList();
        this.mSession = iSession;
        this.mListenMode = iConnectConfig.getConnectionMethod() == 4;
    }

    public ConnectionImpl getConnection(Subject iSubject, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        JcaHandler bdeManager = null;
        ConnectionImpl con = null;
        int bdeManagerCompany = -1;
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getConnection(Subject,ConnectionRequestInfo)");
        if (!this.mListenMode) {
            ConnectionSpecImpl connectionSpec = (ConnectionSpecImpl)iConnectionRequestInfo;
            bdeManagerCompany = connectionSpec.getBdeManagerCompany();
            con = this.findClosedConnection(bdeManagerCompany);
            if (con == null) {
                try {
                    bdeManager = this.mSession.getBdeManager(bdeManagerCompany);
                    bdeManager.setReplyTimeout(this.mManagedConnectionFactory.getReplyTimeout());
                }
                catch (BaanConnectionException ex) {
                    LOG.error(Logger.EVENT_FAILURE, "getBdeManager failed", (Throwable)ex);
                    throw new ResourceException("getBdeManager failed", (Throwable)ex);
                }
            } else {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Re-use idle BDEManager");
                this.moveToOpened(con);
            }
        }
        if (con == null) {
            con = new ConnectionImpl(this, bdeManager, bdeManagerCompany);
            this.addConnection(con);
        }
        con.setOpened();
        return con;
    }

    private ConnectionImpl findClosedConnection(int bdeCompany) {
        ConnectionImpl retCon = null;
        for (ConnectionImpl con : this.mClosedConnections) {
            if (!con.isClosed() || con.getBdeManagerCompany() != bdeCompany) continue;
            retCon = con;
            break;
        }
        return retCon;
    }

    public void associateConnection(Object iConnection) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "associateConnection()");
        throw new ResourceException("associateConnection not supported");
    }

    public void cleanup() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "cleanup()");
        for (ConnectionImpl con : this.mOpenConnections) {
            con.invalidate();
        }
        this.mOpenConnections.clear();
        for (ConnectionImpl con : this.mClosedConnections) {
            con.invalidate();
        }
        this.mClosedConnections.clear();
    }

    public void cleanup(ConnectionImpl con) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "cleanup(ConnectionImpl)");
        if (this.mConfigSpec.getForceCleanup()) {
            con.invalidate();
            this.mOpenConnections.remove(con);
        } else {
            this.moveToClosed(con);
        }
    }

    private void moveToClosed(ConnectionImpl con) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "moveToClosed(ConnectionImpl)");
        if (this.mOpenConnections.contains(con)) {
            this.mOpenConnections.remove(con);
        }
        if (con.isRunning()) {
            this.mClosedConnections.add(con);
        }
    }

    private void moveToOpened(ConnectionImpl con) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "moveToOpened(ConnectionImpl)");
        if (this.mClosedConnections.contains(con)) {
            this.mClosedConnections.remove(con);
        }
        this.mOpenConnections.add(con);
    }

    public void destroy() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "destroy()");
        try {
            if (this.getNumReferences() > 0) {
                this.cleanup();
            }
            this.mSession.close();
        }
        catch (Exception ex) {
            ResourceException re = new ResourceException("Connection close failed: " + ex.getMessage(), (Throwable)ex);
            throw re;
        }
    }

    public void addConnectionEventListener(ConnectionEventListener iConnectionEventListener) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "addConnectionEventListener((ConnectionEventListener) " + iConnectionEventListener.toString() + ")");
        this.mListeners.add(iConnectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener iConnectionEventListener) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "removeConnectionEventListener((ConnectionEventListener) " + iConnectionEventListener.toString() + ")");
        this.mListeners.remove(iConnectionEventListener);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent((ManagedConnection)this, eventType) : new ConnectionEvent((ManagedConnection)this, eventType, ex);
        if (connectionHandle != null) {
            ce.setConnectionHandle(connectionHandle);
        }
        block7: for (ConnectionEventListener listener : this.mListeners) {
            switch (eventType) {
                case 1: {
                    listener.connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    listener.localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    listener.localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    listener.localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    listener.connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType: " + eventType);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getXAResource()");
        throw new ResourceException("XA transactions are not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getLocalTransaction()");
        throw new ResourceException("Local transactions are not supported");
    }

    public ConnectionMetaDataImpl getMetaData() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getMetaData()");
        return new ConnectionMetaDataImpl(this.mSession.getMetaData());
    }

    public PrintWriter getLogWriter() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "getLogWriter()");
        return this.mPrintWriter;
    }

    public void setLogWriter(PrintWriter iPrintWriter) throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "setLogWriter((PrintWriter) " + iPrintWriter.toString() + ")");
        this.mPrintWriter = iPrintWriter;
    }

    public String getStartupMessages() {
        return this.mSession.getStartupMessages();
    }

    public InputStream openForRead(String a_serverFile, boolean a_textMode, boolean a_polling) throws IOException, BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            String message = "openForRead(" + a_serverFile + ", " + Boolean.toString(a_textMode) + ", " + Boolean.toString(a_polling) + ")";
            LOG.info(Logger.EVENT_UNSPECIFIED, message);
        }
        return this.mSession.openForRead(a_serverFile, a_textMode, a_polling);
    }

    public OutputStream openForWrite(String a_serverFile, boolean a_textMode) throws IOException, BaanConnectionException {
        if (LOG.isInfoEnabled()) {
            String message = "openForWrite(" + a_serverFile + ", " + Boolean.toString(a_textMode) + ")";
            LOG.info(Logger.EVENT_UNSPECIFIED, message);
        }
        return this.mSession.openForWrite(a_serverFile, a_textMode);
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.mManagedConnectionFactory;
    }

    public ConnectionSpecImpl getConnectionSpec() {
        return this.mConfigSpec;
    }

    public ActivationSpec getActivationSpec() {
        return this.mActivationSpec;
    }

    public void setActivationSpec(ActivationSpec activation) {
        this.mActivationSpec = activation;
    }

    public void removeConnection(ConnectionImpl iConnection) {
        if (this.mOpenConnections.contains(iConnection)) {
            this.mOpenConnections.remove(iConnection);
        }
        if (this.mClosedConnections.contains(iConnection)) {
            this.mClosedConnections.remove(iConnection);
        }
    }

    public void addConnection(ConnectionImpl iConnection) {
        this.mOpenConnections.add(iConnection);
    }

    public void activateListener(BDEConsumer iConsumer) throws ResourceException {
        try {
            String metaData = "<publishingInfo type='BDE'/>";
            this.mSession.activateListener(iConsumer, metaData.getBytes());
        }
        catch (BaanConnectionException e) {
            throw new ResourceException("Activating listener failed", (Throwable)e);
        }
    }

    public void createCloseTask(ConnectionManagerPerUser connManager) {
        this.mTask = new TimerCloseTask(connManager, this);
    }

    public TimerCloseTask getCloseTask() {
        return this.mTask;
    }

    public int getNumReferences() {
        return this.mOpenConnections.size() + this.mClosedConnections.size();
    }

    public int getNumOpenConnections() {
        return this.mOpenConnections.size();
    }

    public String toString() {
        if (this.mConfigSpec != null) {
            return this.mConfigSpec.toString();
        }
        return super.toString();
    }

    public boolean isValid() {
        return this.mSession.isValid();
    }

    public boolean isTakenFromPool() {
        return this.mFromPool;
    }

    public void setTakenFromPool(boolean fromPool) {
        this.mFromPool = fromPool;
    }
}

