/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ConnectionManagerPerUser;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.PoolStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionSupervisor
implements ConnectionManager {
    private final Map<String, ConnectionManagerPerUser> mConManagers = new HashMap<String, ConnectionManagerPerUser>();
    private AtomicReference<Timer> mIdleTimer = new AtomicReference<Object>(null);

    public Object allocateConnection(ManagedConnectionFactory iManagedConnectionFactory, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        ConnectionManagerPerUser manager = this.getOrCreateManager(iConnectionRequestInfo);
        return manager.allocateConnection(iManagedConnectionFactory, iConnectionRequestInfo);
    }

    public synchronized void destroy() {
        Timer timer = this.mIdleTimer.get();
        if (timer != null) {
            timer.cancel();
        }
        for (ConnectionManagerPerUser manager : this.mConManagers.values()) {
            manager.destroy();
        }
        this.mConManagers.clear();
    }

    public Timer getIdleTimer() {
        Timer timer = this.mIdleTimer.get();
        if (timer == null && !this.mIdleTimer.compareAndSet(null, timer = new Timer("IdlePoolTimer", true))) {
            return this.mIdleTimer.get();
        }
        return timer;
    }

    private synchronized ConnectionManagerPerUser getOrCreateManager(ConnectionRequestInfo iConnectionRequestInfo) {
        ConnectionManagerPerUser manager;
        String key = "";
        String tenant = null;
        String user = null;
        if (iConnectionRequestInfo instanceof ConnectionSpecImpl) {
            ConnectionSpecImpl spec = (ConnectionSpecImpl)iConnectionRequestInfo;
            tenant = spec.getTenant();
            if (tenant != null) {
                key = tenant + ":";
            }
            user = spec.getUser();
            key = key + user;
        }
        if ((manager = this.mConManagers.get(key)) == null) {
            manager = new ConnectionManagerPerUser(this, tenant, user);
            this.mConManagers.put(key, manager);
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PoolStatistics> getPoolStatistics() {
        ConnectionManagerPerUser[] managers;
        ConnectionSupervisor connectionSupervisor = this;
        synchronized (connectionSupervisor) {
            managers = new ConnectionManagerPerUser[this.mConManagers.size()];
            managers = this.mConManagers.values().toArray(managers);
        }
        ArrayList<PoolStatistics> list = new ArrayList<PoolStatistics>();
        for (ConnectionManagerPerUser manager : managers) {
            PoolStatistics stats = manager.getPoolStatistics();
            if (stats == null) continue;
            list.add(stats);
        }
        return list;
    }
}

