/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.OAuth2Callback;
import com.infor.erpln.protocol.ConnectionConfig;
import com.infor.erpln.util.ConnectionPoint;
import com.infor.erpln.util.ConnectionPointActivation;
import com.infor.erpln.util.ConnectionPointsManager;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionRequestInfo;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionSpecImpl
implements ConnectionSpec,
ConnectionRequestInfo,
ConnectionConfig {
    private String mUserName = "";
    private String mPassword = "";
    private String mTenant = "";
    private String mClientLocationHost = "";
    private String mClientLocationIP = "";
    private String mClientLanguage = "";
    private String mClientLocale = "";
    private String mApplication = "";
    private OAuth2Callback mOAuth2Callback;
    private String mConnectionPoint;
    private String mBackend;
    private int mPort;
    private String mActivationType = "";
    private int mTimerDelay = 0;
    private int mMaxConnections = 0;
    private int mMaxReferences = 0;
    private int mMaxThreads = 0;
    private boolean mForceCleanup = true;
    private int mBdeManagerCompany = -1;
    private String mBSE;
    private String mBshellName;
    private int mCompany = -1;
    private String mCommand;
    private String mDaemonOptions;
    private ConnectionPointsManager mConnectionPointsManager;
    private boolean mResolved;
    private static final Logger LOG = ESAPI.getLogger(ConnectionSpecImpl.class);

    public ConnectionSpecImpl(String iBackend, String iActivationType, int iPort, String iBSE, String iBshellName, String iCommand, String iDaemonOptions, int iCompany) {
        this.mBackend = iBackend;
        this.mActivationType = iActivationType;
        this.mPort = iPort;
        this.mBSE = iBSE;
        this.mBshellName = iBshellName;
        this.mCommand = iCommand;
        this.mDaemonOptions = iDaemonOptions;
        this.mCompany = iCompany;
        this.mResolved = true;
    }

    public ConnectionSpecImpl() {
        this.mResolved = true;
    }

    public ConnectionSpecImpl(String iConnectionPoint) {
        this.mConnectionPoint = iConnectionPoint;
        this.mResolved = false;
    }

    public Object clone() {
        ConnectionSpecImpl copy;
        if (this.mConnectionPoint != null) {
            copy = new ConnectionSpecImpl(this.mConnectionPoint);
            copy.mConnectionPointsManager = this.mConnectionPointsManager;
            copy.mActivationType = this.mActivationType;
            copy.mBackend = this.mBackend;
            copy.mPort = this.mPort;
            copy.mBSE = this.mBSE;
            copy.mBshellName = this.mBshellName;
            copy.mCommand = this.mCommand;
            copy.mDaemonOptions = this.mDaemonOptions;
            copy.mCompany = this.mCompany;
            copy.mResolved = this.mResolved;
        } else {
            copy = new ConnectionSpecImpl(this.mBackend, this.mActivationType, this.mPort, this.mBSE, this.mBshellName, this.mCommand, this.mDaemonOptions, this.mCompany);
        }
        copy.mTimerDelay = this.mTimerDelay;
        copy.mMaxReferences = this.mMaxReferences;
        copy.mMaxThreads = this.mMaxThreads;
        copy.mMaxConnections = this.mMaxConnections;
        copy.mForceCleanup = this.mForceCleanup;
        copy.mUserName = this.mUserName;
        copy.mPassword = this.mPassword;
        copy.mTenant = this.mTenant;
        copy.mBdeManagerCompany = this.mBdeManagerCompany;
        copy.mClientLocationHost = this.mClientLocationHost;
        copy.mClientLocationIP = this.mClientLocationIP;
        copy.mClientLanguage = this.mClientLanguage;
        copy.mClientLocale = this.mClientLocale;
        copy.mApplication = this.mApplication;
        copy.mOAuth2Callback = this.mOAuth2Callback;
        return copy;
    }

    public int getTimerDelay() {
        return this.mTimerDelay;
    }

    public void setTimerDelay(int iDelay) {
        this.mTimerDelay = iDelay;
    }

    @Override
    public String getUser() {
        return this.mUserName;
    }

    public void setUser(String iUserName) {
        this.mUserName = iUserName;
    }

    @Override
    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String iPassword) {
        this.mPassword = iPassword;
    }

    @Override
    public String getTenant() {
        return this.mTenant;
    }

    public void setTenant(String iTenant) {
        this.mTenant = iTenant;
    }

    public String getConnectionPoint() {
        return this.mConnectionPoint;
    }

    public void setConnectionPoint(String iConnectionPoint) throws ResourceException {
        this.mConnectionPoint = iConnectionPoint;
        if (this.mConnectionPointsManager != null) {
            this.resolveConnectionPoint();
        } else {
            this.mResolved = false;
        }
    }

    public String getActivationType() {
        return this.mActivationType;
    }

    public void setActivationType(String iActivationType) {
        this.mActivationType = iActivationType;
    }

    @Override
    public String getBackend() {
        return this.mBackend;
    }

    public void setBackend(String iBackend) {
        this.mBackend = iBackend;
    }

    @Override
    public int getPort() {
        return this.mPort;
    }

    public void setPort(int iPort) {
        this.mPort = iPort;
    }

    @Override
    public int getCompany() {
        return this.mCompany;
    }

    public void setCompany(int iCompany) {
        this.mCompany = iCompany;
    }

    public int getBdeManagerCompany() {
        return this.mBdeManagerCompany;
    }

    public void setBdeManagerCompany(int iBdeManagerCompany) {
        this.mBdeManagerCompany = iBdeManagerCompany;
    }

    public int getMaxReferences() {
        if (this.mMaxReferences < 0) {
            return Integer.MAX_VALUE;
        }
        return this.mMaxReferences;
    }

    public void setMaxReferences(int iMaxReferences) {
        this.mMaxReferences = iMaxReferences;
    }

    public int getMaxThreads() {
        if (this.mMaxThreads < 0) {
            return Integer.MAX_VALUE;
        }
        return this.mMaxThreads;
    }

    public void setMaxThreads(int iMaxThreads) {
        this.mMaxThreads = iMaxThreads;
    }

    public int getMaxConnections() {
        return this.mMaxConnections;
    }

    public void setMaxConnections(int iMaxConnections) {
        this.mMaxConnections = iMaxConnections;
    }

    public boolean getForceCleanup() {
        return this.mForceCleanup;
    }

    public void setForceCleanup(boolean iValue) {
        this.mForceCleanup = iValue;
    }

    @Override
    public String getBSE() {
        return this.mBSE;
    }

    public void setBSE(String bse) {
        this.mBSE = bse;
    }

    @Override
    public String getBshellName() {
        return this.mBshellName;
    }

    public void setBshellName(String bshellname) {
        this.mBshellName = bshellname;
    }

    @Override
    public String getCommand() {
        return this.mCommand;
    }

    public void setCommand(String command) {
        this.mCommand = command;
    }

    @Override
    public String getDaemonOptions() {
        return this.mDaemonOptions;
    }

    public void setDaemonOptions(String options) {
        this.mDaemonOptions = options;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mActivationType == null ? 0 : this.mActivationType.hashCode());
        result = 31 * result + (this.mBSE == null ? 0 : this.mBSE.hashCode());
        result = 31 * result + (this.mBackend == null ? 0 : this.mBackend.hashCode());
        result = 31 * result + (this.mBshellName == null ? 0 : this.mBshellName.hashCode());
        result = 31 * result + (this.mClientLanguage == null ? 0 : this.mClientLanguage.hashCode());
        result = 31 * result + (this.mClientLocale == null ? 0 : this.mClientLocale.hashCode());
        result = 31 * result + (this.mClientLocationHost == null ? 0 : this.mClientLocationHost.hashCode());
        result = 31 * result + (this.mClientLocationIP == null ? 0 : this.mClientLocationIP.hashCode());
        result = 31 * result + (this.mCommand == null ? 0 : this.mCommand.hashCode());
        result = 31 * result + this.mCompany;
        result = 31 * result + (this.mDaemonOptions == null ? 0 : this.mDaemonOptions.hashCode());
        result = 31 * result + (this.mForceCleanup ? 1231 : 1237);
        result = 31 * result + this.mMaxConnections;
        result = 31 * result + this.mMaxReferences;
        result = 31 * result + this.mMaxThreads;
        result = 31 * result + (this.mPassword == null ? 0 : this.mPassword.hashCode());
        result = 31 * result + this.mPort;
        result = 31 * result + (this.mTenant == null ? 0 : this.mTenant.hashCode());
        result = 31 * result + this.mTimerDelay;
        result = 31 * result + (this.mUserName == null ? 0 : this.mUserName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionSpecImpl)) {
            return false;
        }
        ConnectionSpecImpl other = (ConnectionSpecImpl)obj;
        if (this.mActivationType == null ? other.mActivationType != null : !this.mActivationType.equals(other.mActivationType)) {
            return false;
        }
        if (this.mBSE == null ? other.mBSE != null : !this.mBSE.equals(other.mBSE)) {
            return false;
        }
        if (this.mBackend == null ? other.mBackend != null : !this.mBackend.equals(other.mBackend)) {
            return false;
        }
        if (this.mBshellName == null ? other.mBshellName != null : !this.mBshellName.equals(other.mBshellName)) {
            return false;
        }
        if (this.mClientLanguage == null ? other.mClientLanguage != null : !this.mClientLanguage.equals(other.mClientLanguage)) {
            return false;
        }
        if (this.mClientLocale == null ? other.mClientLocale != null : !this.mClientLocale.equals(other.mClientLocale)) {
            return false;
        }
        if (this.mClientLocationHost == null ? other.mClientLocationHost != null : !this.mClientLocationHost.equals(other.mClientLocationHost)) {
            return false;
        }
        if (this.mClientLocationIP == null ? other.mClientLocationIP != null : !this.mClientLocationIP.equals(other.mClientLocationIP)) {
            return false;
        }
        if (this.mCommand == null ? other.mCommand != null : !this.mCommand.equals(other.mCommand)) {
            return false;
        }
        if (this.mCompany != other.mCompany) {
            return false;
        }
        if (this.mDaemonOptions == null ? other.mDaemonOptions != null : !this.mDaemonOptions.equals(other.mDaemonOptions)) {
            return false;
        }
        if (this.mForceCleanup != other.mForceCleanup) {
            return false;
        }
        if (this.mMaxConnections != other.mMaxConnections) {
            return false;
        }
        if (this.mMaxReferences != other.mMaxReferences) {
            return false;
        }
        if (this.mMaxThreads != other.mMaxThreads) {
            return false;
        }
        if (this.mPassword == null ? other.mPassword != null : !this.mPassword.equals(other.mPassword)) {
            return false;
        }
        if (this.mPort != other.mPort) {
            return false;
        }
        if (this.mTenant == null ? other.mTenant != null : !this.mTenant.equals(other.mTenant)) {
            return false;
        }
        if (this.mTimerDelay != other.mTimerDelay) {
            return false;
        }
        return !(this.mUserName == null ? other.mUserName != null : !this.mUserName.equals(other.mUserName));
    }

    @Override
    public String getClientLocationHost() {
        return this.mClientLocationHost;
    }

    public void setClientLocationHost(String hostname) {
        this.mClientLocationHost = hostname;
    }

    @Override
    public String getClientLocationIP() {
        return this.mClientLocationIP;
    }

    public void setClientLocationIP(String ipAddress) {
        this.mClientLocationIP = ipAddress;
    }

    @Override
    public String getClientLanguage() {
        return this.mClientLanguage;
    }

    public void setClientLanguage(String language) {
        this.mClientLanguage = language;
    }

    @Override
    public String getClientLocale() {
        return this.mClientLocale;
    }

    public void setClientLocale(String locale) {
        this.mClientLocale = locale;
    }

    @Override
    public int getConnectionMethod() {
        if (this.mActivationType.compareToIgnoreCase("rexec") == 0 || this.mActivationType.compareToIgnoreCase("execbaan") == 0) {
            return 1;
        }
        if (this.mActivationType.compareToIgnoreCase("baanlogin") == 0) {
            return 2;
        }
        if (this.mActivationType.compareToIgnoreCase("baanlogin_sso") == 0) {
            return 6;
        }
        if (this.mActivationType.compareToIgnoreCase("baanlogin_ssl") == 0) {
            return 8;
        }
        if (this.mActivationType.compareToIgnoreCase("socketout") == 0) {
            return 3;
        }
        if (this.mActivationType.compareToIgnoreCase("socket_sso") == 0) {
            return 7;
        }
        if (this.mActivationType.compareToIgnoreCase("socket_ticket") == 0) {
            return 9;
        }
        if (this.mActivationType.compareToIgnoreCase("socketin") == 0) {
            return 4;
        }
        if (this.mActivationType.compareToIgnoreCase("http_basic") == 0) {
            return 10;
        }
        if (this.mActivationType.compareToIgnoreCase("http_oauth2") == 0) {
            return 11;
        }
        if (this.mActivationType.startsWith("EA:")) {
            return 5;
        }
        return 3;
    }

    public void setConnectionPointsManager(ConnectionPointsManager iManager) throws ResourceException {
        this.mConnectionPointsManager = iManager;
        if (!this.mResolved) {
            this.resolveConnectionPoint();
        }
    }

    private void resolveConnectionPoint() throws ResourceException {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "resolveConnectionPoint: " + this.mConnectionPoint);
        ConnectionPoint endPoint = this.mConnectionPointsManager.getCP(this.mConnectionPoint);
        if (endPoint == null) {
            String errorMsg = "Connectionpoint: " + this.mConnectionPoint + " not defined";
            LOG.error(Logger.EVENT_FAILURE, errorMsg);
            throw new ResourceException(errorMsg);
        }
        if (endPoint.isAlias()) {
            String aliasName = this.mConnectionPoint;
            this.mConnectionPoint = endPoint.getLinkTo();
            this.mBdeManagerCompany = endPoint.getBdeManagerCompany();
            endPoint = this.mConnectionPointsManager.getCP(this.mConnectionPoint);
            if (endPoint == null) {
                String errorMsg = "Alias from: '" + aliasName + "' To: '" + this.mConnectionPoint + "' not defined";
                LOG.error(Logger.EVENT_FAILURE, errorMsg);
                throw new ResourceException(errorMsg);
            }
            if (endPoint.isAlias()) {
                String errorMsg = "Alias from: '" + aliasName + "' to another Alias: '" + this.mConnectionPoint + "' not allowed";
                LOG.error(Logger.EVENT_FAILURE, errorMsg);
                throw new ResourceException(errorMsg);
            }
        }
        ConnectionPointActivation activation = endPoint.getActivation();
        this.mBackend = endPoint.getHostName();
        this.mPort = endPoint.getPort();
        this.mTimerDelay = endPoint.getTimerDelay();
        this.mMaxConnections = endPoint.getMaxConnections();
        this.mMaxReferences = endPoint.getMaxReferences();
        this.mMaxThreads = endPoint.getMaxThreads();
        this.mForceCleanup = endPoint.getForceCleanup();
        if (activation != null) {
            this.mActivationType = activation.getActivationType();
            this.mBSE = activation.getActivationBse();
            this.mBshellName = activation.getActivationBshell();
            this.mCommand = activation.getActivationEnvironment();
            this.mDaemonOptions = activation.getActivationDaemonOptions();
            if (this.mCompany == -1) {
                this.mCompany = activation.getActivationCompany();
            }
            if (this.mUserName == null || this.mUserName.length() == 0) {
                this.mUserName = activation.getActivationUser();
                this.mPassword = activation.getActivationPassword();
            }
            if (this.mTenant == null || this.mTenant.length() == 0) {
                this.mTenant = activation.getActivationTenant();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(Logger.EVENT_UNSPECIFIED, "Activation type:" + activation.getActivationType() + " company number:" + Integer.toString(this.mCompany) + " user:'" + this.mUserName + "'" + (this.mTenant != null && this.mTenant.length() > 0 ? " tenant:" + this.mTenant : ""));
            }
        } else if (this.mActivationType == null) {
            this.mActivationType = "";
        }
        this.mResolved = true;
    }

    public String toString() {
        String retString = "";
        if (this.mConnectionPoint != null) {
            retString = "[ConnectionPoint]" + this.mConnectionPoint + " ";
        }
        if (this.mBackend != null) {
            retString = retString + "[Backend]" + this.mBackend + " ";
        }
        if (this.mActivationType != null) {
            retString = retString + "[Activation]" + this.mActivationType + " ";
        }
        retString = retString + "[Port]" + Integer.toString(this.mPort) + " ";
        if (this.mBSE != null) {
            retString = retString + "[BSE]" + this.mBSE + " ";
        }
        if (this.mUserName != null) {
            retString = retString + "[User]" + this.mUserName + " ";
        }
        if (this.mTenant != null && this.mTenant.length() > 0) {
            retString = retString + "[Tenant]" + this.mTenant + " ";
        }
        return retString;
    }

    @Override
    public String getConnectionMethodString() {
        switch (this.getConnectionMethod()) {
            case 1: {
                return "REXEC";
            }
            case 2: {
                return "BAANLOGIN";
            }
            case 6: {
                return "BAANLOGIN_SSO";
            }
            case 8: {
                return "BAANLOGIN_SSL";
            }
            case 4: {
                return "SOCKETIN";
            }
            case 3: {
                return "SOCKETOUT";
            }
            case 7: {
                return "SOCKETOUT_SSO";
            }
            case 9: {
                return "SOCKETOUT_TICKET";
            }
            case 10: {
                return "HTTP_BASIC";
            }
            case 11: {
                return "HTTP_OAUTH2";
            }
            case 5: {
                return "EA";
            }
        }
        return "none";
    }

    @Override
    public String getApplication() {
        return this.mApplication;
    }

    public void setApplication(String application) {
        this.mApplication = application;
    }

    @Override
    public OAuth2Callback getOAuth2Callback() {
        return this.mOAuth2Callback;
    }

    public void setOAuth2Callback(OAuth2Callback OAuth2Callback2) {
        this.mOAuth2Callback = OAuth2Callback2;
    }
}

