/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.ConnectionSupervisor;
import com.infor.erpln.jca.ManagedConnectionFactoryImpl;
import com.infor.erpln.jca.ManagedConnectionImpl;
import com.infor.erpln.jca.PoolStatistics;
import com.infor.erpln.jca.TimerCloseTask;
import com.infor.erpln.protocol.BaanConnectionException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ConnectionManagerPerUser
implements ConnectionManager,
Serializable,
ConnectionEventListener {
    private final ArrayList<ManagedConnectionImpl> mIdleConnections;
    private final ArrayList<ManagedConnectionImpl> mActiveConnections;
    private final ArrayList<ConnectionBucket> mWaitQueue;
    private final String mTenant;
    private final String mUser;
    private final ConnectionSupervisor mSupervisor;
    private static final Logger LOG = ESAPI.getLogger(ConnectionManagerPerUser.class);

    public ConnectionManagerPerUser(ConnectionSupervisor supervisor, String tenant, String user) {
        this.mSupervisor = supervisor;
        this.mIdleConnections = new ArrayList();
        this.mActiveConnections = new ArrayList();
        this.mWaitQueue = new ArrayList();
        this.mTenant = tenant;
        this.mUser = user;
    }

    public Object allocateConnection(ManagedConnectionFactory iManagedConnectionFactory, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        ConnectionBucket bucket;
        LOG.info(Logger.EVENT_UNSPECIFIED, "allocateConnection()");
        do {
            ConnectionImpl connection;
            if ((connection = (bucket = this.doAllocateConnection(iManagedConnectionFactory, iConnectionRequestInfo)).getConnection()) == null) continue;
            return connection;
        } while (bucket.getRetry());
        throw new ResourceException("Unexpected error in allocateConnection()");
    }

    private synchronized ConnectionBucket doAllocateConnection(ManagedConnectionFactory iManagedConnectionFactory, ConnectionRequestInfo iConnectionRequestInfo) throws ResourceException {
        ManagedConnectionFactoryImpl factory = (ManagedConnectionFactoryImpl)iManagedConnectionFactory;
        ManagedConnectionImpl managedConnection = null;
        if (iConnectionRequestInfo instanceof ConnectionSpecImpl) {
            Iterator<ManagedConnectionImpl> it;
            ConnectionSpecImpl connectionSpec = (ConnectionSpecImpl)iConnectionRequestInfo;
            if (!this.mIdleConnections.isEmpty() && connectionSpec != null && (managedConnection = (ManagedConnectionImpl)factory.matchManagedConnections(it = this.mIdleConnections.iterator(), null, connectionSpec)) != null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Re-use connection from idle pool");
                TimerCloseTask task = managedConnection.getCloseTask();
                task.cancel();
                this.mIdleConnections.remove(managedConnection);
                managedConnection.setTakenFromPool(true);
                this.mActiveConnections.add(managedConnection);
            }
            if (managedConnection == null && connectionSpec.getMaxConnections() > 0 && !this.mActiveConnections.isEmpty()) {
                if (connectionSpec.getMaxReferences() > 0) {
                    managedConnection = this.getSharedConnection(connectionSpec);
                    if (managedConnection != null) {
                        LOG.info(Logger.EVENT_UNSPECIFIED, "Share with active connection");
                    }
                } else {
                    int count = this.getMatchingActiveConnections(connectionSpec);
                    if (count >= connectionSpec.getMaxConnections()) {
                        if (connectionSpec.getMaxThreads() > 0) {
                            ConnectionBucket bucket = this.queueBucket(connectionSpec);
                            LOG.info(Logger.EVENT_UNSPECIFIED, "Queue thread, wait for closed connection");
                            return bucket;
                        }
                        String tenant = connectionSpec.getTenant();
                        String message = "Maximum number of connections reached while sharing not allowed. Tenant=" + tenant;
                        throw new ResourceException(message);
                    }
                }
            }
        }
        if (managedConnection == null) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "Allocate a new connection");
            managedConnection = (ManagedConnectionImpl)iManagedConnectionFactory.createManagedConnection(null, iConnectionRequestInfo);
            managedConnection.addConnectionEventListener(this);
            this.mActiveConnections.add(managedConnection);
        }
        ConnectionBucket bucket = new ConnectionBucket(iConnectionRequestInfo);
        ConnectionImpl connection = managedConnection.getConnection(null, iConnectionRequestInfo);
        bucket.setConnection(connection);
        return bucket;
    }

    private ManagedConnectionImpl getSharedConnection(ConnectionSpecImpl iConnectionSpec) {
        ManagedConnectionImpl foundConnection = null;
        ManagedConnectionImpl candidateConnection = null;
        int count = 0;
        int minReferenceCount = Integer.MAX_VALUE;
        int maxReferences = iConnectionSpec.getMaxReferences();
        assert (maxReferences > 0);
        for (ManagedConnectionImpl managedConnection : this.mActiveConnections) {
            ConnectionSpecImpl currentSpec = managedConnection.getConnectionSpec();
            if (!currentSpec.equals(iConnectionSpec) || !managedConnection.isValid()) continue;
            ++count;
            if (managedConnection.getNumOpenConnections() >= minReferenceCount) continue;
            candidateConnection = managedConnection;
            minReferenceCount = managedConnection.getNumOpenConnections();
        }
        if (count > 0) {
            if (count >= iConnectionSpec.getMaxConnections()) {
                foundConnection = candidateConnection;
            } else if (maxReferences != Integer.MAX_VALUE && minReferenceCount < maxReferences) {
                foundConnection = candidateConnection;
            }
        }
        return foundConnection;
    }

    private int getMatchingActiveConnections(ConnectionSpecImpl iConnectionSpec) {
        int count = 0;
        for (ManagedConnectionImpl managedConnection : this.mActiveConnections) {
            ConnectionSpecImpl currentSpec = managedConnection.getConnectionSpec();
            if (!currentSpec.equals(iConnectionSpec) || !managedConnection.isValid()) continue;
            ++count;
        }
        return count;
    }

    private ConnectionBucket queueBucket(ConnectionSpecImpl connectionSpec) throws ResourceException {
        int count = 0;
        for (ConnectionBucket bucket : this.mWaitQueue) {
            if (!bucket.getConnectionSpec().equals((Object)connectionSpec)) continue;
            ++count;
        }
        if (count >= connectionSpec.getMaxThreads()) {
            String tenant = connectionSpec.getTenant();
            String message = "Maximum number of connections reached, sharing not allowed and maximum number of threads queued. Tenant=" + tenant;
            throw new ResourceException(message);
        }
        ConnectionBucket bucket = new ConnectionBucket(connectionSpec);
        this.mWaitQueue.add(bucket);
        return bucket;
    }

    public synchronized void destroy() {
        LOG.info(Logger.EVENT_UNSPECIFIED, "destroy()");
        this.destroyPool(this.mIdleConnections);
        this.destroyPool(this.mActiveConnections);
        for (ConnectionBucket bucket : this.mWaitQueue) {
            bucket.setException(new ResourceException("Cleanup"));
        }
        this.mWaitQueue.clear();
    }

    private void destroyPool(ArrayList<ManagedConnectionImpl> iPool) {
        for (ManagedConnectionImpl managedConnection : iPool) {
            try {
                managedConnection.destroy();
                LOG.debug(Logger.EVENT_SUCCESS, "Managed Connection destroyed:" + managedConnection.toString());
            }
            catch (ResourceException e) {
                LOG.error(Logger.EVENT_FAILURE, "Failed destroying connection. " + e.getMessage(), (Throwable)e);
            }
        }
        iPool.clear();
    }

    public synchronized void connectionClosed(ConnectionEvent iEvent) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "connectionClosed()");
        ManagedConnectionImpl managedConnection = (ManagedConnectionImpl)iEvent.getSource();
        ConnectionSpecImpl connectionSpec = managedConnection.getConnectionSpec();
        ConnectionImpl connection = (ConnectionImpl)iEvent.getConnectionHandle();
        managedConnection.cleanup(connection);
        if (managedConnection.getNumOpenConnections() <= 0) {
            boolean assignedToWaitingThread = false;
            if (connectionSpec.getMaxConnections() > 0 && connectionSpec.getMaxReferences() == 0 && connectionSpec.getMaxThreads() > 0) {
                assignedToWaitingThread = this.assignToWaitingThread(managedConnection);
            }
            if (!assignedToWaitingThread) {
                this.mActiveConnections.remove(managedConnection);
                if (connectionSpec.getTimerDelay() > 0) {
                    LOG.debug(Logger.EVENT_UNSPECIFIED, "Store in idle pool");
                    this.mIdleConnections.add(0, managedConnection);
                    managedConnection.createCloseTask(this);
                    Timer timer = this.mSupervisor.getIdleTimer();
                    timer.schedule((TimerTask)managedConnection.getCloseTask(), 1000 * connectionSpec.getTimerDelay());
                } else {
                    try {
                        managedConnection.destroy();
                    }
                    catch (ResourceException e) {
                        LOG.error(Logger.EVENT_FAILURE, "Failed to destroy the ManagedConnection: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean assignToWaitingThread(ManagedConnectionImpl managedConnection) {
        ConnectionSpecImpl spec = managedConnection.getConnectionSpec();
        ConnectionBucket foundBucket = null;
        boolean retval = false;
        for (ConnectionBucket bucket : this.mWaitQueue) {
            if (!spec.equals(bucket.getConnectionSpec())) continue;
            foundBucket = bucket;
            break;
        }
        if (foundBucket != null) {
            boolean retry = false;
            this.mWaitQueue.remove(foundBucket);
            try {
                if (managedConnection.isValid()) {
                    LOG.info(Logger.EVENT_UNSPECIFIED, "Assign closed connection to waiting thread");
                    managedConnection.setTakenFromPool(true);
                    foundBucket.setConnection(managedConnection.getConnection(null, spec));
                    retval = true;
                } else {
                    retry = true;
                }
            }
            catch (ResourceException e) {
                retry = true;
            }
            if (retry) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Awake waiting thread to retry in allocateConnection");
                foundBucket.setRetry(true);
            }
        }
        return retval;
    }

    public synchronized void deleteManagedConnectionAfterTimer(ManagedConnectionImpl iManagedConnection) {
        LOG.debug(Logger.EVENT_UNSPECIFIED, "Timer expired: destroy managed connection");
        if (this.mIdleConnections.contains(iManagedConnection)) {
            try {
                iManagedConnection.destroy();
            }
            catch (ResourceException e) {
                LOG.error(Logger.EVENT_FAILURE, e.getMessage(), (Throwable)e);
            }
            this.mIdleConnections.remove(iManagedConnection);
            LOG.debug(Logger.EVENT_SUCCESS, "removed managedConnection from the Idle connection pool because timer expired");
        }
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent iEvent) {
        LOG.info(Logger.EVENT_UNSPECIFIED, "connectionErrorOccurred()");
        ManagedConnectionImpl managedConnection = (ManagedConnectionImpl)iEvent.getSource();
        BaanConnectionException connectException = (BaanConnectionException)iEvent.getException();
        int reason = connectException.getReason();
        if (6 == reason && managedConnection.isValid()) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "connectionError reason = '" + reason + "', Communication Error caused by BdeHandler");
            ConnectionImpl connection = (ConnectionImpl)iEvent.getConnectionHandle();
            managedConnection.removeConnection(connection);
            connection.invalidate();
        } else {
            LOG.info(Logger.EVENT_UNSPECIFIED, "connectionError reason = '" + reason + "', Communication Error caused by Bshell");
            try {
                managedConnection.destroy();
            }
            catch (ResourceException connection) {
                // empty catch block
            }
            this.mActiveConnections.remove(managedConnection);
            TimerCloseTask task = managedConnection.getCloseTask();
            if (task != null) {
                task.cancel();
            }
            this.mIdleConnections.remove(managedConnection);
            LOG.debug(Logger.EVENT_SUCCESS, "removed managedConnection from the connection pool because error occurred");
        }
    }

    public void localTransactionCommitted(ConnectionEvent iEvent) {
    }

    public void localTransactionRolledback(ConnectionEvent iEvent) {
    }

    public void localTransactionStarted(ConnectionEvent iEvent) {
    }

    public PoolStatistics getPoolStatistics() {
        int idle = this.mIdleConnections.size();
        int active = this.mActiveConnections.size();
        int waiting = this.mWaitQueue.size();
        LOG.info(Logger.EVENT_UNSPECIFIED, "getPoolStatistics");
        if (idle > 0 || active > 0 || waiting > 0) {
            PoolStatistics stats = new PoolStatistics();
            stats.setTenant(this.mTenant != null ? this.mTenant : "");
            stats.setUser(this.mUser != null ? this.mUser : "");
            stats.setIdleBshells(idle);
            stats.setActiveBshells(active);
            stats.setWaitingThreads(waiting);
            return stats;
        }
        return null;
    }

    private static class ConnectionBucket {
        private ConnectionImpl mConnection;
        private final ConnectionRequestInfo mConfigSpec;
        private ResourceException mException;
        private boolean mRetry;

        public ConnectionBucket(ConnectionRequestInfo configSpec) {
            this.mConfigSpec = configSpec;
        }

        public synchronized ConnectionImpl getConnection() throws ResourceException {
            while (this.mConnection == null && this.mException == null && !this.mRetry) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.mException != null) {
                throw this.mException;
            }
            return this.mConnection;
        }

        public synchronized void setConnection(ConnectionImpl connection) {
            this.mConnection = connection;
            this.notifyAll();
        }

        public synchronized void setException(ResourceException exception) {
            this.mException = exception;
            this.notifyAll();
        }

        public ConnectionRequestInfo getConnectionSpec() {
            return this.mConfigSpec;
        }

        public synchronized boolean getRetry() {
            return this.mRetry;
        }

        public synchronized void setRetry(boolean set) {
            this.mRetry = set;
            this.notifyAll();
        }
    }
}

