/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.jca;

import java.io.UnsupportedEncodingException;
import javax.resource.ResourceException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class BDEException
extends ResourceException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = ESAPI.getLogger(BDEException.class);
    private byte[] m_result;
    private int m_returnValue;

    public BDEException(String p_message, byte[] p_result, int p_returnValue) {
        super(p_message);
        this.m_result = p_result;
        this.m_returnValue = p_returnValue;
    }

    public byte[] getResult() {
        return this.m_result;
    }

    public String getResultString() {
        String dataString = "";
        try {
            dataString = new String(this.m_result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(Logger.EVENT_FAILURE, "Encoding Failure", (Throwable)e);
        }
        return dataString;
    }

    public int getReturnValue() {
        return this.m_returnValue;
    }

    public void setResult(byte[] p_result) {
        this.m_result = p_result;
    }

    public void setResultString(String p_result) {
        try {
            this.m_result = p_result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(Logger.EVENT_FAILURE, "Encoding Failure", (Throwable)e);
        }
    }

    public void setReturnValue(int p_returnValue) {
        this.m_returnValue = p_returnValue;
    }
}

