/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.shared.bde;

import com.infor.ln.workbench.shared.bde.KeyValuePair;
import java.io.Serializable;
import java.util.ArrayList;

public class Message
implements Serializable {
    private String m_code;
    private MessageType m_type;
    private String m_text;
    private String m_source;
    private ArrayList<KeyValuePair> m_identifiers;

    private Message() {
    }

    public Message(String a_code, MessageType a_type, String a_text, String a_source) {
        this.m_code = a_code;
        this.m_type = a_type;
        this.m_text = a_text;
        this.m_source = a_source;
    }

    public String getCode() {
        return this.m_code;
    }

    public void setCode(String a_code) {
        this.m_code = a_code;
    }

    public MessageType getType() {
        return this.m_type;
    }

    public void setType(MessageType a_type) {
        this.m_type = a_type;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String a_text) {
        this.m_text = a_text;
    }

    public String getSource() {
        return this.m_source;
    }

    public void setSource(String a_source) {
        this.m_source = a_source;
    }

    public ArrayList<KeyValuePair> getIdentifiers() {
        if (this.m_identifiers == null) {
            this.m_identifiers = new ArrayList();
        }
        return this.m_identifiers;
    }

    public void addIdentifier(KeyValuePair a_identifierValue) {
        this.getIdentifiers().add(a_identifierValue);
    }

    public boolean isValidationMessage() {
        return this.m_type == MessageType.ERROR && this.m_source.equals("Application");
    }

    public static enum MessageType {
        ERROR("Error"),
        WARNING("Warning"),
        INFO("Information");

        private String m_name;

        private MessageType(String a_name) {
            this.m_name = a_name;
        }

        public String getName() {
            return this.m_name;
        }

        public static MessageType fromName(String a_name) {
            for (MessageType type : MessageType.values()) {
                if (!type.getName().equalsIgnoreCase(a_name)) continue;
                return type;
            }
            throw new IllegalArgumentException(a_name);
        }
    }
}

