/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.ln.workbench.server.config.ConfigManager;
import com.infor.ln.workbench.server.config.HasTokenHandler;
import com.infor.ln.workbench.server.dll.DLLTools;
import com.infor.ln.workbench.server.dll.InitInput;
import com.infor.ln.workbench.server.dll.InitOutput;
import com.infor.ln.workbench.server.web.DateUtil;
import com.infor.ln.workbench.server.web.FileUtil;
import com.infor.ln.workbench.server.web.GwtHtmlWriter;
import com.infor.ln.workbench.server.web.LogEntry;
import com.infor.ln.workbench.server.web.RequestValidator;
import com.infor.ln.workbench.server.web.SessionState;
import com.infor.ln.workbench.server.web.StartupParameters;
import com.infor.ln.workbench.server.web.UrlParameters;
import com.infor.ln.workbench.server.web.Utils;
import com.infor.ln.workbench.server.web.WorkbenchStartParameters;
import com.infor.ln.workbench.server.web.WorkbenchState;
import com.infor.ln.workbench.shared.IBackendParameters;
import com.infor.ln.workbench.shared.resources.LNResources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public abstract class WorkbenchBuilder
extends HttpServlet {
    private static final Logger LOG = ESAPI.getLogger(WorkbenchBuilder.class);
    private final RequestValidator m_validator = new RequestValidator();
    private static final Pattern BACKEND_HOST_AND_PORT = Pattern.compile("tcp://([\\p{Alnum}.\\-]+):(\\p{Digit}+)");
    private static final Pattern BACKEND_TOKEN = Pattern.compile("tok:(\\p{Graph}+)");

    public abstract WorkbenchConfiguration getWorkbenchConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.m_validator.isValid(request, response)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            this.logRequest(request);
        }
        try {
            if (request.getParameter("download") != null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Downloading log file");
                WorkbenchState state = this.getCurrentState(request, response);
                if (state != null) {
                    this.downloadLog(response, state);
                }
            } else if (request.getParameter("store") != null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Storing log file");
                WorkbenchState state = this.getCurrentState(request, response);
                if (state != null) {
                    this.storeLog(response, state);
                }
            } else if (request.getParameter("startLogviewer") != null) {
                LOG.info(Logger.EVENT_UNSPECIFIED, "Starting log viewer");
                WorkbenchState state = this.getCurrentState(request, response);
                if (state != null) {
                    String moduleName = state.getModuleName();
                    state.enableLogging();
                    this.startLogViewer(request, response, moduleName, state.isCloudEnabled(), state.getSessionState().getConfigManager().getParentList(), state.getToken());
                }
            } else if (request.getParameter("doSignout") != null) {
                WorkbenchState state = this.getCurrentStateOrIgnore(request);
                if (state != null) {
                    state.handleLogoutResponse();
                    LOG.info(Logger.EVENT_SUCCESS, "Azure sign-out completed");
                }
                this.confirmLogoutDone(response);
            } else {
                WorkbenchConfiguration workbenchConfiguration = this.getWorkbenchConfiguration();
                WorkbenchState workbenchState = this.startWorkbench(workbenchConfiguration, request, response);
                if (workbenchConfiguration.getResources() != null) {
                    workbenchState.getResourcesAsync(workbenchConfiguration.getResources());
                }
            }
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
        }
    }

    private String replace(String body, HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (value == null) {
            value = "";
        }
        LOG.debug(Logger.EVENT_UNSPECIFIED, "parameter[" + name + "] = " + value);
        return body.replace("##" + name + "##", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getParameter("method");
        if (StringUtils.isBlank((String)method)) {
            response.setContentType("text/html; charset=utf-8");
            Utils.setCacheHeaders(response);
            String body = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/com/infor/ln/workbench/server/web/post-token.html"), (Charset)StandardCharsets.UTF_8);
            body = this.replace(body, request, "id_token");
            body = this.replace(body, request, "state");
            body = this.replace(body, request, "session_state");
            body = this.replace(body, request, "error");
            body = this.replace(body, request, "error_description");
            IOUtils.write((String)body, (Writer)response.getWriter());
            return;
        }
        UrlParameters parameters = new UrlParameters(request);
        HttpSession session = request.getSession(false);
        if (session != null) {
            SessionState sessionState = SessionState.getSessionState(session);
            try {
                if ("close".equals(method)) {
                    String conId = parameters.getConnectionId();
                    LOG.info(Logger.EVENT_UNSPECIFIED, String.format("HTTP POST: method=close, conId=%s", conId));
                    WorkbenchState workbenchState = sessionState.getWorkbenchState(conId);
                    workbenchState.destroy();
                    sessionState.removeWorkbenchState(conId);
                } else if ("login".equals(method)) {
                    String authConnectionID = request.getParameter("state");
                    LOG.info(Logger.EVENT_UNSPECIFIED, String.format("HTTP POST from OAuth2.0 redirect, conId=%s", authConnectionID));
                    WorkbenchState workbenchState = sessionState.getWorkbenchState(authConnectionID);
                    workbenchState.handleLoginResponse(request);
                } else {
                    response.sendError(500, "Unsupported method");
                }
            }
            finally {
                WorkbenchState.setThreadLocalApplicationState(null);
            }
        }
    }

    private WorkbenchState getCurrentState(HttpServletRequest request, HttpServletResponse response) {
        WorkbenchState workbenchState = this.getCurrentStateOrIgnore(request);
        if (workbenchState == null) {
            response.setStatus(400);
        }
        return workbenchState;
    }

    private WorkbenchState getCurrentStateOrIgnore(HttpServletRequest request) {
        WorkbenchState workbenchState = null;
        HttpSession currentSession = request.getSession(false);
        if (currentSession != null) {
            String connectionID;
            SessionState sessionState = SessionState.getSessionState(currentSession);
            workbenchState = sessionState.getWorkbenchState(connectionID = request.getParameter("conId"));
            if (workbenchState == null) {
                LOG.error(Logger.EVENT_FAILURE, "Workbench state not found for connectionID=" + connectionID);
            }
        } else {
            LOG.error(Logger.EVENT_FAILURE, "HTTP session not found");
        }
        return workbenchState;
    }

    private void downloadLog(HttpServletResponse response, WorkbenchState state) throws IOException {
        response.setContentType("text/plain; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=log.txt");
        Utils.setCacheHeaders(response);
        WorkbenchBuilder.writeLog((OutputStream)response.getOutputStream(), state);
    }

    private void storeLog(HttpServletResponse response, WorkbenchState state) throws IOException {
        File logDir = state.getSessionState().getConfigManager().getLogDirectory();
        File logFile = FileUtil.createUniqueFile("log-", "log", logDir);
        WorkbenchBuilder.writeLog(new FileOutputStream(logFile), state);
        response.setContentType("text/plain; charset=utf-8");
        Utils.setCacheHeaders(response);
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(logFile.getName().getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void writeLog(OutputStream os, WorkbenchState state) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            for (LogEntry entry : state.getLogEntries()) {
                String timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(entry.getTimestamp()));
                out.write(String.format("%s %-5s %s %s %s%n", new Object[]{timestamp, entry.getLevel(), entry.getLoggerName(), entry.getMessage(), entry.getStacktrace()}));
            }
        }
    }

    private void confirmLogoutDone(HttpServletResponse response) throws IOException {
        Utils.setCacheHeaders(response);
        response.setContentType("text/html; charset=utf-8");
        try (PrintWriter htmlOut = response.getWriter();){
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/com/infor/ln/workbench/server/auth/logout.html"), (Writer)htmlOut, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void startLogViewer(HttpServletRequest a_request, HttpServletResponse a_response, String a_moduleName, boolean a_cloudEnabled, String a_parentURLs, String a_token) throws IOException {
        LOG.info(Logger.EVENT_SUCCESS, "Creating GwtHtml bootstrap for LogViewer window");
        UrlParameters parameters = new UrlParameters(a_request);
        GwtHtmlWriter.writeLogHtmlDocument(a_response, parameters.getInforCurrentLanguage(), a_moduleName, a_cloudEnabled, a_parentURLs, a_token);
    }

    private WorkbenchState startWorkbench(WorkbenchConfiguration config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean success = false;
        HttpSession httpSession = request.getSession();
        SessionState sessionState = SessionState.getSessionState(httpSession);
        try {
            LOG.info(Logger.EVENT_UNSPECIFIED, "Starting workbench, module=" + config.getModuleName());
            UrlParameters parameters = new UrlParameters(request);
            ConnectionSpecImpl spec = this.getConnectionSpec(parameters, sessionState.getConfigManager().getTokenService());
            String workbenchPid = parameters.getConnectionId();
            String conId = workbenchPid + "-" + System.currentTimeMillis();
            boolean loggingEnabled = parameters.getLogging() != null;
            boolean cloudEnabled = parameters.isCloudEnabled();
            boolean startedByMingle = parameters.isStartedByMingle();
            WorkbenchStartParameters startParameters = new WorkbenchStartParameters();
            startParameters.setConId(conId);
            startParameters.setWorkbenchPid(workbenchPid);
            startParameters.setConfig(config);
            startParameters.setFactory(WorkbenchBuilder.getFactory(sessionState.getConfigManager()));
            startParameters.setSpec(spec);
            startParameters.setDevelopmentMode(StringUtils.isEmpty((String)parameters.getBackend()));
            startParameters.setStartLogging(loggingEnabled);
            startParameters.setCloudEnabled(cloudEnabled);
            startParameters.setTicket(parameters.getTicket());
            WorkbenchState workbenchState = sessionState.createWorkbenchState(startParameters);
            InitOutput initOutput = this.initWorkbench(workbenchState, config.getSessionCode(), workbenchPid);
            if (IBackendParameters.Permission.NONE == initOutput.getPermission()) {
                throw new IOException("No permission to run session:" + config.getSessionCode());
            }
            if (config.isUseDefaultMap()) {
                config.setMapType(initOutput.getDefaultMap());
            }
            int sessionTimeout = httpSession.getMaxInactiveInterval();
            if (initOutput.getSessionTimeout() != null && initOutput.getSessionTimeout() > 0) {
                sessionTimeout = Math.min(sessionTimeout, initOutput.getSessionTimeout());
                workbenchState.setSessionTimeout(true);
            }
            StartupParameters startupParameters = this.getStartupParameters(Utils.getLanguageString(request), Utils.getLocaleLocale(request), sessionTimeout, config.getSessionCode(), conId, sessionState.getToken());
            GwtHtmlWriter.writeStartupHtmlDocument(config.getModuleName(), initOutput, startupParameters, config.getIncludeScript(), config.getMapTypes(), sessionState.getConfigManager().getParentList(), startedByMingle, response);
            success = true;
            WorkbenchState workbenchState2 = workbenchState;
            return workbenchState2;
        }
        catch (ResourceException e) {
            String errorMessage = "Backend Connection failure";
            LOG.error(Logger.EVENT_FAILURE, errorMessage, (Throwable)e);
            throw new IOException(errorMessage, e);
        }
        catch (BaanDLLCallException e) {
            String errorMessage = "Backend DLL call failed";
            LOG.error(Logger.EVENT_FAILURE, errorMessage, (Throwable)e);
            throw new IOException(errorMessage, e);
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
            if (!success) {
                httpSession.invalidate();
            }
        }
    }

    protected InitOutput initWorkbench(WorkbenchState workbenchState, String sessionCode, String workbenchPid) throws BaanDLLCallException {
        DLLTools dllTools = new DLLTools(workbenchState);
        InitInput initInput = new InitInput();
        initInput.setTiv(1);
        initInput.setSessionCode(sessionCode);
        initInput.setSessionPid(workbenchPid);
        dllTools.setHideResponseLog(true);
        InitOutput initOutput = dllTools.executeXmlMethod2("ottstpxdesk", "init.workbench", initInput, new InitOutput());
        LOG.info(Logger.EVENT_SUCCESS, String.format("init.workbench response: permission=%s, firstDayOfWeek=%d, defaultMap=%s", initOutput.getPermission().toString(), initOutput.getFirstDayOfWeek(), initOutput.getDefaultMap().toString()));
        return initOutput;
    }

    private ConnectionSpecImpl getConnectionSpec(UrlParameters parameters, HasTokenHandler tokenService) throws IOException {
        boolean hasBackend = StringUtils.isNotEmpty((String)parameters.getBackend());
        if (hasBackend) {
            return this.getConnectionSpecForRunningBshell(parameters, tokenService);
        }
        return this.getConnectionSpecForNewBshell(parameters);
    }

    /*
     * Enabled aggressive block sorting
     */
    ConnectionSpecImpl getConnectionSpecForRunningBshell(UrlParameters parameters, HasTokenHandler tokenService) throws IOException {
        String backend = parameters.getBackend();
        String hostname = "";
        int portNr = -1;
        if (tokenService.isValid()) {
            Matcher tokenMatcher = BACKEND_TOKEN.matcher(backend);
            if (!tokenMatcher.matches()) {
                String text = "Backend token expected: " + backend;
                LOG.error(Logger.EVENT_FAILURE, text);
                throw new IOException(text);
            }
            HasTokenHandler.TokenResult result = tokenService.handle(tokenMatcher.group(1));
            if (!result.isOk()) {
                throw new IOException(result.getError());
            }
            hostname = result.getHostname();
            portNr = result.getPort();
        } else {
            Matcher uriMatcher = BACKEND_HOST_AND_PORT.matcher(backend);
            if (!uriMatcher.matches()) {
                String text = "Backend host and port expected: " + backend;
                LOG.error(Logger.EVENT_FAILURE, text);
                throw new IOException(text);
            }
            hostname = uriMatcher.group(1);
            portNr = this.parseInt(uriMatcher.group(2));
        }
        if (portNr <= 0) {
            String text = "Wrong port number";
            LOG.error(Logger.EVENT_FAILURE, text);
            throw new IOException(text);
        }
        String ticket = parameters.getTicket();
        this.assertParameterPresent(ticket, "Missing ticket parameter");
        String companyStr = parameters.getCompany();
        this.assertParameterPresent(companyStr, "Missing company parameter");
        int company = this.parseInt(companyStr);
        if (company < 0) {
            String text = "Wrong company number: " + company;
            LOG.error(Logger.EVENT_FAILURE, text);
            throw new IOException(text);
        }
        ConnectionSpecImpl spec = new ConnectionSpecImpl();
        spec.setActivationType("socket_ticket");
        spec.setBackend(hostname);
        spec.setPort(portNr);
        spec.setPassword(ticket);
        spec.setCompany(company);
        spec.setMaxConnections(1);
        spec.setMaxReferences(-1);
        return spec;
    }

    private int parseInt(String value) {
        int result;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            result = -1;
        }
        return result;
    }

    private void assertParameterPresent(String value, String errorMessage) throws IOException {
        if (StringUtils.isEmpty((String)value)) {
            LOG.error(Logger.EVENT_FAILURE, errorMessage);
            throw new IOException(errorMessage);
        }
    }

    private ConnectionSpecImpl getConnectionSpecForNewBshell(UrlParameters parameters) throws IOException {
        ConnectionSpecImpl spec = new ConnectionSpecImpl("default");
        String user = parameters.getUser();
        this.assertParameterPresent(user, "Missing user parameter");
        spec.setUser(user);
        String password = parameters.getPassword();
        this.assertParameterPresent(user, "Missing password parameter");
        spec.setPassword(password);
        return spec;
    }

    private static ConnectionFactoryImpl getFactory(ConfigManager configManager) {
        ConnectionFactoryImpl factory = new ConnectionFactoryImpl();
        File connectionPoints = configManager.initConnectionPoints();
        factory.setLocation(connectionPoints.getAbsolutePath());
        return factory;
    }

    private StartupParameters getStartupParameters(String language, Locale locale, int sessionTimeout, String sessionCode, String connectionId, String token) {
        String dateFormat = "";
        String timeMediumFormat = "";
        String timeShortFormat = "";
        String decimalSeparator = "";
        String groupingSeparator = "";
        if (locale != null) {
            dateFormat = DateUtil.getLocaleDateFormat(locale);
            timeMediumFormat = DateUtil.getLocaleTimeFormat(locale, 2);
            timeShortFormat = DateUtil.getLocaleTimeFormat(locale, 3);
            if (NumberFormat.getInstance(locale) instanceof DecimalFormat) {
                DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(locale);
                decimalSeparator = Character.toString(formatter.getDecimalFormatSymbols().getDecimalSeparator());
                groupingSeparator = Character.toString(formatter.getDecimalFormatSymbols().getGroupingSeparator());
            }
        }
        StartupParameters parameters = new StartupParameters();
        parameters.setLanguage(language);
        parameters.setSessionTimeout(sessionTimeout);
        parameters.setDateFormat(dateFormat);
        parameters.setTimeMediumFormat(timeMediumFormat);
        parameters.setTimeShortFormat(timeShortFormat);
        parameters.setDecimalSeparator(decimalSeparator);
        parameters.setGroupingSeparator(groupingSeparator);
        parameters.setSessionCode(sessionCode);
        parameters.setConnectionId(connectionId);
        parameters.setToken(token);
        return parameters;
    }

    private void logRequest(HttpServletRequest request) {
        String authHeader;
        StringBuffer url = request.getRequestURL();
        url.append("?").append(request.getQueryString());
        LOG.info(Logger.EVENT_UNSPECIFIED, "GET: " + url);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            StringBuffer cookiesBuf = new StringBuffer();
            for (Cookie cookie : cookies) {
                cookiesBuf.append(cookie.getName()).append("=").append(cookie.getValue()).append("; ");
            }
            LOG.info(Logger.EVENT_UNSPECIFIED, "Cookies:" + cookiesBuf);
        }
        if ((authHeader = request.getHeader("Authorization")) != null) {
            LOG.info(Logger.EVENT_UNSPECIFIED, "Authorization:" + authHeader);
        }
    }

    public static class WorkbenchConfiguration {
        private final String m_moduleName;
        private final String m_includeScript;
        private LNResources<?, ?, ?> m_resources;
        private final String m_sessionCode;
        private EnumSet<IBackendParameters.MapType> m_maptypes = EnumSet.noneOf(IBackendParameters.MapType.class);
        private boolean m_useDefaultMap = false;
        private String m_azureAppID;

        public WorkbenchConfiguration(String moduleName, String sessionCode) {
            this(moduleName, sessionCode, "");
        }

        public WorkbenchConfiguration(String moduleName, String sessionCode, String includeScript) {
            this.m_moduleName = moduleName;
            assert (StringUtils.isNotEmpty((String)this.m_moduleName));
            this.m_sessionCode = sessionCode;
            assert (StringUtils.isNotEmpty((String)this.m_sessionCode));
            this.m_includeScript = includeScript;
        }

        public String getModuleName() {
            return this.m_moduleName;
        }

        public String getIncludeScript() {
            return this.m_includeScript;
        }

        public void setResources(LNResources<?, ?, ?> resources) {
            this.m_resources = resources;
        }

        public LNResources<?, ?, ?> getResources() {
            return this.m_resources;
        }

        public String getSessionCode() {
            return this.m_sessionCode;
        }

        public void setMapType(IBackendParameters.MapType maptype) {
            this.m_maptypes.add(maptype);
        }

        public EnumSet<IBackendParameters.MapType> getMapTypes() {
            return this.m_maptypes;
        }

        public boolean isUseDefaultMap() {
            return this.m_useDefaultMap;
        }

        public void setUseDefaultMap(boolean useDefaultMap) {
            this.m_useDefaultMap = useDefaultMap;
        }

        public void setAzureAppID(String appID) {
            this.m_azureAppID = appID;
        }

        public String getAzureAppID() {
            return this.m_azureAppID == null ? "" : this.m_azureAppID;
        }
    }
}

