/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.ln.workbench.server.web.UrlParameters;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;

public class Utils {
    public static String getLocaleString(HttpServletRequest a_request) {
        UrlParameters parameters = new UrlParameters(a_request);
        String locale = parameters.getInforCurrentLocale();
        if (StringUtils.isEmpty((String)locale)) {
            return Utils.getLanguageString(a_request);
        }
        return locale.replace("-", "_");
    }

    public static String getLanguageString(HttpServletRequest a_request) {
        UrlParameters parameters = new UrlParameters(a_request);
        String language = parameters.getInforCurrentLanguage();
        if (StringUtils.isEmpty((String)language)) {
            Locale locale = a_request.getLocale();
            language = locale.getLanguage();
            if (language.equals(new Locale("he").getLanguage())) {
                language = "he";
            }
            if (StringUtils.isNotEmpty((String)locale.getCountry())) {
                language = language + "-" + locale.getCountry();
            }
        }
        if (StringUtils.isEmpty((String)language)) {
            return "en_US";
        }
        return language.replace("-", "_");
    }

    public static Locale getLocaleLanguage(HttpServletRequest a_request) {
        return Utils.toLocale(Utils.getLanguageString(a_request));
    }

    public static Locale getLocaleLocale(HttpServletRequest a_request) {
        return Utils.toLocale(Utils.getLocaleString(a_request));
    }

    public static void setCacheHeaders(HttpServletResponse a_response) {
        a_response.setHeader("Pragma", "no-cache");
        a_response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
        a_response.setDateHeader("Expires", 0L);
    }

    private static Locale toLocale(String languageString) {
        Locale locale;
        try {
            locale = LocaleUtils.toLocale((String)languageString);
        }
        catch (IllegalArgumentException e) {
            int separator = languageString.indexOf(95);
            locale = separator > 0 ? Utils.toLocale(languageString.substring(0, separator)) : LocaleUtils.toLocale((String)"en_US");
        }
        return locale;
    }

    private Utils() {
    }
}

