/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.ln.workbench.server.web.FileUtil;
import com.infor.ln.workbench.server.web.LogEntry;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class EventLog {
    private static final Logger LOG = ESAPI.getLogger(EventLog.class);
    private File m_file;
    private RandomAccessFile m_stream;
    private final ArrayList<Long> m_index = new ArrayList();

    public EventLog() throws IOException {
        this.init();
    }

    public synchronized void destroy() {
        try {
            if (this.m_stream != null) {
                this.m_index.clear();
                this.m_stream.close();
                this.m_stream = null;
                FileUtils.deleteQuietly((File)this.m_file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void append(LogEvent event) {
        if (this.m_stream != null) {
            try {
                Throwable cause;
                LogEntry entry = new LogEntry();
                entry.setLoggerName(event.getLoggerName());
                entry.setMessage(event.getMessage().getFormattedMessage());
                entry.setTimestamp(event.getTimeMillis());
                entry.setLevel(LogEntry.Level.valueOf(event.getLevel().toString()));
                entry.setStacktrace("");
                if (event.getThrown() != null && (cause = event.getThrown()) != null) {
                    String stackTrace = ExceptionUtils.getStackTrace((Throwable)cause);
                    entry.setStacktrace(stackTrace);
                }
                long start = this.m_stream.length();
                this.m_stream.seek(start);
                this.m_stream.writeUTF(entry.getLoggerName());
                String message = entry.getMessage();
                this.m_stream.writeInt((message.length() + Short.MAX_VALUE) / 32768);
                for (int i = 0; i < message.length(); i += 32768) {
                    int end = Math.min(message.length(), i + 32768);
                    this.m_stream.writeUTF(message.substring(i, end));
                }
                this.m_stream.writeUTF(entry.getStacktrace());
                this.m_stream.writeLong(entry.getTimestamp());
                this.m_stream.writeUTF(entry.getLevel().toString());
                this.m_index.add(start);
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception during log append", (Throwable)e);
            }
        }
    }

    public synchronized List<LogEntry> getEntries() {
        int count = this.m_index.size();
        if (this.m_stream != null && count > 0) {
            ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            try {
                this.m_stream.seek(this.m_index.get(0));
                for (int i = 0; i < count; ++i) {
                    LogEntry entry = new LogEntry();
                    entry.setLoggerName(this.m_stream.readUTF());
                    StringBuilder builder = new StringBuilder();
                    for (int nChunks = this.m_stream.readInt(); nChunks > 0; --nChunks) {
                        builder.append(this.m_stream.readUTF());
                    }
                    entry.setMessage(builder.toString());
                    entry.setStacktrace(this.m_stream.readUTF());
                    entry.setTimestamp(this.m_stream.readLong());
                    entry.setLevel(LogEntry.Level.valueOf(this.m_stream.readUTF()));
                    entries.add(entry);
                }
                return entries;
            }
            catch (IOException e) {
                LOG.error(Logger.EVENT_FAILURE, "Exception when retrieving eventlog entries", (Throwable)e);
            }
        }
        return new ArrayList<LogEntry>();
    }

    public synchronized void clear() {
        this.destroy();
        try {
            this.init();
        }
        catch (IOException ex) {
            LOG.error(Logger.EVENT_FAILURE, "Failed in instantiating a new EventLog after clearing it", (Throwable)ex);
        }
    }

    private void init() throws IOException {
        this.m_file = FileUtil.createTempFile("log-", "log");
        this.m_stream = new RandomAccessFile(this.m_file, "rw");
    }
}

