/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.web;

import com.infor.ln.workbench.server.web.WorkbenchState;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.ServletContext;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class ClientLogger {
    private static final Logger LOG = ESAPI.getLogger((String)ClientLogger.class.getName());
    private static final String ATTR_CLIENT_LOG_SYNCHRONIZER = "ClientLogSynchronizer";

    public void destroy() {
    }

    public void log(String connectionId, int sequenceId, LogRecord record) {
        this.writeLogRecord(connectionId, record, 0);
    }

    public static ClientLogger getClientLogger(ServletContext context, boolean create) {
        Object clientLogSynchronizer = context.getAttribute(ATTR_CLIENT_LOG_SYNCHRONIZER);
        if (!(clientLogSynchronizer instanceof ClientLogger)) {
            if (!create) {
                return null;
            }
            clientLogSynchronizer = new ClientLogger();
            context.setAttribute(ATTR_CLIENT_LOG_SYNCHRONIZER, clientLogSynchronizer);
        }
        return (ClientLogger)clientLogSynchronizer;
    }

    public void createLogQueue(String connectionId, WorkbenchState state) {
    }

    public void removeLogQueue(String connectionId) {
    }

    protected Logger getLogger(String loggerName) {
        return ESAPI.getLogger((String)loggerName);
    }

    private void writeLogRecord(String connectionId, LogRecord record, int skipped) {
        if (skipped > 0) {
            LOG.error(Logger.EVENT_FAILURE, "Missing " + skipped + " log messages at this point");
        }
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0) {
            message = MessageFormat.format(message, parameters);
        }
        Logger logger = this.getLogger(record.getLoggerName());
        Level level = record.getLevel();
        if (level == Level.SEVERE) {
            logger.error(Logger.EVENT_FAILURE, message, record.getThrown());
        } else if (level == Level.WARNING) {
            logger.warning(Logger.EVENT_SUCCESS, message, record.getThrown());
        } else if (level == Level.INFO || level == Level.CONFIG) {
            logger.info(Logger.EVENT_SUCCESS, message, record.getThrown());
        } else if (level == Level.FINE || level == Level.FINER) {
            logger.debug(Logger.EVENT_SUCCESS, message, record.getThrown());
        } else {
            logger.trace(Logger.EVENT_SUCCESS, message, record.getThrown());
        }
    }
}

