/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.rpc;

import com.google.gwt.user.client.rpc.RpcToken;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.XsrfToken;
import com.google.gwt.user.server.rpc.AbstractXsrfProtectedServiceServlet;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.infor.erpln.jca.bdeclient.JcaBdeResultException;
import com.infor.ln.workbench.server.bde.BDETools;
import com.infor.ln.workbench.server.web.SessionState;
import com.infor.ln.workbench.server.web.Utils;
import com.infor.ln.workbench.server.web.WorkbenchState;
import com.infor.ln.workbench.shared.MessageCode;
import com.infor.ln.workbench.shared.rpc.ServerRPCException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public abstract class BaseService
extends AbstractXsrfProtectedServiceServlet {
    private static final Logger LOG = ESAPI.getLogger(BaseService.class);

    public String processCall(String payload) throws SerializationException {
        try {
            Utils.setCacheHeaders(this.getThreadLocalResponse());
            String string = super.processCall(payload);
            return string;
        }
        finally {
            WorkbenchState.setThreadLocalApplicationState(null);
        }
    }

    protected HttpSession getHttpSession() {
        HttpServletRequest request = this.getThreadLocalRequest();
        return request.getSession();
    }

    protected SessionState getSessionState() {
        HttpSession session = this.getHttpSession();
        return SessionState.getSessionState(session);
    }

    public WorkbenchState getWorkbenchState(String a_conId) {
        HttpSession httpSession = this.getThreadLocalRequest().getSession(false);
        if (httpSession != null) {
            SessionState sessionState = SessionState.getSessionState(httpSession);
            WorkbenchState workbenchState = sessionState.getWorkbenchState(a_conId);
            if (workbenchState != null) {
                LOG.debug(Logger.EVENT_SUCCESS, "getWorkbenchState(conId=" + a_conId + ")");
                return workbenchState;
            }
            LOG.error(Logger.EVENT_FAILURE, "getWorkbenchState(conId=" + a_conId + "): workbench state not found");
            throw new IllegalStateException(MessageCode.WORKBENCH_STATE_ERROR.name());
        }
        LOG.error(Logger.EVENT_FAILURE, "getWorkbenchState(conId=" + a_conId + "): HTTP session not found");
        throw new IllegalStateException(MessageCode.HTTP_SESSION_ERROR.name());
    }

    public static WorkbenchState getWorkbenchState(HttpSession session, String conId) {
        SessionState sessionState = SessionState.getSessionState(session);
        WorkbenchState workbenchState = sessionState.getWorkbenchState(conId);
        LOG.info(Logger.EVENT_UNSPECIFIED, "getWorkbenchState(HttpSession, conId=" + conId + ")");
        assert (workbenchState != null);
        return workbenchState;
    }

    protected void validateXsrfToken(RpcToken token, Method method) {
        XsrfToken xsrfToken = (XsrfToken)token;
        if (xsrfToken == null || xsrfToken.getToken() == null || xsrfToken.getToken().isEmpty()) {
            throw new RpcTokenException("CSRF token missing");
        }
        String expectedToken = SessionState.getToken(this.getThreadLocalRequest());
        if (!expectedToken.isEmpty() && !expectedToken.equals(xsrfToken.getToken())) {
            String message = String.format("CSRF token mismatch: expected=%s, actual=%s, method=%s", StringUtils.abbreviateMiddle((String)expectedToken, (String)".", (int)7), StringUtils.abbreviateMiddle((String)xsrfToken.getToken(), (String)".", (int)7), method.getName());
            LOG.always(Logger.SECURITY_FAILURE, message);
            throw new ServiceException(403, "The request is not authorized");
        }
    }

    protected void doUnexpectedFailure(Throwable e) {
        try {
            this.getThreadLocalResponse().reset();
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException("Unable to report failure", e);
        }
        if (e instanceof ServiceException) {
            this.writeResponseForServiceException(this.getThreadLocalResponse(), (ServiceException)e);
        } else {
            RPCServletUtils.writeResponseForUnexpectedFailure((ServletContext)this.getServletContext(), (HttpServletResponse)this.getThreadLocalResponse(), (Throwable)e);
        }
    }

    private void writeResponseForServiceException(HttpServletResponse response, ServiceException failure) {
        LOG.info(Logger.EVENT_FAILURE, "ServiceException while dispatching incoming RPC call: " + failure.getMessage());
        try {
            response.setContentType("text/plain");
            response.setStatus(failure.getCode());
            try {
                response.getOutputStream().write(failure.getMessage().getBytes(StandardCharsets.UTF_8));
            }
            catch (IllegalStateException e) {
                response.getWriter().write(failure.getMessage());
            }
        }
        catch (IOException ex) {
            LOG.error(Logger.EVENT_FAILURE, "writeResponseForServiceException failed while sending the previous failure to the client", (Throwable)ex);
        }
    }

    protected ServerRPCException convertToServerRPCException(Exception a_exception) {
        LOG.info(Logger.EVENT_FAILURE, "Exception while handling RPC request:", (Throwable)a_exception);
        ServerRPCException rpcException = new ServerRPCException(a_exception.getMessage());
        if (a_exception instanceof JcaBdeResultException) {
            rpcException.setMessages(BDETools.convertMessages(((JcaBdeResultException)a_exception).getBdeMessage()));
        }
        if (!(a_exception instanceof IllegalStateException)) {
            rpcException.setStacktrace(ExceptionUtils.getStackTrace((Throwable)a_exception));
        }
        return rpcException;
    }

    private static class ServiceException
    extends RuntimeException {
        private final int m_code;

        ServiceException(int code, String message) {
            super(message);
            this.m_code = code;
        }

        int getCode() {
            return this.m_code;
        }
    }
}

