/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.dll;

import com.infor.erpln.jca.ConnectionImpl;
import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.BaanDLLCallException;
import com.infor.erpln.jca.dllclient.Parameter;
import com.infor.ln.workbench.server.JAXBUtils;
import com.infor.ln.workbench.server.web.WorkbenchState;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.w3c.dom.Node;

public class DLLTools {
    private final BaanDLLCall m_dllcall;
    private final Set<MessageOption> m_options = EnumSet.noneOf(MessageOption.class);

    public DLLTools(WorkbenchState a_workbenchState) {
        this.m_dllcall = a_workbenchState.createBaanDllCall();
    }

    public DLLTools(ConnectionImpl jcaConnection) {
        this.m_dllcall = WorkbenchState.createBaanDllCall(jcaConnection);
    }

    public <I, O> O executeXmlMethod2(String dll, String function, I input, O output) throws BaanDLLCallException {
        this.m_dllcall.setDLL(dll);
        this.m_dllcall.setFunction(function);
        this.m_dllcall.setReturnType("void");
        Class<?> outputType = output.getClass();
        XmlRootElement outputRootElement = outputType.getAnnotation(XmlRootElement.class);
        assert (outputRootElement != null);
        String outputParameterName = outputRootElement.name();
        Class<?> inputType = input.getClass();
        XmlRootElement inputRootElement = inputType.getAnnotation(XmlRootElement.class);
        assert (inputRootElement != null);
        String inputParameterName = inputRootElement.name();
        Parameter callInfoParam = new Parameter(inputParameterName, "in");
        callInfoParam.setValue((Node)JAXBUtils.createNodeFromObject(input, new Class[0]));
        Parameter callResultParam = new Parameter(outputParameterName, "out");
        callResultParam.setType("xmlstring");
        Parameter[] parameters = new Parameter[]{callInfoParam, callResultParam};
        this.m_dllcall.setParameters(parameters);
        this.m_dllcall.execute(this.m_options);
        Node resultNode = callResultParam.getXMLValue();
        return (O)JAXBUtils.createObjectFromNode(resultNode, outputType, new Class[0]);
    }

    public <T> T executeXmlMethod1(String dll, String function, T input, Class<?> ... optionalClasses) throws BaanDLLCallException {
        this.m_dllcall.setDLL(dll);
        this.m_dllcall.setFunction(function);
        this.m_dllcall.setReturnType("void");
        Class<?> ioType = input.getClass();
        XmlRootElement ioRootElement = ioType.getAnnotation(XmlRootElement.class);
        assert (ioRootElement != null);
        String ioParameterName = ioRootElement.name();
        Parameter ioParam = new Parameter(ioParameterName, "inout");
        ioParam.setValue((Node)JAXBUtils.createNodeFromObject(input, optionalClasses));
        Parameter[] parameters = new Parameter[]{ioParam};
        this.m_dllcall.setParameters(parameters);
        this.m_dllcall.execute(this.m_options);
        Node resultNode = ioParam.getXMLValue();
        return (T)JAXBUtils.createObjectFromNode(resultNode, ioType, optionalClasses);
    }

    public void setHideRequestLog(boolean hide) {
        if (hide) {
            this.m_options.add(MessageOption.HIDE_REQUEST_LOG);
        } else {
            this.m_options.remove(MessageOption.HIDE_REQUEST_LOG);
        }
    }

    public void setHideResponseLog(boolean hide) {
        if (hide) {
            this.m_options.add(MessageOption.HIDE_RESPONSE_LOG);
        } else {
            this.m_options.remove(MessageOption.HIDE_RESPONSE_LOG);
        }
    }
}

