/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.config;

import com.infor.ln.workbench.server.config.HasTokenHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

class HttpTokenService
implements HasTokenHandler {
    private static final Logger LOG = ESAPI.getLogger(HttpTokenService.class);
    private final String m_endpoint;
    private static final Pattern JSON_VALUE = Pattern.compile("\\s*\\{\\s*\"value\"\\s*:\\s*\"tcp:\\\\?/\\\\?/([\\p{Alnum}.\\-]+):(\\p{Digit}+)\"\\s*\\}\\s*");

    public HttpTokenService(String a_tokenService) {
        this.m_endpoint = a_tokenService + "/es_server/management/v1/tokens";
        LOG.info(Logger.EVENT_UNSPECIFIED, "ES Token Service configured; URL=" + this.m_endpoint);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public HasTokenHandler.TokenResult handle(String token) throws IOException {
        HasTokenHandler.TokenResult result;
        try (InputStream inputStream = this.getInputStream(URLEncoder.encode(token, StandardCharsets.UTF_8.toString()));){
            result = this.parseFrom(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            if (result.isOk()) {
                LOG.info(Logger.EVENT_SUCCESS, String.format("Lookup done; token=%s, result=%s", token, result));
            } else {
                LOG.error(Logger.EVENT_FAILURE, result.getError());
            }
        }
        catch (NullPointerException e) {
            result = HasTokenHandler.TokenResult.createError("Incomplete or no response from ES Token Service");
            LOG.error(Logger.EVENT_FAILURE, result.getError());
        }
        return result;
    }

    private HasTokenHandler.TokenResult parseFrom(String json) {
        HasTokenHandler.TokenResult result;
        Matcher valueMatcher = JSON_VALUE.matcher(json);
        if (valueMatcher.matches()) {
            result = HasTokenHandler.TokenResult.createUri(valueMatcher.group(1), Integer.parseInt(valueMatcher.group(2)));
        } else {
            StringBuilder error = new StringBuilder();
            try {
                JSONParser jsonParser = new JSONParser();
                JSONObject response = (JSONObject)jsonParser.parse(json);
                Long jsonError = (Long)response.get("code");
                String jsonMessage = (String)response.get("message");
                if (jsonError != null) {
                    error.append("JSON error: ").append(jsonError);
                }
                if (jsonMessage != null) {
                    if (error.length() == 0) {
                        error.append("JSON ");
                    } else {
                        error.append(", ");
                    }
                    error.append("message: ").append(StringUtils.abbreviate((String)jsonMessage, (int)50));
                }
            }
            catch (ParseException e) {
                error.append("Exception parsing JSON: ").append(StringUtils.abbreviate((String)json, (int)50));
            }
            if (error.length() == 0) {
                error.append("Received unsupported JSON: ").append(StringUtils.abbreviate((String)json, (int)50));
            }
            result = HasTokenHandler.TokenResult.createError(error.toString());
        }
        return result;
    }

    protected InputStream getInputStream(String encodedToken) throws IOException {
        URLConnection request = null;
        try {
            request = new URL(this.m_endpoint + "?token=" + encodedToken).openConnection();
            request.setRequestProperty("Accept", "application/json");
            return request.getInputStream();
        }
        catch (IOException e) {
            InputStream errorStream;
            if (request != null && (errorStream = ((HttpURLConnection)request).getErrorStream()) != null) {
                return errorStream;
            }
            throw new IOException("Exception accessing ES Token Service", e);
        }
    }
}

