/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.bde;

import com.infor.erpln.jca.bdeclient.BdeFilter;
import com.infor.ln.workbench.server.bde.ProcessingScope;
import com.infor.ln.workbench.shared.bde.KeyValuePair;
import com.infor.ln.workbench.shared.bde.Message;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

public class BDEData<T> {
    private Class<T> m_modelType;
    private String m_bdeName;
    private T m_bdeModel;
    private List<String> m_selectionAttributes;
    private BdeFilter m_filter;
    private List<KeyValuePair> m_controlAttributes;
    private ArrayList<Message> m_messages;
    private int m_maxObjects = -1;
    private int m_iteratorFetchSize = -1;

    public BDEData(Class<T> a_modelType) {
        String name;
        this.m_modelType = a_modelType;
        XmlRootElement rootElementAnnotation = this.m_modelType.getAnnotation(XmlRootElement.class);
        if (rootElementAnnotation != null && !"##default".equals(name = rootElementAnnotation.name())) {
            this.m_bdeName = name;
        }
    }

    public Class<T> getModelType() {
        return this.m_modelType;
    }

    public void setBdeName(String a_bdeName) {
        this.m_bdeName = a_bdeName;
    }

    public String getBDEName() {
        return this.m_bdeName;
    }

    public void setBDEModel(T a_bdeModel) {
        this.m_bdeModel = a_bdeModel;
    }

    public T getBDEModel() {
        return this.m_bdeModel;
    }

    public void addSelectionAttributes(String ... a_selectionAttributes) {
        if (a_selectionAttributes != null) {
            for (String attribute : a_selectionAttributes) {
                this.getSelectionAttributes().add(attribute);
            }
        }
    }

    public List<String> getSelectionAttributes() {
        if (this.m_selectionAttributes == null) {
            this.m_selectionAttributes = new ArrayList<String>();
        }
        return this.m_selectionAttributes;
    }

    public void setFilter(BdeFilter a_filter) {
        this.m_filter = a_filter;
    }

    public BdeFilter getFilter() {
        return this.m_filter;
    }

    public void addControlAttribute(String a_attributeName, String a_attributeValue) {
        this.getControlAttributes().add(new KeyValuePair(a_attributeName, a_attributeValue));
    }

    public List<KeyValuePair> getControlAttributes() {
        if (this.m_controlAttributes == null) {
            this.m_controlAttributes = new ArrayList<KeyValuePair>();
        }
        return this.m_controlAttributes;
    }

    public ArrayList<Message> getMessages() {
        if (this.m_messages == null) {
            this.m_messages = new ArrayList();
        }
        return this.m_messages;
    }

    public void addMessage(Message a_message) {
        this.getMessages().add(a_message);
    }

    public boolean hasMessages() {
        return this.m_messages != null && !this.m_messages.isEmpty();
    }

    public boolean hasErrors() {
        if (this.hasMessages()) {
            for (Message message : this.m_messages) {
                if (message.getType() != Message.MessageType.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    public void setMaxObjects(int a_maxObjects) {
        this.m_maxObjects = a_maxObjects;
    }

    public int getMaxObjects() {
        return this.m_maxObjects;
    }

    public void setProcessingScope(ProcessingScope a_processingScope) {
        this.addControlAttribute("processingScope", a_processingScope.getName());
    }

    public int getIteratorFetchSize() {
        return this.m_iteratorFetchSize;
    }

    public void setIteratorFetchSize(int a_iteratorFetchSize) {
        this.m_iteratorFetchSize = a_iteratorFetchSize;
    }

    public static class BDEDataBuilder<T> {
        private BDEData<T> m_data;
        private Class<T> m_modelType;

        public BDEDataBuilder(Class<T> a_modelType) {
            this.m_modelType = a_modelType;
            this.reset();
        }

        public void reset() {
            this.m_data = new BDEData<T>(this.m_modelType);
        }

        public BDEDataBuilder<T> setBDEName(String a_bdeName) {
            this.m_data.setBdeName(a_bdeName);
            return this;
        }

        public BDEDataBuilder<T> setBDEModel(T a_bdeModel) {
            this.m_data.setBDEModel(a_bdeModel);
            return this;
        }

        public BDEDataBuilder<T> addSelectionAttributes(String ... a_selectionAttributes) {
            this.m_data.addSelectionAttributes(a_selectionAttributes);
            return this;
        }

        public BDEDataBuilder<T> setFilter(BdeFilter a_filter) {
            this.m_data.setFilter(a_filter);
            return this;
        }

        public BDEDataBuilder<T> addControlAttribute(String a_attributeName, String a_attributeValue) {
            this.m_data.addControlAttribute(a_attributeName, a_attributeValue);
            return this;
        }

        public BDEDataBuilder<T> setMaxObjects(int a_maxObjects) {
            this.m_data.setMaxObjects(a_maxObjects);
            return this;
        }

        public BDEDataBuilder<T> setProcessingScope(ProcessingScope a_processingScope) {
            this.m_data.setProcessingScope(a_processingScope);
            return this;
        }

        public BDEDataBuilder<T> setIteratorFetchSize(int a_iteratorFetchSize) {
            this.m_data.setIteratorFetchSize(a_iteratorFetchSize);
            return this;
        }

        public BDEData<T> result() {
            assert (((BDEData)this.m_data).m_bdeName != null);
            return this.m_data;
        }
    }
}

