/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.workbench.server.auth;

import com.infor.ln.workbench.server.auth.Config;
import com.infor.ln.workbench.server.auth.ConfigProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;

public class HttpConfigProvider
implements ConfigProvider {
    private static final Logger LOG = ESAPI.getLogger(HttpConfigProvider.class);
    private final Config m_config = new Config();
    private final String m_openIDConfigURI;

    public HttpConfigProvider(String uri) {
        this.m_openIDConfigURI = uri;
    }

    @Override
    public Config buildConfiguration() throws IOException {
        try (CloseableHttpClient client = HttpClients.createMinimal();){
            this.doGet(client, this.m_openIDConfigURI, new ContentHandler(){

                @Override
                public void handleContent(InputStream openIDConfig) throws IOException {
                    HttpConfigProvider.this.m_config.updateFromOpenIDConfig(openIDConfig);
                    LOG.info(Logger.EVENT_SUCCESS, "Got OpenID config from " + HttpConfigProvider.this.m_openIDConfigURI);
                }
            });
            this.doGet(client, this.m_config.getJwksURI(), new ContentHandler(){

                @Override
                public void handleContent(InputStream jwks) throws IOException {
                    HttpConfigProvider.this.m_config.updateFromJwks(jwks);
                    LOG.info(Logger.EVENT_SUCCESS, "Got JSON Web Key Set from " + HttpConfigProvider.this.m_config.getJwksURI());
                }
            });
        }
        return this.m_config;
    }

    public Boolean doGet(CloseableHttpClient client, String endpoint, final ContentHandler handler) throws IOException {
        HttpGet request = new HttpGet(endpoint);
        request.getRequestLine();
        ResponseHandler<Boolean> responseHandler = new ResponseHandler<Boolean>(){

            public Boolean handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    handler.handleContent(entity.getContent());
                    return true;
                }
                throw new IOException(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            }
        };
        return (Boolean)client.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
    }

    static interface ContentHandler {
        public void handleContent(InputStream var1) throws IOException;
    }
}

