/*
 * Decompiled with CFR 0.152.
 */
package com.infor.component.shared.utils;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.ArrayList;

public class UriUtils {
    private static final String GENERIC_URI_SCHEME = "[a-zA-Z][a-zA-Z0-9+.-]*";
    private static final String GENERIC_URI_SCHEME_SPECIFIC = "[^\\x00-\\x1f <>\"|\\\\\\^\\[\\]`]+";
    private static final String GENERIC_URI_PATTERN = "[a-zA-Z][a-zA-Z0-9+.-]*:[^\\x00-\\x1f <>\"|\\\\\\^\\[\\]`]+";
    public static final String UNC_PATTERN = "\\\\\\\\[^\\\\\\s][\\S]*";
    private static final String EMAIL_ATOM = "[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+";
    private static final String EMAIL_PART = "[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+(?:\\.[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+)*";
    private static final String EMAIL_PATTERN = "[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+(?:\\.[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+)*@[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+(?:\\.[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+)*";
    private static final String WWW_PATTERN = "www\\.[^\\x00-\\x1f <>\"|\\\\\\^\\[\\]`]+";
    private static final RegExp URI_PATTERN = UriUtils.createRegExp("[a-zA-Z][a-zA-Z0-9+.-]*:[^\\x00-\\x1f <>\"|\\\\\\^\\[\\]`]+", "www\\.[^\\x00-\\x1f <>\"|\\\\\\^\\[\\]`]+", "\\\\\\\\[^\\\\\\s][\\S]*", "[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+(?:\\.[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+)*@[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+(?:\\.[^\\x00-\\x1f ()<>@,;:\\\\\".\\[\\]]+)*");
    private static final String[] ALLOWED_SCHEMES = new String[]{"http", "https", "shttp", "ftp", "ftps", "mailto", "imap", "news", "gopher", "telnet", "about"};
    private static final String[] COMMON_URI_SCHEMES = new String[]{"http", "https", "shttp", "ftp", "ftps", "imap", "gopher", "telnet"};

    private UriUtils() {
    }

    private static RegExp createRegExp(String ... patterns) {
        StringBuilder str = new StringBuilder();
        for (String pattern : patterns) {
            str.append("(?:\\s(");
            str.append(pattern);
            str.append(")\\s)|");
        }
        return RegExp.compile((String)str.substring(0, str.length() - 1), (String)"g");
    }

    public static UriMatch[] findUris(String text) {
        MatchResult result;
        ArrayList<UriMatch> matches = new ArrayList<UriMatch>();
        while ((result = URI_PATTERN.exec(" " + text + " ")) != null) {
            assert (result.getGroupCount() == 5);
            int start = result.getIndex() + 1 - 1;
            URI_PATTERN.setLastIndex(URI_PATTERN.getLastIndex() - 1);
            String generic = result.getGroup(1);
            String www = result.getGroup(2);
            String unc = result.getGroup(3);
            String email = result.getGroup(4);
            if (generic != null) {
                boolean valid = false;
                for (String scheme : ALLOWED_SCHEMES) {
                    if (!generic.startsWith(scheme + ":")) continue;
                    valid = true;
                    break;
                }
                for (String scheme : COMMON_URI_SCHEMES) {
                    if (!generic.startsWith(scheme + ":")) continue;
                    valid = generic.startsWith(scheme + "://");
                    break;
                }
                if (!valid) continue;
                matches.add(new UriMatch(start, generic.length(), generic));
                continue;
            }
            if (www != null) {
                matches.add(new UriMatch(start, www.length(), "http://" + www));
                continue;
            }
            if (email == null) continue;
            matches.add(new UriMatch(start, email.length(), "mailto:" + email));
        }
        return matches.toArray(new UriMatch[matches.size()]);
    }

    public static final class UriMatch {
        private final int m_start;
        private final int m_length;
        private final String m_canonicalUri;

        public UriMatch(int start, int length, String canonicalUri) {
            assert (start >= 0);
            assert (length > 0);
            assert (canonicalUri != null);
            this.m_start = start;
            this.m_length = length;
            this.m_canonicalUri = canonicalUri;
        }

        public int getStart() {
            return this.m_start;
        }

        public int getLength() {
            return this.m_length;
        }

        public String toString() {
            return "UriMatch [m_canonicalUri=" + this.m_canonicalUri + "]";
        }

        public String getCanonicalUri() {
            return this.m_canonicalUri;
        }
    }
}

