/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering;

import com.itextpdf.io.font.otf.Glyph;

public abstract class TypographyGlyph
extends Glyph {
    public int category = -1;
    public int position = -1;
    public int mask = 0;
    private boolean substituted;
    private boolean ligated;

    public TypographyGlyph(Glyph glyph) {
        super(glyph);
    }

    public TypographyGlyph(Glyph glyph, int category, int position, int mask) {
        super(glyph);
        this.category = category;
        this.position = position;
        this.mask = mask;
    }

    public TypographyGlyph setSubstituted() {
        this.substituted = true;
        return this;
    }

    public TypographyGlyph setLigated() {
        this.ligated = true;
        return this;
    }

    public boolean substituted() {
        return this.substituted;
    }

    public boolean ligatedAndDidntMultiply() {
        return this.ligated;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.category;
        result = 31 * result + this.position;
        result = 31 * result + this.mask;
        result = 31 * result + (this.substituted ? 1 : 0);
        result = 31 * result + (this.ligated ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        TypographyGlyph other = (TypographyGlyph)((Object)obj);
        return this.category == other.category && this.position == other.position && this.mask == other.mask && this.substituted == other.substituted && this.ligated == other.ligated;
    }
}

