/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ProductStatistics {
    @JsonProperty(value="licenseKey")
    private final String licenseKey;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="statistics")
    private final Map<String, Object> statistics;
    @JsonProperty(value="eventTime")
    private final String eventTime;

    public ProductStatistics(@JsonProperty(value="licenseKey") String licenseKey, @JsonProperty(value="productName") String productName, @JsonProperty(value="statistics") Map<String, Object> statistics, @JsonProperty(value="eventTime") String eventTime) {
        this.licenseKey = licenseKey;
        if (productName == null) {
            throw new IllegalArgumentException("Product name can not be null.");
        }
        this.productName = productName;
        if (statistics == null) {
            throw new IllegalArgumentException("Events can not be null.");
        }
        this.statistics = new LinkedHashMap<String, Object>(statistics);
        if (eventTime == null) {
            throw new IllegalArgumentException("Event time can not be null.");
        }
        this.eventTime = eventTime;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getProductName() {
        return this.productName;
    }

    public Map<String, Object> getStatistics() {
        return Collections.unmodifiableMap(this.statistics);
    }

    public String getEventTime() {
        return this.eventTime;
    }
}

