/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KmsUtil {
    public static final String KMS_PREFIX = "$1AWSKMS$";
    private static KmsUtil s_theInstance;
    private static final Logger LOG;
    private Class<?> m_utilClazz;
    private String m_lastDecrypt;
    private String m_lastEncrypt;

    public static KmsUtil getInstance() {
        if (s_theInstance == null) {
            s_theInstance = new KmsUtil();
        }
        return s_theInstance;
    }

    public String kmsEncrypt(String plaintext) {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("kmsEncrypt", String.class);
                Object retval = method.invoke(null, plaintext);
                if (retval instanceof String) {
                    return KMS_PREFIX + (String)retval;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed call com.infor.eln.fips.Util.kmsEncrypt()", e);
            }
        }
        return "";
    }

    public String kmsDecrypt(String encrytedPassword) {
        if (encrytedPassword.equals(this.m_lastEncrypt)) {
            return this.m_lastDecrypt;
        }
        if (encrytedPassword.startsWith(KMS_PREFIX)) {
            String base64Encrypted = encrytedPassword.substring(KMS_PREFIX.length());
            if (this.m_utilClazz != null) {
                try {
                    Method method = this.m_utilClazz.getMethod("kmsDecrypt", String.class);
                    Object retval = method.invoke(null, base64Encrypted);
                    if (retval instanceof String) {
                        this.m_lastEncrypt = encrytedPassword;
                        this.m_lastDecrypt = (String)retval;
                        return (String)retval;
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed call com.infor.eln.fips.Util.kmsDecrypt()", e);
                }
            }
        }
        return "";
    }

    public void init() {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("init", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed call com.infor.eln.fips.Util.init()", e);
            }
        }
    }

    private KmsUtil() {
        try {
            this.m_utilClazz = Class.forName("com.infor.eln.fips.Util");
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.SEVERE, "Class com.infor.eln.fips.Util not found", e);
        }
    }

    static {
        LOG = Logger.getLogger(KmsUtil.class.getName());
    }
}

