/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import com.ssaglobal.bml.NotoMapper;
import com.ssaglobal.bml.PDFTextWrap;
import java.util.ArrayList;
import java.util.List;

public class FallbackFontProvider
extends FontProvider {
    private PdfFont m_font;
    private FontProvider m_fallback;

    public FallbackFontProvider(PdfFont font, FontProvider fallback) {
        this.m_font = font;
        this.m_fallback = fallback;
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies, FontCharacteristics fc) {
        return new FallbackStrategy(text, this, null, fc.isMonospace(), fc.isBold());
    }

    private class FallbackStrategy
    extends FontSelectorStrategy {
        private String m_remainingText;
        private PdfFont m_currentFont;
        private boolean m_monospace;
        private boolean m_bold;

        public FallbackStrategy(String text, FontProvider provider, FontSet tempFonts, boolean monospace, boolean bold) {
            super(text, provider, tempFonts);
            this.m_remainingText = text;
            this.m_monospace = monospace;
            this.m_bold = bold;
        }

        public PdfFont getCurrentFont() {
            return this.m_currentFont;
        }

        private boolean containsGlyph(char c) {
            boolean containsGlyph = false;
            try {
                containsGlyph = FallbackFontProvider.this.m_font.containsGlyph((int)c);
            }
            catch (Exception e) {
                containsGlyph = false;
            }
            return containsGlyph;
        }

        public List<Glyph> nextGlyphs() {
            FontSelectorStrategy fallback;
            FontCharacteristics fc;
            ArrayList<Object> glyphs = new ArrayList<Glyph>();
            if (this.m_remainingText.length() == 0) {
                return glyphs;
            }
            int count = 1;
            char c = this.m_remainingText.charAt(0);
            boolean fallbackActive = !this.containsGlyph(c);
            this.m_remainingText = this.m_remainingText.substring(1);
            PdfFont fallbackCurrentFont = null;
            if (fallbackActive) {
                fc = new FontCharacteristics();
                fc.setBoldFlag(this.m_bold);
                fc.setMonospaceFlag(this.m_monospace);
                fallback = FallbackFontProvider.this.m_fallback.getStrategy("" + c, PDFTextWrap.EMPTY_LIST, fc);
                fallback.nextGlyphs();
                fallbackCurrentFont = fallback.getCurrentFont();
            }
            while (this.m_remainingText.length() > 0) {
                c = this.m_remainingText.charAt(0);
                if (!fallbackActive && this.containsGlyph(c)) {
                    this.m_remainingText = this.m_remainingText.substring(1);
                    ++count;
                    continue;
                }
                if (fallbackActive && this.containsGlyph(c) || !fallbackActive) break;
                fc = new FontCharacteristics();
                fc.setBoldFlag(this.m_bold);
                fc.setMonospaceFlag(this.m_monospace);
                fallback = FallbackFontProvider.this.m_fallback.getStrategy("" + c, PDFTextWrap.EMPTY_LIST, fc);
                fallback.nextGlyphs();
                PdfFont font = fallback.getCurrentFont();
                if (fallbackCurrentFont == null) {
                    this.m_remainingText = this.m_remainingText.substring(1);
                    ++count;
                    fallbackCurrentFont = font;
                    continue;
                }
                if (fallbackCurrentFont != font) break;
                this.m_remainingText = this.m_remainingText.substring(1);
                ++count;
                fallbackCurrentFont = font;
            }
            this.m_currentFont = fallbackActive ? fallbackCurrentFont : FallbackFontProvider.this.m_font;
            glyphs = new ArrayList();
            for (int i = 0; i < count; ++i) {
                glyphs.add(NotoMapper.DUMMY);
            }
            return glyphs;
        }
    }
}

