/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BMLConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BML2TXT
extends BMLConverter {
    private Hashtable m_rowLayouts;
    private RowLayout m_currentRow;
    private Vector m_fieldsWithHeightHigherThanOne = null;

    @Override
    public boolean getReencodeCharacters() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.m_rowLayouts = new Hashtable();
        this.m_currentRow = null;
        this.m_fieldsWithHeightHigherThanOne = new Vector();
    }

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        try {
            super.startElement(not_used_1, not_used_2, name, attributes);
            if (!name.equals("report")) {
                if (name.equals("row")) {
                    String currentRowId = attributes.getValue("layout");
                    this.m_currentRow = (RowLayout)this.m_rowLayouts.get(currentRowId);
                    if (this.m_currentRow == null) {
                        System.err.println("There is no lline with this ID: " + currentRowId + ". Row will not be printed.");
                    }
                } else if (name.equals("e")) {
                    this.startCharacters();
                } else if (name.equals("pagebreak")) {
                    this.write("\r\n");
                } else if (name.equals("emptyline")) {
                    this.write("\r\n");
                } else if (name.equals("lline")) {
                    String currentRowId = attributes.getValue("id");
                    this.m_currentRow = new RowLayout();
                    this.m_rowLayouts.put(currentRowId, this.m_currentRow);
                    for (int i = 0; i < this.m_fieldsWithHeightHigherThanOne.size(); ++i) {
                        Object[] field = (Object[])this.m_fieldsWithHeightHigherThanOne.elementAt(i);
                        CellLayout cell = (CellLayout)field[0];
                        int[] height = (int[])field[1];
                        this.m_currentRow.addCell(cell);
                        height[0] = height[0] - 1;
                        if (height[0] > 0) continue;
                        this.m_fieldsWithHeightHigherThanOne.remove(i);
                        --i;
                    }
                } else if (name.equals("special") || name.equals("field")) {
                    int height;
                    CellLayout cell = new CellLayout(attributes.getValue("col"), attributes.getValue("width"), attributes.getValue("align"), attributes.getValue("bold"));
                    this.m_currentRow.addCell(cell);
                    int n = height = attributes.getValue("height") == null ? 0 : Integer.parseInt(attributes.getValue("height"));
                    if (height > 1) {
                        this.m_fieldsWithHeightHigherThanOne.addElement(new Object[]{cell.copy(), new int[]{height - 1}});
                    }
                } else if (name.equals("text")) {
                    this.addCells(Integer.parseInt(attributes.getValue("col")), attributes.getValue("content"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addCells(int a_col, String a_text) {
        int borderType = -1;
        int col = a_col;
        String text = "";
        for (int i = 0; i < a_text.length(); ++i) {
            char c = a_text.charAt(i);
            int width = text.length();
            if (c == '\u2500') {
                text = text + c;
                borderType = 1;
                continue;
            }
            if (c == '\u2502') {
                if (width > 0) {
                    this.addCell(col, text, borderType);
                    col += width;
                    text = "";
                }
                text = text + c;
                borderType = 2;
                continue;
            }
            if (c >= '\u2500' && c <= '\u256c') {
                if (width > 0) {
                    this.addCell(col, text, 1);
                }
                borderType = c == '\u2502' || c == '\u2503' || c == '\u2506' || c == '\u2507' || c == '\u250a' || c == '\u250b' ? 2 : (c <= '\u250b' ? 1 : (c <= '\u250f' ? 3 : (c <= '\u2513' ? 4 : (c <= '\u2517' ? 5 : (c <= '\u251b' ? 6 : (c <= '\u2523' ? 7 : (c <= '\u252b' ? 8 : (c <= '\u2533' ? 9 : (c <= '\u253b' ? 10 : 11)))))))));
                this.addCell(col + width, "" + c, borderType);
                col = col + width + 1;
                text = "";
                continue;
            }
            text = text + c;
        }
        if (text.length() > 0) {
            this.addCell(col, text, borderType);
        }
    }

    private CellLayout addCell(int a_col, String a_text, int a_borderType) {
        CellLayout cell = new CellLayout(a_col, a_text);
        this.m_currentRow.addCell(cell);
        cell.m_borderType = a_borderType;
        return cell;
    }

    @Override
    public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
        try {
            super.endElement(not_used_1, not_used_2, name);
            if (!name.equals("report")) {
                if (name.equals("e")) {
                    if (this.m_currentRow != null && this.isCharactersStarted()) {
                        this.m_currentRow.addE(this.getCharacters());
                        this.stopCharacters();
                    }
                } else if (name.equals("row")) {
                    if (this.m_currentRow != null) {
                        this.m_currentRow.writeAscii();
                        this.m_currentRow.clearEs();
                        this.write("\r\n");
                    }
                } else if (name.equals("lline") && this.m_currentRow != null) {
                    this.m_currentRow.sort();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String convertBML(String a_bmlFile, String a_file) {
        try {
            BML2TXT b2t = new BML2TXT();
            b2t.convert(a_bmlFile, a_file);
            return b2t.getReportId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class CellLayout
    implements Comparable,
    Cloneable {
        public static final int LEFT = 0;
        public static final int CENTERED = 1;
        public static final int RIGHT = 2;
        public int m_col;
        public int m_width;
        public int m_align;
        public boolean m_bold;
        public String m_text;
        public int m_borderType = -1;

        public CellLayout(int col, int width, int align, boolean bold) {
            this.m_col = col;
            this.m_width = width;
            this.m_align = align;
            this.m_bold = bold;
        }

        public CellLayout(int col, String text) {
            this.m_col = col;
            this.m_width = text.length();
            this.m_text = text;
            this.m_bold = false;
            this.m_align = 0;
            if (text.trim().equals("")) {
                this.m_text = "";
            }
        }

        public CellLayout(String col, String width, String align, String bold) {
            this.m_col = Integer.parseInt(col);
            this.m_width = Integer.parseInt(width);
            this.m_align = "Right".equals(align) ? 2 : ("Centered".equals(align) ? 1 : 0);
            this.m_bold = "Yes".equals(bold);
        }

        public CellLayout(String col, String text) {
            this(Integer.parseInt(col), text);
        }

        public int compareTo(Object cell) {
            return this.m_col - ((CellLayout)cell).m_col;
        }

        public CellLayout copy() throws CloneNotSupportedException {
            return (CellLayout)this.clone();
        }
    }

    class RowLayout {
        private Vector m_cellLayouts = new Vector();
        private Vector m_es = new Vector();

        public void addCell(CellLayout a_cell) {
            this.m_cellLayouts.addElement(a_cell);
        }

        public void sort() {
            Collections.sort(this.m_cellLayouts);
            for (int i = 1; i < this.m_cellLayouts.size(); ++i) {
                CellLayout prevCell = (CellLayout)this.m_cellLayouts.elementAt(i - 1);
                int currentCol = prevCell.m_col;
                CellLayout cell = (CellLayout)this.m_cellLayouts.elementAt(i);
                if (prevCell.m_width == 1 && prevCell.m_borderType != -1) continue;
                prevCell.m_width = cell.m_col - currentCol;
            }
        }

        public void addE(String a_e) {
            this.m_es.addElement(a_e);
        }

        public void clearEs() {
            this.m_es.clear();
        }

        private void writeSpaces(int n) throws IOException {
            for (int i = 0; i < n; ++i) {
                BML2TXT.this.write(" ");
            }
        }

        public void writeAscii() throws IOException {
            int currentCol = 1;
            int j = 0;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                String text = null;
                CellLayout cell = (CellLayout)this.m_cellLayouts.elementAt(i);
                if (cell.m_text == null) {
                    text = (String)this.m_es.elementAt(j);
                    ++j;
                } else {
                    text = cell.m_text;
                }
                if (text == null) {
                    text = "";
                }
                while (currentCol < cell.m_col) {
                    BML2TXT.this.write(" ");
                    ++currentCol;
                }
                if (cell.m_align == 0) {
                    BML2TXT.this.write(text);
                    this.writeSpaces(cell.m_width - text.length());
                } else if (cell.m_align == 2) {
                    this.writeSpaces(cell.m_width - text.length());
                    BML2TXT.this.write(text);
                } else if (cell.m_align == 1) {
                    int half = 0 * (cell.m_width - text.length());
                    this.writeSpaces(half);
                    BML2TXT.this.write(text);
                    this.writeSpaces(cell.m_width - text.length() - half);
                } else {
                    BML2TXT.this.write(text);
                    this.writeSpaces(cell.m_width - text.length());
                }
                currentCol += cell.m_width;
            }
        }
    }
}

