/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rdatamatrix;

import com.java4less.rbarcode.BarCode;
import com.java4less.rdatamatrix.reed;
import java.awt.Color;
import java.awt.Graphics;

public class RDataMatrix
extends BarCode {
    protected static final int d1 = 1;
    public int dotPixels = 8;
    public int margin = 30;
    public boolean processTilde = false;
    public boolean reBuild = false;
    private String internalCode = "";
    public byte[] codeBinary = null;
    private int[][] bitmap;
    private static final int ROW = 0;
    private static final int COL = 1;
    private static final int ROWDATA = 2;
    private static final int COLDATA = 3;
    private static final int REGIONS = 4;
    private static final int ROWMAP = 5;
    private static final int COLMAP = 6;
    private static final int TOTALDATA = 7;
    private static final int TOTALERR = 8;
    private static final int REEDDATA = 9;
    private static final int REEDERR = 10;
    private static final int REEDBLOCKS = 11;
    public static final int C10X10 = 0;
    public static final int C12X12 = 1;
    public static final int C14X14 = 2;
    public static final int C16X16 = 3;
    public static final int C18X18 = 4;
    public static final int C20X20 = 5;
    public static final int C22X22 = 6;
    public static final int C24X24 = 7;
    public static final int C26X26 = 8;
    public static final int C32X32 = 9;
    public static final int C36X36 = 10;
    public static final int C40X40 = 11;
    public static final int C44X44 = 12;
    public static final int C48X48 = 13;
    public static final int C52X52 = 14;
    public static final int C64X64 = 15;
    public static final int C72X72 = 16;
    public static final int C80X80 = 17;
    public static final int C88X88 = 18;
    public static final int C96X96 = 19;
    public static final int C104X104 = 20;
    public static final int C120X120 = 21;
    public static final int C132X132 = 22;
    public static final int C144X144 = 23;
    public static final int C8X18 = 24;
    public static final int C8X32 = 25;
    public static final int C12X26 = 26;
    public static final int C12X36 = 27;
    public static final int C16X36 = 28;
    public static final int C16X48 = 29;
    private static final int C40_PAD = 0;
    private static final int PAD = 129;
    private static final int LATCH_C40 = 230;
    private static final int LATCH_BASE256 = 231;
    private static final int FNC1 = 232;
    private static final int STRUCTURED_APPEND = 233;
    private static final int READER_PROGRAMMING = 234;
    private static final int SHIFT = 235;
    private static final int MACRO5 = 236;
    private static final int MACRO6 = 237;
    private static final int LATCH_TEXT = 239;
    private static final int ECI = 241;
    private static final int UNLATCH = 254;
    private static final int DATA_254 = 10254;
    private int currentEncoding = E_ASCII;
    private static int[][] configuration = new int[][]{{10, 10, 8, 8, 1, 8, 8, 3, 5, 3, 5, 1}, {12, 12, 10, 10, 1, 10, 10, 5, 7, 5, 7, 1}, {14, 14, 12, 12, 1, 12, 12, 8, 10, 8, 10, 1}, {16, 16, 14, 14, 1, 14, 14, 12, 12, 12, 12, 1}, {18, 18, 16, 16, 1, 16, 16, 18, 14, 18, 14, 1}, {20, 20, 18, 18, 1, 18, 18, 22, 18, 22, 18, 1}, {22, 22, 20, 20, 1, 20, 20, 30, 20, 30, 20, 1}, {24, 24, 22, 22, 1, 22, 22, 36, 24, 36, 24, 1}, {26, 26, 24, 24, 1, 24, 24, 44, 28, 44, 28, 1}, {32, 32, 14, 14, 4, 28, 28, 62, 36, 62, 36, 1}, {36, 36, 16, 16, 4, 32, 32, 86, 42, 86, 42, 1}, {40, 40, 18, 18, 4, 36, 36, 114, 48, 114, 48, 1}, {44, 44, 20, 20, 4, 40, 40, 144, 56, 144, 56, 1}, {48, 48, 22, 22, 4, 44, 44, 174, 68, 174, 68, 1}, {52, 52, 24, 24, 4, 48, 48, 204, 84, 102, 42, 2}, {64, 64, 14, 14, 16, 56, 56, 280, 112, 140, 56, 2}, {72, 72, 16, 16, 16, 64, 64, 368, 144, 92, 36, 4}, {80, 80, 18, 18, 16, 72, 72, 456, 192, 114, 48, 4}, {88, 88, 20, 20, 16, 80, 80, 576, 224, 144, 56, 4}, {96, 96, 22, 22, 16, 88, 88, 696, 272, 174, 68, 4}, {104, 104, 24, 24, 16, 96, 96, 816, 336, 136, 56, 6}, {120, 120, 18, 18, 36, 108, 108, 1050, 496, 175, 68, 6}, {132, 132, 20, 20, 36, 120, 120, 1304, 496, 163, 62, 8}, {144, 144, 22, 22, 36, 132, 132, 1558, 620, 156, 62, 10}, {8, 18, 6, 16, 1, 6, 16, 5, 7, 5, 7, 1}, {8, 32, 6, 14, 2, 6, 28, 10, 11, 10, 11, 1}, {12, 26, 10, 24, 1, 10, 24, 16, 14, 16, 14, 1}, {12, 36, 10, 16, 2, 10, 32, 22, 18, 22, 18, 1}, {16, 36, 14, 16, 2, 14, 32, 32, 24, 32, 24, 1}, {16, 48, 14, 22, 2, 14, 44, 49, 28, 49, 28, 1}};
    private int rows;
    private int cols;
    private int datarows;
    private int datacols;
    private int maprows;
    private int mapcols;
    private int regions;
    private int totaldata;
    private int totalerr;
    private int reeddata;
    private int reederr;
    private int reedblocks;
    private int C49rest = 0;
    private int calculatedFormat = 0;
    public int encoding = E_ASCII;
    public static int E_ASCII = 0;
    public static int E_C40 = 1;
    public static int E_TEXT = 2;
    public static int E_BASE256 = 3;
    public static int E_NONE = 4;
    public static int E_AUTO = 5;
    public int preferredFormat = -1;
    private static int[][] C40Codes = new int[][]{{0, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {0, 6}, {0, 7}, {0, 8}, {0, 9}, {0, 10}, {0, 11}, {0, 12}, {0, 13}, {0, 14}, {0, 15}, {0, 16}, {0, 17}, {0, 18}, {0, 19}, {0, 20}, {0, 21}, {0, 22}, {0, 23}, {0, 24}, {0, 25}, {0, 26}, {0, 27}, {0, 28}, {0, 29}, {0, 30}, {0, 31}, {3}, {1, 0}, {1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {1, 15}, {1, 16}, {1, 17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {14}, {15}, {16}, {17}, {18}, {19}, {20}, {21}, {22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {31}, {32}, {33}, {34}, {35}, {36}, {37}, {38}, {39}, {1, 22}, {1, 23}, {1, 24}, {1, 25}, {1, 26}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2, 21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {2, 29}, {2, 30}, {2, 31}, {1, 30, 0, 0}, {1, 30, 0, 1}, {1, 30, 0, 2}, {1, 30, 0, 3}, {1, 30, 0, 4}, {1, 30, 0, 5}, {1, 30, 0, 6}, {1, 30, 0, 7}, {1, 30, 0, 8}, {1, 30, 0, 9}, {1, 30, 0, 10}, {1, 30, 0, 11}, {1, 30, 0, 12}, {1, 30, 0, 13}, {1, 30, 0, 14}, {1, 30, 0, 15}, {1, 30, 0, 16}, {1, 30, 0, 17}, {1, 30, 0, 18}, {1, 30, 0, 19}, {1, 30, 0, 20}, {1, 30, 0, 21}, {1, 30, 0, 22}, {1, 30, 0, 23}, {1, 30, 0, 24}, {1, 30, 0, 25}, {1, 30, 0, 26}, {1, 30, 0, 27}, {1, 30, 0, 28}, {1, 30, 0, 29}, {1, 30, 0, 30}, {1, 30, 0, 31}, {1, 30, 3}, {1, 30, 1, 0}, {1, 30, 1, 1}, {1, 30, 1, 2}, {1, 30, 1, 3}, {1, 30, 1, 4}, {1, 30, 1, 5}, {1, 30, 1, 6}, {1, 30, 1, 7}, {1, 30, 1, 8}, {1, 30, 1, 9}, {1, 30, 1, 10}, {1, 30, 1, 11}, {1, 30, 1, 12}, {1, 30, 1, 13}, {1, 30, 1, 14}, {1, 30, 4}, {1, 30, 5}, {1, 30, 6}, {1, 30, 7}, {1, 30, 8}, {1, 30, 9}, {1, 30, 10}, {1, 30, 11}, {1, 30, 12}, {1, 30, 13}, {1, 30, 1, 15}, {1, 30, 1, 16}, {1, 30, 1, 17}, {1, 30, 1, 18}, {1, 30, 1, 19}, {1, 30, 1, 20}, {1, 30, 1, 21}, {1, 30, 14}, {1, 30, 15}, {1, 30, 16}, {1, 30, 17}, {1, 30, 18}, {1, 30, 19}, {1, 30, 20}, {1, 30, 21}, {1, 30, 22}, {1, 30, 23}, {1, 30, 24}, {1, 30, 25}, {1, 30, 26}, {1, 30, 27}, {1, 30, 28}, {1, 30, 29}, {1, 30, 30}, {1, 30, 31}, {1, 30, 32}, {1, 30, 33}, {1, 30, 34}, {1, 30, 35}, {1, 30, 36}, {1, 30, 37}, {1, 30, 38}, {1, 30, 39}, {1, 30, 1, 22}, {1, 30, 1, 23}, {1, 30, 1, 24}, {1, 30, 1, 25}, {1, 30, 1, 26}, {1, 30, 2, 0}, {1, 30, 2, 1}, {1, 30, 2, 2}, {1, 30, 2, 3}, {1, 30, 2, 4}, {1, 30, 2, 5}, {1, 30, 2, 6}, {1, 30, 2, 7}, {1, 30, 2, 8}, {1, 30, 2, 9}, {1, 30, 2, 10}, {1, 30, 2, 11}, {1, 30, 2, 12}, {1, 30, 2, 13}, {1, 30, 2, 14}, {1, 30, 2, 15}, {1, 30, 2, 16}, {1, 30, 2, 17}, {1, 30, 2, 18}, {1, 30, 2, 19}, {1, 30, 2, 20}, {1, 30, 2, 21}, {1, 30, 2, 22}, {1, 30, 2, 23}, {1, 30, 2, 24}, {1, 30, 2, 25}, {1, 30, 2, 26}, {1, 30, 2, 27}, {1, 30, 2, 28}, {1, 30, 2, 29}, {1, 30, 2, 30}, {1, 30, 2, 31}};

    private int random255(int code, int position) {
        int tmp;
        int random = 149 * position % 255;
        if ((tmp = code + ++random) <= 255) {
            return tmp;
        }
        return tmp - 256;
    }

    public int getCalculatedFormat() {
        return this.calculatedFormat;
    }

    private boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private void copyArray(int[] src, int[] dest, int initSrc, int initDest, int longi) {
        for (int i = 0; i < longi; ++i) {
            dest[initDest + i] = src[initSrc + i];
        }
    }

    public int getPaintedWidth() {
        return this.currentX;
    }

    public int getPaintedHeight() {
        return this.currentY;
    }

    private int lookAheadTest(int[] Data, int currentEnc, int pos, String[] specialSymbols) {
        double asciiCount = 0.0;
        double c40Count = 1.0;
        double textCount = 1.0;
        double b256Count = 1.25;
        int initialPos = pos;
        if (currentEnc != E_ASCII) {
            asciiCount = 1.0;
            c40Count = 2.0;
            textCount = 2.0;
            b256Count = 2.25;
        }
        if (currentEnc == E_C40) {
            c40Count = 0.0;
        }
        if (currentEnc == E_TEXT) {
            textCount = 0.0;
        }
        if (currentEnc == E_BASE256) {
            b256Count = 0.0;
        }
        while (pos < Data.length) {
            char c = (char)Data[pos];
            asciiCount = this.isDigit(c) ? (asciiCount += 0.5) : (c > '\u007f' ? (double)(Math.round(asciiCount) + 2L) : (double)(Math.round(asciiCount) + 1L));
            c40Count = C40Codes[c].length == 1 ? (c40Count += 0.66) : (c > '\u007f' ? (c40Count += 2.66) : (c40Count += 1.33));
            char cText = c;
            String tmp = "" + c;
            if (c >= 'A' && c <= 'Z') {
                cText = tmp.toLowerCase().charAt(0);
            }
            if (c >= 'a' && c <= 'z') {
                cText = tmp.toUpperCase().charAt(0);
            }
            textCount = C40Codes[cText].length == 1 ? (textCount += 0.66) : (cText > '\u007f' ? (textCount += 2.66) : (textCount += 1.33));
            b256Count += 1.0;
            if (specialSymbols[pos] != null) {
                return E_ASCII;
            }
            if (pos - initialPos >= 4) {
                if (asciiCount + 1.0 <= c40Count && asciiCount + 1.0 <= textCount && asciiCount + 1.0 <= b256Count) {
                    return E_ASCII;
                }
                if (b256Count + 1.0 <= asciiCount) {
                    return E_BASE256;
                }
                if (b256Count + 1.0 < textCount && b256Count + 1.0 < c40Count) {
                    return E_BASE256;
                }
                if (textCount + 1.0 < asciiCount && textCount + 1.0 < c40Count && textCount + 1.0 < b256Count) {
                    return E_TEXT;
                }
                if (c40Count + 1.0 < asciiCount && c40Count + 1.0 < textCount && c40Count + 1.0 < b256Count) {
                    return E_C40;
                }
            }
            ++pos;
        }
        asciiCount = Math.round(asciiCount);
        c40Count = Math.round(c40Count);
        textCount = Math.round(textCount);
        b256Count = Math.round(b256Count);
        if (asciiCount <= c40Count && asciiCount <= textCount && asciiCount <= b256Count) {
            return E_ASCII;
        }
        if (textCount < asciiCount && textCount < c40Count && textCount < b256Count) {
            return E_TEXT;
        }
        if (b256Count < asciiCount && b256Count < textCount && b256Count < c40Count) {
            return E_BASE256;
        }
        return E_C40;
    }

    private int encodeAuto(int longi, int[] in, int[] out, String[] specialSymbols) {
        int[] tmp = new int[6000];
        int[] tmpResult = new int[6000];
        int tmpResultLen = 0;
        int posResult = 0;
        int proposedEncoding = E_ASCII;
        int[] Initial = new int[1];
        int[] InitialOut = new int[1];
        int previousEncoding = E_ASCII;
        String[] specialSymbolsTMP = new String[10];
        for (int i = 0; i < specialSymbolsTMP.length; ++i) {
            specialSymbolsTMP[i] = null;
        }
        int pos = 0;
        this.currentEncoding = E_ASCII;
        while (pos < longi) {
            while (this.currentEncoding == E_ASCII && pos < longi) {
                boolean done = false;
                if (pos + 1 < longi && this.isDigit(in[pos]) && this.isDigit(in[pos + 1])) {
                    if (previousEncoding != E_ASCII && previousEncoding != E_BASE256) {
                        int n = posResult++;
                        out[n] = 254;
                    }
                    tmp[0] = in[pos];
                    tmp[1] = in[pos + 1];
                    tmpResultLen = this.encodeAscii(2, tmp, tmpResult, specialSymbolsTMP);
                    this.copyArray(tmpResult, out, 0, posResult, tmpResultLen);
                    posResult += tmpResultLen;
                    ++pos;
                    ++pos;
                    done = true;
                    previousEncoding = E_ASCII;
                }
                if (!done && (proposedEncoding = this.lookAheadTest(in, this.currentEncoding, pos, specialSymbols)) != E_ASCII) {
                    previousEncoding = this.currentEncoding;
                    this.currentEncoding = proposedEncoding;
                }
                if (done || this.currentEncoding != E_ASCII) continue;
                if (previousEncoding != E_ASCII && previousEncoding != E_BASE256) {
                    out[posResult++] = 254;
                }
                tmp[0] = in[pos];
                specialSymbolsTMP[0] = specialSymbols[pos];
                tmpResultLen = this.encodeAscii(1, tmp, tmpResult, specialSymbolsTMP);
                specialSymbolsTMP[0] = null;
                this.copyArray(tmpResult, out, 0, posResult, tmpResultLen);
                posResult += tmpResultLen;
                ++pos;
                previousEncoding = E_ASCII;
            }
            while (this.currentEncoding == E_C40 && pos < longi) {
                if (previousEncoding != E_ASCII && previousEncoding != E_C40 && previousEncoding != E_BASE256) {
                    int n = posResult++;
                    out[n] = 254;
                }
                Initial[0] = pos;
                tmpResultLen = this.encodeC40(longi, Initial, in, tmpResult, false, previousEncoding != E_C40, true, null);
                pos = Initial[0];
                this.copyArray(tmpResult, out, 0, posResult, tmpResultLen);
                posResult += tmpResultLen;
                proposedEncoding = this.lookAheadTest(in, this.currentEncoding, pos, specialSymbols);
                previousEncoding = this.currentEncoding;
                this.currentEncoding = proposedEncoding;
            }
            while (this.currentEncoding == E_TEXT && pos < longi) {
                if (previousEncoding != E_ASCII && previousEncoding != E_TEXT && previousEncoding != E_BASE256) {
                    int n = posResult++;
                    out[n] = 254;
                }
                Initial[0] = pos;
                tmpResultLen = this.encodeC40(longi, Initial, in, tmpResult, true, previousEncoding != E_TEXT, true, null);
                pos = Initial[0];
                this.copyArray(tmpResult, out, 0, posResult, tmpResultLen);
                posResult += tmpResultLen;
                proposedEncoding = this.lookAheadTest(in, this.currentEncoding, pos, specialSymbols);
                previousEncoding = this.currentEncoding;
                this.currentEncoding = proposedEncoding;
            }
            if (this.currentEncoding != E_BASE256) continue;
            if (previousEncoding != E_ASCII && previousEncoding != E_BASE256) {
                int n = posResult++;
                out[n] = 254;
            }
            Initial[0] = pos;
            InitialOut[0] = posResult;
            this.encodeBase256(longi, Initial, in, InitialOut, out, true, specialSymbols);
            pos = Initial[0];
            posResult = InitialOut[0];
            proposedEncoding = this.lookAheadTest(in, this.currentEncoding, pos, specialSymbols);
            previousEncoding = this.currentEncoding;
            this.currentEncoding = proposedEncoding;
        }
        return posResult;
    }

    private int encodeBase256(int longi, int[] initial, int[] in, int[] outInit, int[] out, boolean makeLookAhead, String[] specialSymbols) {
        int count = 0;
        int[] tmp = new int[6000];
        int tmpInit = outInit[0];
        int tmpInitCount = outInit[0];
        int pos = 0;
        int k = 0;
        for (k = initial[0]; k < longi; ++k) {
            tmp[count] = in[k];
            ++count;
            pos = k + 1;
            if (pos == 24) {
                boolean ii = false;
            }
            if (makeLookAhead && this.lookAheadTest(in, E_BASE256, pos, specialSymbols) != E_BASE256) break;
        }
        initial[0] = ++k;
        out[tmpInitCount++] = 231;
        if (count < 250) {
            out[tmpInitCount] = this.random255(count, tmpInitCount + 1);
            ++tmpInitCount;
        } else {
            out[tmpInitCount] = this.random255(249 + (count - count % 250) / 250, tmpInitCount + 1);
            out[++tmpInitCount] = this.random255(count % 250, tmpInitCount + 1);
            ++tmpInitCount;
        }
        for (k = 0; k < count; ++k) {
            out[tmpInitCount] = this.random255(tmp[k], tmpInitCount + 1);
            ++tmpInitCount;
        }
        outInit[0] = tmpInitCount;
        return tmpInitCount;
    }

    private int encodeC40(int longi, int[] initial, int[] in, int[] out, boolean doTextEncoding, boolean inititaLatch, boolean onlyOneWord, String[] specialSymbols) {
        int h;
        int count = 0;
        int countMod3 = 0;
        int[] tmp = new int[]{0, 0, 0};
        int charac = 0;
        String[] specialSymbolsTMP = new String[10];
        for (int i = 0; i < specialSymbolsTMP.length; ++i) {
            specialSymbolsTMP[i] = null;
        }
        if (inititaLatch) {
            out[count++] = doTextEncoding ? 239 : 230;
        }
        for (int k = initial[0]; k < longi; ++k) {
            charac = in[k];
            if (doTextEncoding) {
                String tmpS = "" + (char)charac;
                if (charac >= 97 && charac <= 122) {
                    tmpS = tmpS.toUpperCase();
                }
                if (charac >= 65 && charac <= 90) {
                    tmpS = tmpS.toLowerCase();
                }
                charac = tmpS.charAt(0);
            }
            int[] codes = null;
            if (specialSymbols != null && specialSymbols[k] != null) {
                if (charac == 232) {
                    codes = new int[]{1, 27};
                }
            }
            if (codes == null) {
                codes = C40Codes[charac];
            }
            for (h = 0; h < codes.length; ++h) {
                tmp[countMod3++] = codes[h];
                if (countMod3 != 3) continue;
                int t = tmp[0] * 1600 + tmp[1] * 40 + tmp[2] + 1;
                out[count++] = t / 256;
                if (out[count - 1] == 254) {
                    out[count - 1] = 10254;
                }
                out[count++] = t % 256;
                if (out[count - 1] == 254) {
                    out[count - 1] = 10254;
                }
                countMod3 = 0;
            }
            if (!onlyOneWord || countMod3 != 0) continue;
            this.C49rest = countMod3;
            initial[0] = k + 1;
            if (initial[0] == longi) {
                out[count++] = 254;
            }
            return count;
        }
        initial[0] = longi;
        if (countMod3 > 0) {
            if (countMod3 == 2) {
                int t = tmp[0] * 1600 + tmp[1] * 40 + 0 + 1;
                out[count++] = t / 256;
                if (out[count - 1] == 254) {
                    out[count - 1] = 10254;
                }
                out[count++] = t % 256;
                if (out[count - 1] == 254) {
                    out[count - 1] = 10254;
                }
                out[count++] = 254;
            }
            if (countMod3 == 1) {
                out[count++] = 254;
                int[] encodedASCII = new int[2];
                int[] toencode = new int[countMod3];
                for (h = 0; h < countMod3; ++h) {
                    toencode[h] = in[longi - (countMod3 - h)];
                }
                int asciiLen = this.encodeAscii(countMod3, toencode, encodedASCII, specialSymbolsTMP);
                for (int h2 = 0; h2 < asciiLen; ++h2) {
                    out[count++] = encodedASCII[h2];
                }
            }
        } else {
            out[count++] = 254;
        }
        this.C49rest = countMod3;
        return count;
    }

    protected void paintBasis(Graphics g) {
        if (!true) {
            return;
        }
        this.topMarginPixels = this.margin;
        this.leftMarginPixels = this.margin;
        if (this.code.length() == 0 && this.codeBinary == null) {
            return;
        }
        g.setColor(this.backColor);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.fillRect(0, 0, w, h);
        if (this.bitmap == null || this.reBuild) {
            this.doCode();
        }
        if (this.bitmap == null) {
            return;
        }
        int x = this.margin;
        int y = this.margin;
        for (int j1 = 0; j1 < this.rows; ++j1) {
            for (int i1 = 0; i1 < this.cols; ++i1) {
                if (this.bitmap[i1][j1] != 0) {
                    this.paintDot(g, x + this.dotPixels * i1, y + this.dotPixels * j1, this.dotPixels, this.barColor);
                    continue;
                }
                this.paintDot(g, x + this.dotPixels * i1, y + this.dotPixels * j1, this.dotPixels, this.backColor);
            }
        }
        this.currentX = this.dotPixels * this.cols + this.margin;
        this.currentY = this.dotPixels * this.rows + this.margin;
    }

    private void paintDot(Graphics g, int x, int y, int w, Color c) {
        g.setColor(c);
        g.fillRect(x, y, w, w);
    }

    private int random253(int code, int position) {
        int tmp;
        int random = 149 * position % 253;
        if ((tmp = code + ++random) <= 254) {
            return tmp;
        }
        return tmp - 254;
    }

    private String applyTilde(String code, String[] specialSymbol) {
        char c = '\u0000';
        int longi = code.length();
        String result = "";
        boolean done = false;
        for (int i = 0; i < longi; ++i) {
            c = code.charAt(i);
            if (c == '~') {
                if (i >= longi - 1) continue;
                char nextc = code.charAt(i + 1);
                if (nextc >= '@' && nextc <= 'Z') {
                    ++i;
                    result = result + (char)(nextc - 64);
                }
                if (nextc == '~') {
                    result = result + '~';
                    ++i;
                }
                if (nextc == '1') {
                    if (result.length() == 0 || result.length() == 1 || result.length() == 4 || result.length() == 5) {
                        specialSymbol[result.length()] = "";
                        result = result + '\u00e8';
                    } else {
                        result = result + '\u001d';
                    }
                    ++i;
                }
                if (nextc == '2' && i < longi - 4) {
                    specialSymbol[result.length()] = "" + code.charAt(i + 2) + code.charAt(i + 3) + code.charAt(i + 4);
                    result = result + '\u00e9';
                    i += 4;
                }
                if (nextc == '3' && result.length() == 0) {
                    specialSymbol[result.length()] = "";
                    result = result + '\u00ea';
                    ++i;
                }
                if (nextc == '5' && result.length() == 0) {
                    specialSymbol[result.length()] = "";
                    result = result + '\u00ec';
                    ++i;
                }
                if (nextc == '6' && result.length() == 0) {
                    specialSymbol[result.length()] = "";
                    result = result + '\u00ed';
                    ++i;
                }
                if (nextc == '7' && i < longi - 7) {
                    int c2;
                    String eciString = code.substring(i + 2, i + 8);
                    double eci = 0.0;
                    try {
                        eci = new Double(eciString);
                    }
                    catch (Exception e) {
                        eci = 0.0;
                    }
                    if (eci <= 126.0) {
                        specialSymbol[result.length()] = "" + (char)(eci + 1.0);
                        result = result + '\u00f1';
                    }
                    if (eci >= 127.0 && eci <= 16382.0) {
                        int c1 = (int)((eci - 127.0) / 254.0) + 128;
                        c2 = (int)((eci - 127.0) % 254.0) + 1;
                        specialSymbol[result.length()] = "" + (char)c1 + (char)c2;
                        result = result + '\u00f1';
                    }
                    if (eci >= 16383.0) {
                        int c1 = (int)((eci - 16383.0) / 64516.0) + 192;
                        c2 = (int)((eci - 16383.0) / 254.0);
                        c2 = c2 % 254 + 1;
                        int c3 = (int)((eci - 16383.0) % 254.0) + 1;
                        specialSymbol[result.length()] = "" + (char)c1 + (char)c2 + (char)c3;
                        result = result + '\u00f1';
                    }
                    i += 7;
                }
                if (nextc != 'd' || i >= longi - 3) continue;
                String ascString = code.substring(i + 2, i + 5);
                int asc = 0;
                try {
                    asc = new Integer(ascString);
                }
                catch (Exception e) {
                    asc = 0;
                }
                if (asc > 255) {
                    asc = 255;
                }
                result = result + (char)asc;
                i += 4;
                continue;
            }
            result = result + (char)c;
        }
        return result;
    }

    private void doCode() {
        String[] specialSymbol = new String[5000];
        this.reBuild = false;
        int[] c = null;
        if (this.codeBinary != null) {
            c = new int[this.codeBinary.length];
            int tmp = 0;
            for (int i = 0; i < c.length; ++i) {
                tmp = this.codeBinary[i];
                if (tmp < 0) {
                    tmp += 256;
                }
                c[i] = tmp;
            }
            tmp = 0;
        } else {
            this.internalCode = this.code;
            if (this.processTilde) {
                this.internalCode = this.applyTilde(this.code, specialSymbol);
            }
            if (this.internalCode.length() == 0) {
                return;
            }
            c = new int[this.internalCode.length()];
            for (int i = 0; i < this.internalCode.length(); ++i) {
                c[i] = this.internalCode.charAt(i);
            }
        }
        this.bitmap = this.drawBarcode(c, specialSymbol);
    }

    private int[][] drawBarcode(int[] codeStr, String[] specialSymbols) {
        int h;
        int config;
        int i;
        int[] encoded = new int[5000];
        int[] dummy = new int[1];
        int[] dummy2 = new int[1];
        int encodedLength = 0;
        if (this.encoding != E_AUTO) {
            this.currentEncoding = this.encoding;
        }
        if (this.encoding == E_AUTO) {
            encodedLength = this.encodeAuto(codeStr.length, codeStr, encoded, specialSymbols);
        }
        if (this.encoding == E_ASCII) {
            encodedLength = this.encodeAscii(codeStr.length, codeStr, encoded, specialSymbols);
        }
        if (this.encoding == E_C40) {
            encodedLength = this.encodeC40(codeStr.length, dummy, codeStr, encoded, false, true, false, specialSymbols);
        }
        if (this.encoding == E_TEXT) {
            encodedLength = this.encodeC40(codeStr.length, dummy, codeStr, encoded, true, true, false, specialSymbols);
        }
        if (this.encoding == E_BASE256) {
            encodedLength = this.encodeBase256(codeStr.length, dummy, codeStr, dummy2, encoded, false, specialSymbols);
        }
        if (this.encoding == E_NONE) {
            encodedLength = codeStr.length;
            for (i = 0; i < encodedLength; ++i) {
                encoded[i] = codeStr[i];
            }
        }
        i = 0;
        if (this.preferredFormat != -1 && encodedLength > configuration[i = this.preferredFormat][7]) {
            i = 0;
        }
        while (encodedLength > configuration[i][7] && i < 30) {
            if (this.currentEncoding == E_C40 || this.currentEncoding == E_TEXT) {
                if (this.C49rest == 1 && encoded[encodedLength - 2] == 254 && configuration[i][7] == encodedLength - 1) {
                    encoded[encodedLength - 2] = encoded[encodedLength - 1];
                    encoded[encodedLength - 1] = 0;
                    --encodedLength;
                    break;
                }
                if (this.C49rest == 0 && encoded[encodedLength - 1] == 254 && configuration[i][7] == encodedLength - 1) {
                    encoded[encodedLength - 1] = 0;
                    --encodedLength;
                    break;
                }
            }
            ++i;
        }
        if (i == 30) {
            return null;
        }
        this.calculatedFormat = config = i;
        this.rows = configuration[config][0];
        this.cols = configuration[config][1];
        this.datarows = configuration[config][2];
        this.datacols = configuration[config][3];
        this.maprows = configuration[config][5];
        this.mapcols = configuration[config][6];
        this.regions = configuration[config][4];
        this.totaldata = configuration[config][7];
        this.totalerr = configuration[config][8];
        this.reeddata = configuration[config][9];
        this.reederr = configuration[config][10];
        this.reedblocks = configuration[config][11];
        if ((this.currentEncoding == E_C40 || this.currentEncoding == E_TEXT) && this.C49rest == 0 && encodedLength == this.totaldata && encoded[encodedLength - 1] == 254) {
            encoded[encodedLength - 1] = 129;
        }
        int[][] blocks = new int[10][255];
        boolean firstPad = true;
        for (h = encodedLength; h < this.totaldata; ++h) {
            encoded[h] = firstPad ? 129 : this.random253(129, h + 1);
            firstPad = false;
        }
        for (h = 0; h <= encodedLength - 1; ++h) {
            if (encoded[h] != 10254) continue;
            encoded[h] = 254;
        }
        int tmp = 0;
        int tmpcol = 0;
        for (int h2 = 1; h2 <= this.totaldata; ++h2) {
            blocks[tmp][tmpcol] = encoded[h2 - 1];
            if (++tmp != this.reedblocks) continue;
            tmp = 0;
            ++tmpcol;
        }
        int[] blocksLen = new int[10];
        int totalLen = 0;
        reed reedsol = new reed();
        reed.K = this.reeddata;
        for (int h3 = 0; h3 < this.reedblocks; ++h3) {
            blocksLen[h3] = this.reeddata + this.reederr;
            int tmpReedData = this.reeddata;
            if (this.rows == 144 && h3 > 7) {
                blocksLen[h3] = this.reeddata + this.reederr - 1;
                tmpReedData = 155;
            }
            reedsol.calcRS(blocks[h3], tmpReedData, this.reederr);
            totalLen += blocksLen[h3];
        }
        int[] finalBlock = new int[totalLen];
        int finalBlockLen = 0;
        int c = 0;
        for (int j = 0; j < blocksLen[0]; ++j) {
            for (int h4 = 0; h4 < this.reedblocks; ++h4) {
                if (j >= blocksLen[h4]) continue;
                finalBlock[c++] = blocks[h4][j];
                ++finalBlockLen;
            }
        }
        int[][] bitmap = this.createBitmap(finalBlock);
        return bitmap;
    }

    private void debugMatrix(int[][] m, int c, int r) {
        String s = "";
        System.out.println(s);
        System.out.println(s);
        System.out.println(s);
        for (int j1 = 0; j1 < r; ++j1) {
            s = "";
            for (int i1 = 0; i1 < c; ++i1) {
                s = m[i1][j1] != 0 ? s + "X" : s + " ";
            }
            System.out.println(s);
        }
        System.out.println("");
        System.out.println("");
    }

    private int[][] createBitmap(int[] codeStr) {
        int[][] result = new int[this.cols][this.rows];
        int curx = 0;
        int cury = 0;
        if (this.regions == 2) {
            this.drawBorders(result, curx, cury, this.datacols + 2, this.datarows + 2);
            this.drawBorders(result, curx + this.datacols + 2, cury, this.datacols + 2, this.datarows + 2);
        } else {
            int tmp = (int)Math.sqrt(this.regions);
            for (int i = 0; i < tmp; ++i) {
                for (int j = 0; j < tmp; ++j) {
                    this.drawBorders(result, curx + i * (this.datacols + 2), cury + j * (this.datarows + 2), this.datacols + 2, this.datarows + 2);
                }
            }
        }
        int[] tmpMap = new int[(this.mapcols + 10) * this.maprows];
        charPlacer placer = new charPlacer();
        placer.ncol = this.mapcols;
        placer.nrow = this.maprows;
        placer.array = tmpMap;
        placer.make();
        int vertical = 1;
        int r2 = 0;
        int c2 = 0;
        for (int r = 0; r < this.maprows; ++r) {
            int horizontal = 1;
            for (int c = 0; c < this.mapcols; ++c) {
                c2 = c + horizontal;
                r2 = r + vertical;
                if (tmpMap[r * this.mapcols + c] > 9) {
                    int dot;
                    int character = tmpMap[r * this.mapcols + c] / 10;
                    int bit = tmpMap[r * this.mapcols + c] % 10;
                    result[c2][r2] = dot = codeStr[character - 1] & 1 << 8 - bit;
                } else {
                    result[c2][r2] = tmpMap[r * this.mapcols + c];
                }
                if (c <= 0 || (c + 1) % this.datacols != 0) continue;
                horizontal += 2;
            }
            if (r <= 0 || (r + 1) % this.datarows != 0) continue;
            vertical += 2;
        }
        return result;
    }

    private void drawBorders(int[][] map, int x, int y, int w, int h) {
        int i;
        int alternative = 0;
        for (i = 0; i < w; ++i) {
            alternative = i % 2 == 0 ? 1 : 0;
            map[x + i][y + h - 1] = 1;
            map[x + i][y] = alternative;
        }
        alternative = 0;
        for (i = 0; i < h; ++i) {
            alternative = (i + 1) % 2 == 0 ? 1 : 0;
            map[x][y + i] = 1;
            map[x + w - 1][y + i] = alternative;
        }
    }

    private int encodeAscii(int longi, int[] in, int[] out, String[] specialSymbols) {
        int outp = 0;
        boolean done = false;
        for (int j = 0; j < longi; ++j) {
            block10: {
                block13: {
                    block12: {
                        block11: {
                            done = false;
                            if (j < longi - 1 && in[j] >= 48 && in[j] <= 57 && in[j + 1] >= 48 && in[j + 1] <= 57 && j < longi) {
                                int tmp = (in[j] - 48) * 10 + (in[j + 1] - 48);
                                out[outp++] = 130 + tmp;
                                ++j;
                                done = true;
                            }
                            if (done || specialSymbols[j] == null) break block10;
                            if (in[j] == 234) break block11;
                            if (in[j] == 237) break block11;
                            if (in[j] == 236) break block11;
                            if (in[j] != 232) break block12;
                        }
                        out[outp++] = in[j];
                        done = true;
                    }
                    if (in[j] == 233) break block13;
                    if (in[j] != 241) break block10;
                }
                out[outp++] = in[j];
                for (int l = 0; l < specialSymbols[j].length(); ++l) {
                    out[outp++] = specialSymbols[j].charAt(l);
                }
                done = true;
            }
            if (done) continue;
            if (in[j] < 128) {
                out[outp++] = in[j] + 1;
                continue;
            }
            out[outp++] = 235;
            out[outp++] = in[j] - 128 + 1;
        }
        return outp;
    }

    private class charPlacer {
        public int nrow;
        public int ncol;
        public int[] array;

        private charPlacer() {
        }

        private void utah(int row, int col, int chr) {
            this.module(row - 2, col - 2, chr, 1);
            this.module(row - 2, col - 1, chr, 2);
            this.module(row - 1, col - 2, chr, 3);
            this.module(row - 1, col - 1, chr, 4);
            this.module(row - 1, col, chr, 5);
            this.module(row, col - 2, chr, 6);
            this.module(row, col - 1, chr, 7);
            this.module(row, col, chr, 8);
        }

        private void corner1(int chr) {
            this.module(this.nrow - 1, 0, chr, 1);
            this.module(this.nrow - 1, 1, chr, 2);
            this.module(this.nrow - 1, 2, chr, 3);
            this.module(0, this.ncol - 2, chr, 4);
            this.module(0, this.ncol - 1, chr, 5);
            this.module(1, this.ncol - 1, chr, 6);
            this.module(2, this.ncol - 1, chr, 7);
            this.module(3, this.ncol - 1, chr, 8);
        }

        private void corner2(int chr) {
            this.module(this.nrow - 3, 0, chr, 1);
            this.module(this.nrow - 2, 0, chr, 2);
            this.module(this.nrow - 1, 0, chr, 3);
            this.module(0, this.ncol - 4, chr, 4);
            this.module(0, this.ncol - 3, chr, 5);
            this.module(0, this.ncol - 2, chr, 6);
            this.module(0, this.ncol - 1, chr, 7);
            this.module(1, this.ncol - 1, chr, 8);
        }

        private void corner3(int chr) {
            this.module(this.nrow - 3, 0, chr, 1);
            this.module(this.nrow - 2, 0, chr, 2);
            this.module(this.nrow - 1, 0, chr, 3);
            this.module(0, this.ncol - 2, chr, 4);
            this.module(0, this.ncol - 1, chr, 5);
            this.module(1, this.ncol - 1, chr, 6);
            this.module(2, this.ncol - 1, chr, 7);
            this.module(3, this.ncol - 1, chr, 8);
        }

        private void corner4(int chr) {
            this.module(this.nrow - 1, 0, chr, 1);
            this.module(this.nrow - 1, this.ncol - 1, chr, 2);
            this.module(0, this.ncol - 3, chr, 3);
            this.module(0, this.ncol - 2, chr, 4);
            this.module(0, this.ncol - 1, chr, 5);
            this.module(1, this.ncol - 3, chr, 6);
            this.module(1, this.ncol - 2, chr, 7);
            this.module(1, this.ncol - 1, chr, 8);
        }

        public void make() {
            int chr = 1;
            int row = 4;
            int col = 0;
            for (int r = 0; r < this.nrow; ++r) {
                for (int c = 0; c < this.ncol; ++c) {
                    this.array[r * this.ncol + c] = 0;
                }
            }
            do {
                if (row == this.nrow && col == 0) {
                    this.corner1(chr++);
                }
                if (row == this.nrow - 2 && col == 0 && this.ncol % 4 != 0) {
                    this.corner2(chr++);
                }
                if (row == this.nrow - 2 && col == 0 && this.ncol % 8 == 4) {
                    this.corner3(chr++);
                }
                if (row == this.nrow + 4 && col == 2 && this.ncol % 8 == 0) {
                    this.corner4(chr++);
                }
                do {
                    if (row >= this.nrow || col < 0 || this.array[row * this.ncol + col] != 0) continue;
                    this.utah(row, col, chr++);
                } while ((row -= 2) >= 0 && (col += 2) < this.ncol);
                ++row;
                col += 3;
                do {
                    if (row < 0 || col >= this.ncol || this.array[row * this.ncol + col] != 0) continue;
                    this.utah(row, col, chr++);
                } while ((row += 2) < this.nrow && (col -= 2) >= 0);
            } while ((row += 3) < this.nrow || ++col < this.ncol);
            if (this.array[this.nrow * this.ncol - 1] == 0) {
                this.array[this.nrow * this.ncol - this.ncol - 2] = 1;
                this.array[this.nrow * this.ncol - 1] = 1;
            }
        }

        private void module(int r, int c, int chr, int bit) {
            if (r < 0) {
                r += this.nrow;
                c += 4 - (this.nrow + 4) % 8;
            }
            if (c < 0) {
                c += this.ncol;
                r += 4 - (this.ncol + 4) % 8;
            }
            this.array[r * this.ncol + c] = 10 * chr + bit;
        }
    }
}

