/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;

class BufferCleaner {
    Class<?> unmappableBufferClass;
    final Method method;
    final Object theUnsafe;

    BufferCleaner(Class<?> unmappableBufferClass, Method method, Object theUnsafe) {
        this.unmappableBufferClass = unmappableBufferClass;
        this.method = method;
        this.theUnsafe = theUnsafe;
    }

    void freeBuffer(String resourceDescription, final ByteBuffer buffer) throws IOException {
        assert (Objects.equals(Void.TYPE, this.method.getReturnType()));
        assert (this.method.getParameterTypes().length == 1);
        assert (Objects.equals(ByteBuffer.class, this.method.getParameterTypes()[0]));
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("unmapping only works with direct buffers");
        }
        if (!this.unmappableBufferClass.isInstance(buffer)) {
            throw new IllegalArgumentException("buffer is not an instance of " + this.unmappableBufferClass.getName());
        }
        Throwable error = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

            @Override
            public Throwable run() {
                try {
                    BufferCleaner.this.method.invoke(BufferCleaner.this.theUnsafe, buffer);
                    return null;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return e;
                }
            }
        });
        if (error != null) {
            throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, error);
        }
    }

    static Object unmapHackImpl() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Method method = unsafeClass.getDeclaredMethod("invokeCleaner", ByteBuffer.class);
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return new BufferCleaner(ByteBuffer.class, method, theUnsafe);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

