/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.utils.oauth10;

import com.infor.erpln.utils.oauth10.Authenticator;
import com.infor.erpln.utils.oauth10.OAuthUtil;
import com.infor.erpln.utils.oauth10.UsedNonce;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class OAuthHeader {
    private static final String OAUTH_VERSION = "1.0";
    private static final String OAUTH_HEADER = "OAuth";
    private final boolean m_valid;
    private final Map<String, String> m_fields = new HashMap<String, String>();
    private UsedNonce m_usedNonce;
    private String m_signature;
    private Authenticator.HmacType m_hmacType;

    private OAuthHeader(String headerString) {
        boolean valid = false;
        if (headerString != null && headerString.startsWith(OAUTH_HEADER)) {
            try {
                String[] keyValues;
                Pattern pattern = Pattern.compile("(oauth_[a-z_]+)=\"(\\S+)\"");
                block8: for (String keyValue : keyValues = StringUtils.split((String)headerString.substring(OAUTH_HEADER.length()), (char)',')) {
                    Matcher matcher = pattern.matcher(keyValue.trim());
                    if (!matcher.matches()) continue;
                    String name = matcher.group(1);
                    String value = OAuthUtil.decodePercent(matcher.group(2));
                    switch (name) {
                        case "oauth_signature": {
                            this.m_signature = value;
                            continue block8;
                        }
                        default: {
                            this.m_fields.put(name, value);
                        }
                    }
                }
                this.m_usedNonce = new UsedNonce(Long.parseLong(this.m_fields.get("oauth_timestamp")), this.m_fields.get("oauth_nonce"));
                this.m_hmacType = Authenticator.HmacType.parse(this.m_fields.get("oauth_signature_method"));
                valid = this.m_fields.get("oauth_version") == null || OAUTH_VERSION.equals(this.m_fields.get("oauth_version"));
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        }
        this.m_valid = valid;
    }

    private OAuthHeader() {
        this.m_valid = true;
    }

    public static OAuthHeader getInstance(String headerContents) {
        return new OAuthHeader(headerContents);
    }

    public static OAuthHeader getInstance() {
        return new OAuthHeader();
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    public Authenticator.HmacType getHmacType() {
        return this.m_hmacType;
    }

    public String getKey() {
        return this.m_fields.get("oauth_consumer_key");
    }

    public void setKey(String key) {
        this.m_fields.put("oauth_consumer_key", key);
    }

    public long getTimestamp() {
        return Long.parseLong(this.m_fields.get("oauth_timestamp"));
    }

    public void setTimeStamp(long timeStamp) {
        this.m_fields.put("oauth_timestamp", String.valueOf(timeStamp));
    }

    public UsedNonce getUsedNonce() {
        return this.m_usedNonce;
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.m_fields);
    }

    public String getNonce() {
        return this.m_fields.get("oauth_nonce");
    }

    public void setNonce(String nonce) {
        this.m_fields.put("oauth_nonce", nonce);
    }

    public String getVersion() {
        return this.m_fields.get("oauth_version");
    }

    public void setVersion(String version) {
        this.m_fields.put("oauth_version", version);
    }

    public String getSignatureMethod() {
        return this.m_fields.get("oauth_signature_method");
    }

    public void setSignatureMethod(String method) {
        this.m_fields.put("oauth_signature_method", method);
        this.m_hmacType = Authenticator.HmacType.parse(this.m_fields.get("oauth_signature_method"));
    }

    public String getHeaderValueAsString() {
        StringBuilder buf = new StringBuilder();
        buf.append("OAuth ");
        this.appendProperty(buf, "oauth_consumer_key", this.getKey()).append(",");
        this.appendProperty(buf, "oauth_nonce", this.getNonce()).append(",");
        this.appendProperty(buf, "oauth_signature_method", this.getSignatureMethod()).append(",");
        this.appendProperty(buf, "oauth_timestamp", String.valueOf(this.getTimestamp())).append(",");
        this.appendProperty(buf, "oauth_version", this.getVersion()).append(",");
        this.appendProperty(buf, "oauth_signature", OAuthUtil.percentEncode(this.getSignature()));
        return buf.toString();
    }

    private StringBuilder appendProperty(StringBuilder buf, String key, String value) {
        buf.append(key).append("=\"").append(value).append("\"");
        return buf;
    }
}

