/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.utils.oauth10;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class BaseUriUtil {
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";

    public static String getBaseUri(HttpServletRequest request) {
        String scheme = BaseUriUtil.resolveHeaderValue(request.getHeader(X_FORWARDED_PROTO), request.getScheme());
        String rawHostAndPort = BaseUriUtil.resolveHeaderValue(request.getHeader(X_FORWARDED_HOST), request.getHeader("Host"));
        String[] hostAndPort = rawHostAndPort.split(":");
        String port = hostAndPort.length == 1 ? "" : hostAndPort[1];
        StringBuilder baseUri = new StringBuilder();
        baseUri.append(scheme).append("://").append(hostAndPort[0]);
        if (!(port.isEmpty() || scheme.equals("http") && port.equals("80") || scheme.equals("https") && port.equals("443"))) {
            baseUri.append(':').append(port);
        }
        baseUri.append(BaseUriUtil.getOriginalRequestUri(request));
        return baseUri.toString();
    }

    private static String getOriginalRequestUri(HttpServletRequest request) {
        Object forwardedUri = request.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri instanceof String) {
            return (String)forwardedUri;
        }
        return request.getRequestURI();
    }

    private static String resolveHeaderValue(String headerValue, String currentValue) {
        String value = StringUtils.isEmpty((String)headerValue) ? currentValue : headerValue;
        return value.toLowerCase(Locale.getDefault());
    }

    private BaseUriUtil() {
    }
}

