/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.ln.server.CustomAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;

public class UserEventLog {
    private transient Level m_level = Level.OFF;
    private final Layout<? extends Serializable> m_layout;
    private CustomAppender.TimerCleanupTask m_cleanupTask;
    private File m_file;
    private OutputStream m_outStream;

    public UserEventLog(Layout<? extends Serializable> layout) {
        this.m_layout = layout;
        try {
            this.m_file = File.createTempFile("javaws-", ".log");
            this.m_outStream = new FileOutputStream(this.m_file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        Level level = event.getLevel();
        if (level.isMoreSpecificThan(this.m_level)) {
            byte[] bytes = this.m_layout.toByteArray(event);
            try {
                UserEventLog userEventLog = this;
                synchronized (userEventLog) {
                    if (this.m_outStream != null) {
                        this.m_outStream.write(bytes);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setLevel(String level) {
        this.m_level = Level.toLevel((String)level, (Level)Level.ERROR);
    }

    public synchronized InputStream getInputStream() {
        if (this.m_file != null) {
            try {
                return new FileInputStream(this.m_file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        InputStream empty = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        return empty;
    }

    public synchronized void cleanup() {
        if (this.m_outStream != null) {
            try {
                this.m_outStream.close();
                this.m_outStream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.m_file != null) {
            this.m_file.delete();
            this.m_file = null;
        }
    }

    public void setCleanupTask(CustomAppender.TimerCleanupTask task) {
        this.m_cleanupTask = task;
    }

    public CustomAppender.TimerCleanupTask getCleanupTask() {
        return this.m_cleanupTask;
    }
}

