/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.ln.server.AuthFilter;
import com.infor.ln.server.KmsUtil;
import com.infor.ln.server.Metrics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final String CONFIG_MANAGER = "configManager";
    private static final String LOG4JFILE = "log4j2.xml";
    private static final Logger LOG = LogManager.getLogger(ConfigManager.class);
    private final ServletContext m_context;
    private final File m_configDir;
    private final URI m_log4jFile;
    private final boolean m_isMultiTenant;
    private final boolean m_strictAuth;
    private Metrics m_metrics;

    public static ConfigManager getConfigManager(ServletContext context) {
        Object configManager = context.getAttribute(CONFIG_MANAGER);
        if (!(configManager instanceof ConfigManager)) {
            configManager = new ConfigManager(context);
            context.setAttribute(CONFIG_MANAGER, configManager);
        }
        return (ConfigManager)configManager;
    }

    public void shutdown() {
        if (this.m_metrics != null) {
            this.m_metrics.shutdown();
        }
    }

    public File getConfigDir() {
        return this.m_configDir;
    }

    public boolean isMultiTenant() {
        return this.m_isMultiTenant;
    }

    public void setAuthenticator(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            Properties configuration = new Properties();
            configuration.load(input);
            String key = configuration.getProperty("oauth10key");
            String secret = configuration.getProperty("oauth10secret");
            if (secret != null && secret.startsWith("$1AWSKMS$")) {
                secret = KmsUtil.getInstance().kmsDecrypt(secret);
            }
            this.createAuthentication(key, secret, null);
        }
        catch (IOException e) {
            this.createAuthentication(null, null, e);
        }
    }

    boolean isStrictAuth() {
        return this.m_strictAuth;
    }

    URI getLog4jFile() {
        return this.m_log4jFile;
    }

    private ConfigManager(ServletContext context) {
        this.m_context = context;
        this.m_configDir = this.findConfigDir();
        this.m_log4jFile = this.createFile(new File(this.m_configDir, LOG4JFILE), "/com/infor/ln/server/log4j2.xml");
        this.m_isMultiTenant = this.checkIsMultiTenant();
        this.m_strictAuth = Boolean.parseBoolean(context.getInitParameter("StrictAuth"));
    }

    private File findConfigDir() {
        File configPath = null;
        String path = this.m_context.getInitParameter("ConfigPath");
        if (path != null && !path.isEmpty()) {
            configPath = new File(path);
        }
        if (configPath == null) {
            configPath = new File(this.getWebAppDir(), "config");
        }
        if (!configPath.exists()) {
            configPath.mkdirs();
        }
        return configPath;
    }

    private File getWebAppDir() {
        String webappDir = this.m_context.getRealPath("/");
        return new File(webappDir);
    }

    private URI createFile(File targetFile, String resourceName) {
        URI result = targetFile.toURI();
        if (!targetFile.exists()) {
            try (InputStream input = this.getClass().getResourceAsStream(resourceName);){
                Files.copy(input, targetFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                result = this.getResourceURI(resourceName);
            }
        }
        return result;
    }

    private URI getResourceURI(String resourceName) {
        try {
            return this.getClass().getResource(resourceName).toURI();
        }
        catch (URISyntaxException e) {
            return URI.create(resourceName);
        }
    }

    private boolean checkIsMultiTenant() {
        return Boolean.parseBoolean(this.m_context.getInitParameter("MultiTenant"));
    }

    private void createAuthentication(String key, String secret, Exception exception) {
        if (key == null || key.isEmpty() || secret == null || secret.isEmpty()) {
            if (this.m_strictAuth) {
                if (exception == null) {
                    LOG.error("Mandatory OAuth 1.0 key and/or secret missing");
                    throw new IllegalStateException("Mandatory OAuth 1.0 key and/or secret missing");
                }
                LOG.error("Exception reading mandatory OAuth 1.0 configuration", (Throwable)exception);
                throw new IllegalStateException("Exception reading mandatory OAuth 1.0 configuration", exception);
            }
            AuthFilter.setAuthenticator(this.m_context, this.m_strictAuth, "", "");
        } else {
            AuthFilter.setAuthenticator(this.m_context, this.m_strictAuth, key, secret);
        }
    }

    public void setMetricsUrl(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            Properties configuration = new Properties();
            configuration.load(input);
            String url = configuration.getProperty("metricsUrl");
            if (url != null && !url.isEmpty()) {
                this.m_metrics = new Metrics(new URL(url));
            } else {
                LOG.info("Propery metricsUrl is not present");
            }
        }
        catch (IOException e) {
            this.m_metrics = null;
        }
    }

    public Metrics getMetrics() {
        return this.m_metrics;
    }
}

