/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml.birt;

import com.ibm.icu.util.ULocale;
import com.ssaglobal.bml.birt.BMLString;
import com.ssaglobal.bml.birt.ReportField;
import com.ssaglobal.bml.birt.ReportLayout;
import com.ssaglobal.bml.birt.ReportLine;
import com.ssaglobal.bml.birt.ReportModel;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.xml.sax.SAXException;

public class ReportDesign {
    static IDesignEngine cEngine = null;
    ReportDesignHandle mReportDesignHandle = null;
    ElementFactory mElementFactory = null;
    SortedSet<Integer> mAllFieldPositions = null;
    ReportModel mReportModel = null;
    double mCharWidth;
    String mStandardUnits;

    public ReportDesign() throws BirtException {
        this.init();
    }

    private synchronized void init() throws BirtException {
        if (cEngine == null) {
            DesignConfig config = new DesignConfig();
            String sBirtHome = System.getenv("BIRT_HOME");
            if (sBirtHome != null) {
                sBirtHome = sBirtHome.replace("\\", "/");
                config.setBIRTHome(sBirtHome);
            }
            Platform.startup((PlatformConfig)config);
            IDesignEngineFactory factory = (IDesignEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory");
            cEngine = factory.createDesignEngine(config);
        }
    }

    private double getcpi(String font) {
        int len = font == null ? 0 : font.length();
        String value = "";
        for (int i = 0; i < len; ++i) {
            char c = font.charAt(i);
            if (c == '.' || c == '0' || c >= '1' && c <= '9') {
                value = value + c;
                continue;
            }
            if (c != ',') continue;
            value = value + '.';
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return 17.1;
        }
    }

    public void buildDesign(String sReportTemplateFile, String sOutputReportFile, ReportModel sReportModel) throws BirtException, ParserConfigurationException, SAXException, IOException {
        this.mReportModel = sReportModel;
        ULocale locale = ULocale.getDefault();
        SessionHandle session = cEngine.newSessionHandle(locale);
        this.mReportDesignHandle = session.openDesign(sReportTemplateFile);
        String createdBy = System.getProperty("user.name");
        this.mReportDesignHandle.setCreatedBy(createdBy);
        String title = this.mReportModel.getName();
        this.mReportDesignHandle.setDescription(title);
        this.mReportDesignHandle.setDisplayName(title);
        this.mReportDesignHandle.setProperty("title", (Object)title);
        this.mElementFactory = this.mReportDesignHandle.getElementFactory();
        OdaDataSourceHandle mDataSourceHandle = this.mElementFactory.newOdaDataSource("Data_Source", "org.eclipse.datatools.connectivity.oda.flatfile");
        mDataSourceHandle.setProperty("HOME", (Object)".");
        mDataSourceHandle.setProperty("DELIMTYPE", (Object)"COMMA");
        mDataSourceHandle.setProperty("CHARSET", (Object)"UTF-8");
        mDataSourceHandle.setProperty("INCLCOLUMNNAME", (Object)"YES");
        mDataSourceHandle.setProperty("INCLTYPELINE", (Object)"NO");
        String script = "var ds = params[\"DS\"];var f = new java.io.File(ds);var fn = \"\" + f.getParent();this.setExtensionProperty(\"HOME\", fn);";
        mDataSourceHandle.setBeforeOpen(script);
        String delete_data_file = System.getenv("DELETE_DATA_FILE");
        if (!"NO".equals(delete_data_file)) {
            script = "var cf = new Packages.com.infor.studio.reporting.StoreXMLInFile();var ds = params[\"DS\"];cf.DeleteFile(ds);";
            mDataSourceHandle.setAfterClose(script);
        }
        this.mReportDesignHandle.getDataSources().add((DesignElementHandle)mDataSourceHandle);
        SimpleMasterPageHandle masterPage = (SimpleMasterPageHandle)this.mReportDesignHandle.getMasterPages().get(0);
        masterPage.setComments("Original font: " + this.mReportModel.getFont());
        this.mStandardUnits = masterPage.getPageWidth().getUnits();
        int numChars = this.getPageWidth();
        double cpi = this.getcpi(this.mReportModel.getFont());
        double ipc = 1.0 / cpi;
        double requiredInches = (double)numChars * ipc;
        double requiredWidth = this.convertToStandardUnits(requiredInches, "in");
        this.mCharWidth = requiredWidth / (double)numChars;
        this.mCharWidth *= 0.95;
        double margins = this.convertToStandardUnits(masterPage.getLeftMargin().getAbsoluteValue()) + this.convertToStandardUnits(masterPage.getRightMargin().getAbsoluteValue());
        double availableWidth = this.convertToStandardUnits(masterPage.getPageWidth()) - margins;
        if (requiredWidth > availableWidth) {
            masterPage.setOrientation("landscape");
        } else {
            masterPage.setOrientation("portrait");
        }
        availableWidth = this.convertToStandardUnits(masterPage.getPageWidth()) - margins;
        if (availableWidth < requiredWidth) {
            double oldPageWidth = this.convertToStandardUnits(masterPage.getPageWidth());
            double oldPageHeight = this.convertToStandardUnits(masterPage.getPageHeight());
            double newPageWidth = requiredWidth + margins;
            double factor = newPageWidth / oldPageWidth;
            double newPageHeight = oldPageHeight * factor;
            masterPage.setPageType("custom");
            masterPage.setProperty("width", (Object)(NumberFormat.getInstance().format(newPageWidth) + this.mStandardUnits));
            masterPage.setProperty("height", (Object)(NumberFormat.getInstance().format(newPageHeight) + this.mStandardUnits));
        }
        this.createBanner();
        TableHandle table = this.createTable();
        this.setColumnWidth(table);
        SharedStyleHandle reportStyle = (SharedStyleHandle)this.mReportDesignHandle.getStyles().get(0);
        DimensionValue font = reportStyle.getFontSize().getAbsoluteValue();
        font = DimensionUtil.convertTo((double)font.getMeasure(), (String)font.getUnits(), (String)"pt");
        double oldfont = font.getMeasure();
        double newfont = oldfont * 17.1 / cpi;
        int times10 = (int)((newfont *= 0.9) * 10.0);
        newfont = (double)times10 / 10.0;
        reportStyle.setProperty("fontSize", (Object)(NumberFormat.getInstance().format(newfont) + "pt"));
        table.setStyle(reportStyle);
        OdaDataSetHandle dataset = this.createDataSet();
        script = "var ds = params[\"DS\"];var f = new java.io.File(ds);var fn = f.getName();this.queryText=\"select * from \" + fn;";
        dataset.setBeforeOpen(script);
        table.setDataSet((DataSetHandle)dataset);
        this.createComputedColumns(table);
        this.createCells(table);
        this.mReportDesignHandle.saveAs(sOutputReportFile);
        this.mReportDesignHandle.close();
    }

    private void createBanner() throws BirtException {
        int nCells;
        TextItemHandle text = (TextItemHandle)this.mReportDesignHandle.findElement("Title");
        String title = this.mReportModel.getName();
        text.setContent(title);
        CellHandle titleCell = (CellHandle)text.getContainer();
        RowHandle titleRow = (RowHandle)titleCell.getContainer();
        int titleIndex = titleCell.getIndex();
        int reportWidth = this.getPageWidth();
        int titleWidth = title.length();
        if (titleWidth > reportWidth / 5 && (nCells = titleRow.getCells().getCount()) > 1 + titleIndex) {
            CellHandle empty = (CellHandle)titleRow.getCells().get(1 + titleIndex);
            empty.dropAndClear();
            titleCell.setColumnSpan(2);
        }
    }

    private double convertToStandardUnits(double measure, String fromUnits) {
        return DimensionUtil.convertTo((double)measure, (String)fromUnits, (String)this.mStandardUnits).getMeasure();
    }

    private double convertToStandardUnits(DimensionValue dimension) {
        return this.convertToStandardUnits(dimension.getMeasure(), dimension.getUnits());
    }

    private int getPageWidth() {
        SortedSet<Integer> allPositions = this.getAllFieldPositions();
        return allPositions.last() - 1;
    }

    private void setColumnWidth(TableHandle table) throws SemanticException {
        SortedSet<Integer> allPositions = this.getAllFieldPositions();
        Iterator iter = allPositions.iterator();
        int left = 0;
        int right = 0;
        int col = 0;
        if (iter.hasNext()) {
            left = (Integer)iter.next();
        }
        while (iter.hasNext()) {
            right = (Integer)iter.next();
            int columnwidth = right - left;
            double width = this.mCharWidth * (double)columnwidth;
            String value = NumberFormat.getInstance().format(width) + this.mStandardUnits;
            table.getColumns().get(col++).setProperty("width", (Object)value);
            left = right;
        }
    }

    private void createComputedColumns(TableHandle table) throws SemanticException {
        this.createComputedColumnForField(table, "pagebreak");
        this.createComputedColumnForField(table, "emptyline");
        for (ReportLayout layout : this.mReportModel.layouts) {
            for (ReportLine line : layout.lines) {
                this.createComputedColumnForField(table, line.id);
                for (ReportField field : line.fields) {
                    if (!field.hasDataItem()) continue;
                    this.createComputedColumnForField(table, field.getName());
                }
            }
        }
    }

    private void createComputedColumnForField(TableHandle table, String name) throws SemanticException {
        ComputedColumn column = StructureFactory.createComputedColumn();
        String expr = "dataSetRow[\"" + name + "\"]";
        column.setName(name);
        column.setExpression(expr);
        column.setDataType("string");
        table.getColumnBindings().addItem((IStructure)column);
    }

    private void createCells(TableHandle table) throws SemanticException {
        this.createCellsForPageBreak(table);
        this.createCellsForEmptyLine(table);
        for (ReportLayout layout : this.mReportModel.layouts) {
            for (ReportLine line : layout.lines) {
                this.createRow(line, table);
            }
        }
    }

    private void setPadding(ReportElementHandle elem) throws SemanticException {
        elem.setProperty("paddingTop", (Object)"0pt");
        elem.setProperty("paddingBottom", (Object)"0pt");
        elem.setProperty("paddingLeft", (Object)"0pt");
        elem.setProperty("paddingRight", (Object)"0pt");
    }

    private void createCellsForPageBreak(TableHandle table) throws SemanticException {
        RowHandle row = this.mElementFactory.newTableRow(1);
        this.setPadding((ReportElementHandle)row);
        row.setProperty("pageBreakBefore", (Object)"avoid");
        row.setProperty("pageBreakAfter", (Object)"always");
        this.setVisibility((ReportElementHandle)row, "pagebreak");
        CellHandle cell = (CellHandle)row.getCells().get(0);
        cell.setColumnSpan(table.getColumnCount());
        table.getDetail().add((DesignElementHandle)row);
    }

    private void createCellsForEmptyLine(TableHandle table) throws SemanticException {
        RowHandle row = this.mElementFactory.newTableRow(1);
        this.setPadding((ReportElementHandle)row);
        this.setVisibility((ReportElementHandle)row, "emptyline");
        CellHandle cell = (CellHandle)row.getCells().get(0);
        this.setPadding((ReportElementHandle)cell);
        this.emptyCellForEmptyLine(cell);
        cell.setColumnSpan(table.getColumnCount());
        table.getDetail().add((DesignElementHandle)row);
    }

    private OdaDataSetHandle createDataSet() throws SemanticException {
        OdaDataSetHandle datasetHandle = null;
        datasetHandle = this.mElementFactory.newOdaDataSet("Data_Set", "org.eclipse.datatools.connectivity.oda.flatfile.dataSet");
        datasetHandle.setDataSource("Data_Source");
        this.mReportDesignHandle.getDataSets().add((DesignElementHandle)datasetHandle);
        return datasetHandle;
    }

    public SortedSet<Integer> getAllFieldPositions() {
        if (this.mAllFieldPositions == null) {
            this.mAllFieldPositions = new TreeSet<Integer>();
            int finalpos = 0;
            for (ReportField field : this.mReportModel.getAllFields()) {
                String alignment;
                int width;
                int startpos = field.getStartPosition();
                int endpos = startpos + (width = field.getWidth());
                if (endpos > finalpos) {
                    finalpos = endpos;
                }
                this.mAllFieldPositions.add(startpos);
                if (!field.hasDataItem() || "left".equals(alignment = field.getAlignment())) continue;
                this.mAllFieldPositions.add(endpos);
            }
            this.mAllFieldPositions.add(finalpos);
        }
        return this.mAllFieldPositions;
    }

    private void setVisibility(ReportElementHandle rh, String id) throws SemanticException {
        char QUOTE = '\"';
        String expr = "row[" + QUOTE + id + QUOTE + "]!=" + QUOTE + id + QUOTE;
        HideRule hr = StructureFactory.createHideRule();
        hr.setFormat("all");
        hr.setExpression(expr);
        PropertyHandle ph = rh.getPropertyHandle("visibility");
        ph.addItem((IStructure)hr);
    }

    private void createRow(ReportLine line, TableHandle table) throws SemanticException {
        int position;
        RowHandle row = this.mElementFactory.newTableRow(table.getColumnCount());
        this.setPadding((ReportElementHandle)row);
        this.setVisibility((ReportElementHandle)row, line.id);
        TreeMap<Integer, ReportField> fieldMap = new TreeMap<Integer, ReportField>();
        for (ReportField field : line.fields) {
            int startPosition = field.getStartPosition();
            fieldMap.put(startPosition, field);
        }
        SortedSet<Integer> allFieldPositions = this.getAllFieldPositions();
        int finalPos = allFieldPositions.last();
        Iterator iter = allFieldPositions.iterator();
        int cellNo = 0;
        ReportField field = null;
        int fieldEnd = finalPos;
        while (iter.hasNext() && (position = ((Integer)iter.next()).intValue()) != finalPos) {
            CellHandle cell = (CellHandle)row.getCells().get(cellNo);
            this.setPadding((ReportElementHandle)cell);
            if (fieldMap.containsKey(position)) {
                int nextpos;
                ReportField nextfield;
                field = (ReportField)fieldMap.get(position);
                int width = this.defineCell(cell, field, nextfield = (ReportField)fieldMap.get(nextpos = position + field.getWidth()));
                fieldEnd = width < 0 ? finalPos : position + width;
                ++cellNo;
                continue;
            }
            if (position < fieldEnd && cellNo > 0) {
                cell.dropAndClear();
                cell = (CellHandle)row.getCells().get(cellNo - 1);
                int span = cell.getColumnSpan();
                cell.setColumnSpan(++span);
                continue;
            }
            if (line.fields.isEmpty()) {
                this.emptyCell(cell, position);
            }
            fieldEnd = finalPos;
            ++cellNo;
        }
        table.getDetail().add((DesignElementHandle)row);
    }

    private void emptyCell(CellHandle cell, int startPosition) throws SemanticException {
        cell.setProperty("fontSize", (Object)"25%");
        TextItemHandle textHandle = this.mElementFactory.newTextItem(this.name(startPosition));
        textHandle.setContent(" ");
        this.setPadding((ReportElementHandle)textHandle);
        cell.addElement((DesignElementHandle)textHandle, 0);
    }

    private void emptyCellForEmptyLine(CellHandle cell) throws SemanticException {
        int startPosition = 1;
        TextItemHandle textHandle = this.mElementFactory.newTextItem(this.name(startPosition));
        textHandle.setContent(" ");
        this.setPadding((ReportElementHandle)textHandle);
        cell.addElement((DesignElementHandle)textHandle, 0);
    }

    private int defineCell(CellHandle cell, ReportField field, ReportField nextfield) throws SemanticException {
        int startPosition = field.getStartPosition();
        int width = field.getWidth();
        if (field.hasDataItem()) {
            String name = field.getName();
            DataItemHandle dataItemHandle = this.mElementFactory.newDataItem(this.name(startPosition));
            dataItemHandle.setResultSetColumn(name);
            this.setPadding((ReportElementHandle)dataItemHandle);
            cell.addElement((DesignElementHandle)dataItemHandle, 0);
            if (field.isBold()) {
                cell.setProperty("fontWeight", (Object)"bold");
            }
            if (field.isUnderlined()) {
                cell.setProperty("textUnderline", (Object)"underline");
            }
            String align = field.getAlignment();
            cell.setProperty("textAlign", (Object)align);
            if ("left".equals(align)) {
                width = -1;
            }
        } else if (field.hasText()) {
            BMLString.FORMAT format;
            String textContent = field.getText();
            BMLString bmlString = new BMLString(textContent);
            String plainText = null;
            if (bmlString.hasPlainText()) {
                plainText = bmlString.getPlainText();
                TextItemHandle textHandle = this.mElementFactory.newTextItem(this.name(startPosition));
                textHandle.setContent(plainText);
                this.setPadding((ReportElementHandle)textHandle);
                cell.addElement((DesignElementHandle)textHandle, 0);
            }
            if ((format = bmlString.getFormat()) == BMLString.FORMAT.HORIZONTAL) {
                BMLString bml;
                BMLString.FORMAT fmt;
                boolean horizontal = false;
                if (nextfield != null && nextfield.hasText() && (fmt = (bml = new BMLString(nextfield.getText())).getFormat()) == BMLString.FORMAT.HORIZONTAL) {
                    horizontal = true;
                }
                if (!horizontal) {
                    --width;
                }
                this.setTopBorder(cell);
                if (plainText == null) {
                    this.emptyCell(cell, startPosition);
                }
            } else if (format == BMLString.FORMAT.VERTICAL_LEFT_AND_VERTICAL_RIGHT) {
                --width;
                this.setLeftBorder(cell);
                this.setRightBorder(cell);
            } else if (format == BMLString.FORMAT.VERTICAL_LEFT) {
                this.setLeftBorder(cell);
                width = -1;
            } else if (format == BMLString.FORMAT.VERTICAL_RIGHT) {
                --width;
                this.setRightBorder(cell);
            } else if (format == BMLString.FORMAT.CORNER_LEFT_TOP) {
                this.setLeftBorder(cell);
                this.setTopBorder(cell);
                if (plainText == null) {
                    this.emptyCell(cell, startPosition);
                }
            } else if (format == BMLString.FORMAT.CORNER_LEFT_BOTTOM) {
                this.setTopBorder(cell);
                if (plainText == null) {
                    this.emptyCell(cell, startPosition);
                }
            } else if (format == BMLString.FORMAT.CORNER_RIGHT_TOP) {
                if (width > 1) {
                    --width;
                    this.setRightBorder(cell);
                    this.setTopBorder(cell);
                    if (plainText == null) {
                        this.emptyCell(cell, startPosition);
                    }
                } else {
                    width = -1;
                    this.setLeftBorder(cell);
                }
            } else if (format == BMLString.FORMAT.CORNER_RIGHT_BOTTOM) {
                if (width > 1) {
                    --width;
                    this.setTopBorder(cell);
                    if (plainText == null) {
                        this.emptyCell(cell, startPosition);
                    }
                } else {
                    width = -1;
                }
            } else if (format == BMLString.FORMAT.CORNER_LEFT_AND_RIGHT_TOP) {
                --width;
                this.setLeftBorder(cell);
                this.setRightBorder(cell);
                this.setTopBorder(cell);
                if (plainText == null) {
                    this.emptyCell(cell, startPosition);
                }
            } else if (format == BMLString.FORMAT.CORNER_LEFT_AND_RIGHT_BOTTOM) {
                --width;
                this.setTopBorder(cell);
                if (plainText == null) {
                    this.emptyCell(cell, startPosition);
                }
            } else if (format == BMLString.FORMAT.NONE) {
                width = -1;
            }
        }
        return width;
    }

    private String name(int startPosition) {
        return "COL_" + startPosition + "_";
    }

    private void setTopBorder(CellHandle cell) throws SemanticException {
        cell.setProperty("borderTopColor", (Object)"#000000");
        cell.setProperty("borderTopStyle", (Object)"solid");
        cell.setProperty("borderTopWidth", (Object)"thin");
    }

    private void setBottomBorder(CellHandle cell) throws SemanticException {
        cell.setProperty("borderBottomColor", (Object)"#000000");
        cell.setProperty("borderBottomStyle", (Object)"solid");
        cell.setProperty("borderBottomWidth", (Object)"thin");
    }

    private void setLeftBorder(CellHandle cell) throws SemanticException {
        cell.setProperty("borderLeftColor", (Object)"#000000");
        cell.setProperty("borderLeftStyle", (Object)"solid");
        cell.setProperty("borderLeftWidth", (Object)"thin");
    }

    private void setRightBorder(CellHandle cell) throws SemanticException {
        cell.setProperty("borderRightColor", (Object)"#000000");
        cell.setProperty("borderRightStyle", (Object)"solid");
        cell.setProperty("borderRightWidth", (Object)"thin");
    }

    private TableHandle createTable() throws SemanticException {
        SortedSet<Integer> allPositions = this.getAllFieldPositions();
        int nPositions = allPositions.size();
        int nColumns = nPositions - 1;
        int headerLines = 0;
        int detailLines = 0;
        int footerLines = 0;
        TableHandle table = this.mElementFactory.newTableItem("tabledata", nColumns, headerLines, detailLines, footerLines);
        this.setPadding((ReportElementHandle)table);
        this.mReportDesignHandle.getBody().add((DesignElementHandle)table);
        return table;
    }
}

