/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Tab;
import com.itextpdf.layout.element.TabStop;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.properties.TabAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.layout.renderer.TabRenderer;
import com.ssaglobal.bml.Grid;
import java.util.ArrayList;
import java.util.List;

public class PDFTextWrap {
    public static final ArrayList<String> EMPTY = new ArrayList();
    public static final ArrayList<String> MONO = new ArrayList();
    public static final ArrayList<String> BOLD = new ArrayList();
    public static final ArrayList<String> MONO_BOLD = new ArrayList();

    static {
        MONO.add("Mono");
        BOLD.add("Bold");
        MONO_BOLD.add("Mono");
        MONO_BOLD.add("Bold");
    }

    public static class TabStopParagraph
    extends Paragraph {
        private Grid.SizedFont m_font;
        private ParagraphRenderer m_renderer;

        TabStopParagraph(String text, Grid.SizedFont f) {
            this.m_font = f;
            if (text.indexOf("\t") != -1) {
                boolean monospace;
                boolean bl = monospace = f.getWidth("i") == f.getWidth("W");
                if (monospace) {
                    text = this.replaceTabs(text, 8);
                } else {
                    float tabWidth;
                    float pos = tabWidth = 8.0f * f.getWidth(" ");
                    ArrayList<TabStop> stops = new ArrayList<TabStop>();
                    stops.add(new TabStop(pos, TabAlignment.LEFT));
                    for (int i = 1; i < 20; ++i) {
                        stops.add(new TabStop(pos += tabWidth, TabAlignment.LEFT));
                    }
                    this.addTabStops(stops);
                }
            }
            if (this.m_font.getFont() != null) {
                this.setFont(this.m_font.getFont());
            }
            this.setFontSize(this.m_font.getSize());
            if (this.m_font.isUnderline()) {
                this.setUnderline();
            }
            if (this.m_font.isItalic()) {
                this.setItalic();
            }
            if (this.m_font.getColor() != null) {
                this.setFontColor(this.m_font.getColor());
            }
            this.setText(text);
            this.m_renderer = new ParagraphRenderer((Paragraph)this);
            this.setNextRenderer((IRenderer)this.m_renderer);
        }

        private boolean fontIsBold(PdfFont font) {
            if (font == null) {
                return false;
            }
            if (font.getPdfObject() == null) {
                return false;
            }
            if (((PdfDictionary)font.getPdfObject()).getAsBoolean(new PdfName("is-bold")) == null) {
                return false;
            }
            return ((PdfDictionary)font.getPdfObject()).getAsBool(new PdfName("is-bold"));
        }

        private void checkBold(PdfFont font, Text text) {
            if (this.m_font.isBold() && !this.fontIsBold(font)) {
                text.setBold();
            }
        }

        private void setText(String txt) {
            String[] lines = txt.split("\t");
            for (int i = 0; i < lines.length; ++i) {
                if (this.m_font.getProvider() == null) {
                    Text text = new Text(lines[i]);
                    this.checkBold(this.m_font.getFont(), text);
                    this.add((ILeafElement)text);
                } else {
                    List nextGlyphs;
                    int nrOfGlyphs;
                    String currentSubsString = lines[i];
                    FontSelectorStrategy strategy = this.m_font.getProvider().getStrategy(currentSubsString, this.m_font.getFamilies());
                    while ((nrOfGlyphs = (nextGlyphs = strategy.nextGlyphs()).size()) > 0) {
                        PdfFont nextFont = strategy.getCurrentFont();
                        Text nextText = new Text(currentSubsString.substring(0, nrOfGlyphs));
                        nextText.setFont(nextFont);
                        this.checkBold(nextFont, nextText);
                        this.add((ILeafElement)nextText);
                        currentSubsString = currentSubsString.substring(nrOfGlyphs);
                    }
                }
                if (i == lines.length - 1) continue;
                this.add((ILeafElement)new Tab());
            }
        }

        private String replaceTabs(String s, int n) {
            if (s == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            String[] lines = s.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int index = line.indexOf("\t");
                while (index != -1) {
                    int nspaces = n - index % n;
                    line = line.substring(0, index) + this.spaces(nspaces) + line.substring(index + 1);
                    index = line.indexOf("\t");
                }
                result.append(line);
                if (i == lines.length - 1) continue;
                result.append("\n");
            }
            return result.toString();
        }

        private String spaces(int n) {
            String s = "                                         ";
            return s.substring(0, n);
        }

        public String toString() {
            List lines = this.m_renderer.getLines();
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < lines.size(); ++i) {
                if (i != 0) {
                    s.append("\n");
                }
                LineRenderer line = (LineRenderer)lines.get(i);
                List elems = line.getChildRenderers();
                for (int j = 0; j < elems.size(); ++j) {
                    IRenderer elem = (IRenderer)elems.get(j);
                    if (elem instanceof TabRenderer) {
                        s.append("\t");
                        continue;
                    }
                    s.append(elem.toString());
                }
            }
            return s.toString();
        }
    }
}

