/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import com.ssaglobal.bml.PDFTextWrap;
import com.ssaglobal.bml.Style;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Grid {
    private ArrayList<TextBlock> m_textBlocks = new ArrayList();
    private ArrayList<Line> m_lines = new ArrayList();
    private ArrayList<ImageBlock> m_bgImages = new ArrayList();
    private ArrayList<ImageBlock> m_images = new ArrayList();
    private float[] m_cellStartPosX = new float[1000];
    private float[] m_cellWidths = new float[1000];
    private int m_width;
    private int m_originalWidth;
    private float m_charWidth;
    private float m_charHeight;
    private float m_pageWidth;
    private float m_pageHeight;
    private float m_leftMargin;
    private float m_rightMargin;
    private Color m_lineColor;
    private boolean m_debug;
    private boolean m_bidi;
    private boolean m_monospaced;
    private boolean m_dynamicCols;
    private float m_startYPix = 0.0f;
    private float m_endYPix = 100000.0f;
    private boolean m_cellWidthsSet = false;
    private float m_originalFontSize = -1.0f;
    private float m_fontSize = -1.0f;
    private float m_fontSizeFactor;
    private float m_factor;
    private boolean m_justify;
    private float m_currentYPos = -1.0f;
    private Document m_document;
    public static final float MIN_LINE_THICKNESS = 0.3f;

    public Grid(Document doc, float pageWidth, float pageHeight, float leftMargin, float rightMargin, Color lineColor, boolean bidi, boolean monospaced, boolean debug, float fontSize, float ypos) {
        this.m_document = doc;
        this.m_width = -1;
        this.m_originalWidth = -1;
        this.m_charWidth = -1.0f;
        this.m_charHeight = -1.0f;
        this.m_pageWidth = pageWidth;
        this.m_pageHeight = pageHeight;
        this.m_leftMargin = leftMargin;
        this.m_rightMargin = rightMargin;
        this.m_lineColor = lineColor;
        this.m_bidi = bidi;
        this.m_debug = debug;
        this.m_dynamicCols = false;
        this.m_monospaced = monospaced;
        this.m_fontSize = fontSize;
        this.m_originalFontSize = fontSize;
        this.m_fontSizeFactor = -1.0f;
        this.m_justify = false;
        this.m_currentYPos = ypos;
    }

    public Grid(Document doc, int numberOfCharacters, float charWidth, float charHeight, float pageWidth, float leftMargin, float rightMargin, Color lineColor, boolean bidi, boolean dynamicCols, boolean monospaced, boolean debug, float[] cellWidths, float originalFontSize, float fontSize, float fsf, boolean justify) {
        this.m_document = doc;
        this.m_width = numberOfCharacters;
        this.m_originalWidth = numberOfCharacters;
        this.m_charWidth = charWidth;
        this.m_charHeight = charHeight;
        this.m_pageWidth = pageWidth;
        this.m_leftMargin = leftMargin;
        this.m_rightMargin = rightMargin;
        this.m_lineColor = lineColor;
        this.m_bidi = bidi;
        this.m_debug = debug;
        this.m_dynamicCols = dynamicCols;
        this.m_monospaced = monospaced;
        if (cellWidths != null) {
            this.m_cellWidths = (float[])cellWidths.clone();
            this.m_cellWidthsSet = true;
        }
        this.m_fontSize = fontSize > 0.0f ? fontSize : originalFontSize;
        this.m_originalFontSize = originalFontSize;
        this.m_fontSizeFactor = fsf;
        this.m_justify = justify;
    }

    public void addTextBlock(TextBlock tb) {
        this.m_textBlocks.add(tb);
    }

    public void addLine(Line l) {
        this.m_lines.add(l);
    }

    public void addImage(ImageBlock i, boolean background) {
        if (background) {
            this.m_bgImages.add(i);
        } else {
            this.m_images.add(i);
        }
    }

    private void setCellWidth(int a_x, float a_width) {
        if (this.m_cellWidths[a_x] < a_width) {
            this.m_cellWidths[a_x] = a_width;
        }
    }

    private void calcCellDimension(Block block) {
        float w = 0.0f;
        for (int j = 0; j < block.getWidth(); ++j) {
            w += this.m_cellWidths[block.getX() + j];
        }
        float prefWidth = block.getPreferredWidth();
        if (prefWidth > w) {
            float newCellWidth = 1.0f * prefWidth / (1.0f * (float)block.getWidth());
            float ok = 0.0f;
            int numberOfTooSmallColumns = 0;
            for (int j = 0; j < block.getWidth(); ++j) {
                if (this.m_cellWidths[block.getX() + j] >= newCellWidth) {
                    ok += this.m_cellWidths[block.getX() + j];
                    continue;
                }
                ++numberOfTooSmallColumns;
            }
            if (numberOfTooSmallColumns > 0) {
                float newCellWidth2 = 1.0f * (prefWidth - ok) / (1.0f * (float)numberOfTooSmallColumns);
                for (int j = 0; j < block.getWidth(); ++j) {
                    if (!(this.m_cellWidths[block.getX() + j] < newCellWidth)) continue;
                    this.setCellWidth(block.getX() + j, newCellWidth2);
                }
            }
        }
    }

    private void calcCellDimensions(PdfCanvas content) {
        if (this.m_dynamicCols) {
            int i;
            Collections.sort(this.m_textBlocks);
            if (!this.m_cellWidthsSet) {
                for (i = 0; i <= this.m_width; ++i) {
                    this.m_cellWidths[i] = 0.0f;
                }
            }
            for (i = 0; i < this.m_textBlocks.size(); ++i) {
                this.calcCellDimension(this.m_textBlocks.get(i));
            }
        } else {
            for (int i = 0; i < this.m_width; ++i) {
                this.m_cellWidths[i] = this.m_charWidth;
            }
            this.m_cellWidths[this.m_width] = 0.0f;
        }
    }

    private void fillStartPosX(PdfCanvas content) {
        if (this.m_width == -1) {
            return;
        }
        float currentWidth = 0.0f;
        for (int i = 0; i < this.m_width; ++i) {
            currentWidth += this.m_cellWidths[i];
        }
        float wantedWidth = this.m_pageWidth - this.m_leftMargin - this.m_rightMargin;
        this.m_factor = wantedWidth / currentWidth;
        if (this.m_justify && !(Math.abs(this.m_factor - 1.0f) < 0.001f)) {
            if (this.m_factor < 1.0f) {
                int i;
                if (this.m_originalFontSize * this.m_factor < this.m_fontSize) {
                    this.m_fontSize = this.m_originalFontSize * this.m_factor;
                }
                for (i = 0; i < this.m_width; ++i) {
                    this.m_cellWidths[i] = this.m_cellWidths[i] * this.m_factor;
                }
                for (i = 0; i < this.m_textBlocks.size(); ++i) {
                    TextBlock ww = this.m_textBlocks.get(i);
                    ww.adjustFontSize(ww.pdfFont, this.m_fontSize);
                }
            } else {
                float f = this.getFraction();
                float bound = f * this.m_charWidth;
                for (int i = 0; i < this.m_width; ++i) {
                    if (!(this.m_cellWidths[i] < bound)) continue;
                    this.m_cellWidths[i] = bound;
                }
            }
        }
        float pos = this.m_leftMargin;
        for (int i = 0; i <= this.m_width; ++i) {
            this.m_cellStartPosX[i] = pos;
            pos += this.m_cellWidths[i];
        }
    }

    private float getWidth(float fraction) {
        float w = 0.0f;
        float bound = fraction * this.m_charWidth;
        for (int i = 0; i < this.m_width; ++i) {
            if (this.m_cellWidths[i] < bound) {
                w += bound;
                continue;
            }
            w += this.m_cellWidths[i];
        }
        return w;
    }

    private float getFraction() {
        float x = 1.0f;
        float fx = this.f(x);
        int count = 1;
        while (Math.abs(fx) > 1.0f && count < 20) {
            float fxdx;
            float gx;
            if (count != 1) {
                fx = this.f(x);
            }
            if ((double)Math.abs(gx = ((fxdx = this.f(x + 0.01f)) - fx) / 0.01f) < 0.01) {
                count = 20;
                continue;
            }
            x -= fx / gx;
            ++count;
        }
        if (count == 20) {
            x = 1.0f;
        }
        return x;
    }

    private float f(float x) {
        return this.getWidth(x) - this.m_pageWidth + this.m_leftMargin + this.m_rightMargin;
    }

    public void calculateCellDimensions(PdfCanvas content) {
        this.calcCellDimensions(content);
    }

    public void write(PdfCanvas content, boolean calcCellDimensions) {
        Block ww;
        int i;
        if (calcCellDimensions && this.m_width > 0) {
            this.calcCellDimensions(content);
        }
        this.fillStartPosX(content);
        if (this.m_debug && this.m_width > 0) {
            content.setLineWidth(0.0f);
            content.setStrokeColor((Color)new DeviceRgb(230, 230, 230));
            for (int i2 = 0; i2 <= this.m_width; ++i2) {
                float xPix = this.m_cellStartPosX[i2];
                content.moveTo((double)xPix, (double)(this.m_startYPix - 5.0f));
                content.lineTo((double)xPix, (double)this.m_endYPix);
                content.stroke();
            }
        }
        int ncomponents = this.m_textBlocks.size();
        for (i = 0; i < this.m_bgImages.size(); ++i) {
            ww = this.m_bgImages.get(i);
            this.write(content, ww, false, false);
        }
        for (i = 0; i < this.m_lines.size(); ++i) {
            ww = this.m_lines.get(i);
            this.write(content, ww, false, true);
        }
        for (i = 0; i < ncomponents; ++i) {
            ww = this.m_textBlocks.get(i);
            this.write(content, ww, false, true);
        }
        for (i = 0; i < ncomponents; ++i) {
            ww = this.m_textBlocks.get(i);
            this.write(content, ww, false, false);
        }
        for (i = 0; i < this.m_lines.size(); ++i) {
            ww = this.m_lines.get(i);
            this.write(content, ww, false, false);
        }
        for (i = 0; i < this.m_images.size(); ++i) {
            ww = this.m_images.get(i);
            this.write(content, ww, false, false);
        }
        if (this.m_debug) {
            for (i = 0; i < ncomponents; ++i) {
                ww = this.m_textBlocks.get(i);
                this.write(content, ww, true, false);
            }
        }
    }

    private void write(PdfCanvas content, Block block, boolean debugExtra, boolean writeBackground) {
        try {
            boolean exactPos;
            boolean bl = exactPos = block.style != null && block.style.getExactPosData() != null;
            if (!exactPos) {
                float x;
                block.xPix = x = this.m_cellStartPosX[block.getX()];
                if (block.getWidth() >= 0) {
                    float w;
                    block.widthPix = w = this.m_cellStartPosX[block.getX() + block.getWidth()] - x;
                }
            }
            if (this.m_bidi) {
                block.xPix = this.m_pageWidth - block.xPix - block.widthPix;
            }
            if (writeBackground) {
                block.writeBackground(content, debugExtra, block.heightPix, ColorConstants.CYAN);
            } else {
                block.write(content, debugExtra, block.heightPix, ColorConstants.CYAN);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public float[] getCellWidths() {
        return this.m_cellWidths;
    }

    public int getWidth() {
        return this.m_originalWidth;
    }

    public float getFontSize() {
        return this.m_fontSize;
    }

    public boolean getJustify() {
        return this.m_justify;
    }

    public void setCurrentYPos(float ypos) {
        this.m_currentYPos = ypos;
    }

    public class ImageBlock
    extends Block {
        private Image m_image;
        private int m_heightInLines;
        private boolean m_scaleInHeight;
        private boolean m_useExtraSpace;
        private int m_halign;
        private int m_valign;
        private String m_signatureId;

        public ImageBlock(int x, float y, int width, int heightInLines, Image image, boolean scaleInHeight, boolean useExtraSpace, int halign, int valign, Style style, String signatureId) {
            super(x, y, width, style);
            if (style != null && style.getExactPosData() != null) {
                this.m_heightInLines = -1;
                this.m_useExtraSpace = false;
            } else {
                this.prefWidthPix = (float)width * Grid.this.m_charWidth;
                this.m_heightInLines = heightInLines;
                this.m_useExtraSpace = useExtraSpace;
            }
            this.m_image = image;
            this.m_scaleInHeight = scaleInHeight;
            this.m_halign = halign;
            this.m_valign = valign;
            this.m_signatureId = signatureId;
        }

        @Override
        protected void write(PdfCanvas content, boolean debugExtra, float h, Color color) throws IOException {
            if (this.m_signatureId != null) {
                float height = (float)this.m_heightInLines * Grid.this.m_charHeight;
                if (this.m_heightInLines == -1) {
                    height = this.heightPix;
                }
                float width = this.widthPix;
                float x = this.xPix;
                float y = this.yPix;
                PdfSignatureFormField formField = PdfFormField.createSignature((PdfDocument)Grid.this.m_document.getPdfDocument(), (Rectangle)new Rectangle(x, y - height, width, height));
                formField.setFieldName(this.m_signatureId);
                formField.setFieldFlags(4);
                formField.setBorderColor(ColorConstants.BLACK);
                formField.setPage(Grid.this.m_document.getPdfDocument().getPageNumber(Grid.this.m_document.getPdfDocument().getLastPage()));
                PdfAcroForm form = PdfAcroForm.getAcroForm((PdfDocument)Grid.this.m_document.getPdfDocument(), (boolean)true);
                form.addField((PdfFormField)formField, Grid.this.m_document.getPdfDocument().getLastPage());
                super.write(content, debugExtra, height, ColorConstants.BLUE);
            }
            if (this.m_image != null) {
                float dy = 1.0f;
                if (this.m_useExtraSpace) {
                    dy = -5.0f;
                }
                if (this.m_heightInLines == -1) {
                    dy = 0.0f;
                }
                float height = (float)this.m_heightInLines * Grid.this.m_charHeight - 2.0f * dy;
                if (this.m_heightInLines == -1) {
                    height = this.heightPix;
                }
                float factor = height / this.m_image.getImageHeight();
                if (!this.m_scaleInHeight) {
                    float factor2 = this.widthPix / this.m_image.getImageWidth();
                    factor = Math.min(factor, factor2);
                }
                float realHeight = this.m_image.getImageHeight() * factor;
                float realWidth = this.m_image.getImageWidth() * factor;
                if (realWidth > this.prefWidthPix && (this.style == null || this.style.isPreserveRatio())) {
                    factor = factor * this.prefWidthPix / realWidth;
                    realHeight = realHeight * this.prefWidthPix / realWidth;
                }
                float x = this.xPix;
                float y = this.yPix - realHeight - dy;
                x = this.m_halign == 0 ? this.xPix : (this.m_halign == 1 ? this.xPix + 0.5f * (this.widthPix - realWidth) : this.xPix + this.widthPix - realWidth);
                y = this.m_valign == 0 ? this.yPix - realHeight - dy : (this.m_valign == 1 ? this.yPix - realHeight - dy - 0.5f * (height - realHeight) : this.yPix - dy - height);
                if (this.style != null && !this.style.isPreserveRatio()) {
                    this.m_image.scaleAbsolute(this.widthPix, height);
                    x = this.xPix;
                    y = this.yPix - height;
                } else {
                    this.m_image.scale(factor, factor);
                }
                this.m_image.setFixedPosition(x, y);
                Canvas c = new Canvas(content, (Rectangle)new PageSize(Grid.this.m_pageWidth, Grid.this.m_pageHeight));
                c.add(this.m_image);
                c.close();
                super.write(content, debugExtra, height, ColorConstants.BLUE);
            }
        }
    }

    public class Line
    extends Block {
        private int type;

        public Line(int x, float y, int width, int type, Style style) {
            super(x, y, width, style);
            this.type = type;
            this.prefWidthPix = 0.0f;
        }

        @Override
        public Color getBackgroundColor() {
            if (this.isRealLine() && this.style != null && this.style.getLineBgColor() != null) {
                return this.style.getLineBgColor();
            }
            if (this.isRealLine() && this.style != null && this.style.hasBgColorFromStyle()) {
                return null;
            }
            return super.getBackgroundColor();
        }

        @Override
        public Color getForegroundColor() {
            if (this.isRealLine() && this.style != null && this.style.getLineFgColor() != null) {
                return this.style.getLineFgColor();
            }
            if (this.isRealLine() && this.style != null && this.style.hasFgColorFromStyle()) {
                return null;
            }
            return super.getForegroundColor();
        }

        private boolean isRealLine() {
            return this.type > 0 && this.type < 13;
        }

        @Override
        protected void write(PdfCanvas content, boolean debugExtra, float height, Color color) throws IOException {
            super.write(content, debugExtra, height, color);
            content.saveState();
            if (this.getForegroundColor() != null) {
                content.setStrokeColor(this.getForegroundColor());
            } else {
                content.setStrokeColor(Grid.this.m_lineColor);
            }
            this.setLineStyle(content, this.getLineStyle(), (float)this.getThickness());
            content.setLineWidth((float)this.getThickness());
            float halfThickness = (float)(0.5 * this.getThickness());
            float x = this.xPix;
            float y = this.yPix;
            if (this.type == 1 || this.type == 9 || this.type == 10 || this.type == 11) {
                content.moveTo((double)x, (double)(y - 0.5f * this.heightPix));
                content.lineTo((double)(x + this.widthPix), (double)(y - 0.5f * this.heightPix));
            }
            if (this.type == 4 || this.type == 6 || this.type == 8) {
                content.moveTo((double)x, (double)(y - 0.5f * this.heightPix));
                content.lineTo((double)(x + 0.5f * this.widthPix + halfThickness), (double)(y - 0.5f * this.heightPix));
            }
            if (this.type == 3 || this.type == 5 || this.type == 7) {
                content.moveTo((double)(x + 0.5f * this.widthPix - halfThickness), (double)(y - 0.5f * this.heightPix));
                content.lineTo((double)(x + this.widthPix), (double)(y - 0.5f * this.heightPix));
            }
            if (this.type == 2 || this.type == 7 || this.type == 8 || this.type == 11) {
                content.moveTo((double)(x + 0.5f * this.widthPix), (double)y);
                content.lineTo((double)(x + 0.5f * this.widthPix), (double)(y - this.heightPix));
            }
            if (this.type == 5 || this.type == 6 || this.type == 10) {
                content.moveTo((double)(x + 0.5f * this.widthPix), (double)y);
                content.lineTo((double)(x + 0.5f * this.widthPix), (double)(y - 0.5f * this.heightPix - halfThickness));
            }
            if (this.type == 3 || this.type == 4 || this.type == 9) {
                content.moveTo((double)(x + 0.5f * this.widthPix), (double)(y - 0.5f * this.heightPix - halfThickness));
                content.lineTo((double)(x + 0.5f * this.widthPix), (double)(y - this.heightPix));
            }
            if (this.type == 12) {
                content.moveTo((double)x, (double)(y - 0.45f * this.heightPix));
                content.lineTo((double)(x + this.widthPix), (double)(y - 0.45f * this.heightPix));
                content.moveTo((double)x, (double)(y - 0.55f * this.heightPix));
                content.lineTo((double)(x + this.widthPix), (double)(y - 0.55f * this.heightPix));
            }
            content.stroke();
            content.restoreState();
        }
    }

    public class TextBlock
    extends Block {
        int align;
        float rotation;
        BaseDirection runDirection;
        int arabicOptions;
        String font;
        String txt;
        SizedFont pdfFont;

        public TextBlock(int align, String txt, SizedFont font, int x, float y, float rotation, BaseDirection runDirection, int width, String fontString, Style style) {
            float textWidth;
            super(x, y, width, style);
            if (x + width > 1000) {
                txt = txt.substring(0, 1000 - x - 1);
                width = txt.length();
            }
            this.align = align;
            this.rotation = rotation;
            this.runDirection = runDirection;
            this.font = fontString;
            this.pdfFont = font;
            if (txt.trim().isEmpty()) {
                txt = "";
            }
            if (!Grid.this.m_monospaced) {
                txt = this.trim(txt, align);
            }
            this.txt = this.replaceLeadingSpaces(txt);
            if (Grid.this.m_fontSize > 0.0f && !font.m_fixed) {
                this.pdfFont.m_size = Grid.this.m_fontSize;
            }
            this.prefWidthPix = style != null && style.getExactPosData() != null ? this.widthPix : (textWidth = font.getWidth(this.txt));
        }

        private String replaceLeadingSpaces(String s) {
            char[] value = s.toCharArray();
            int i = 0;
            while (i < value.length && value[i] == ' ') {
                value[i] = 160;
            }
            return new String(value);
        }

        private String trim(String s, int align) {
            int st;
            if (Grid.this.m_bidi) {
                if (align == 0) {
                    align = 2;
                } else if (align == 2) {
                    align = 0;
                }
            }
            char[] value = s.toCharArray();
            int len = value.length;
            char[] val = value;
            if (align == 1 || align == 2) {
                for (st = 0; st < len && val[st] == ' '; ++st) {
                }
            }
            if (align == 1 || align == 0) {
                while (st < len && val[len - 1] == ' ') {
                    --len;
                }
            }
            return st > 0 || len < value.length ? s.substring(st, len) : s;
        }

        @Override
        protected void write(PdfCanvas content, boolean debugExtra, float height, Color color) throws IOException {
            super.write(content, debugExtra, height, color);
            content.setStrokeColor(ColorConstants.BLACK);
            content.setLineWidth(0.0f);
            if (this.style != null && this.style.getExactPosData() != null) {
                int maxLines = this.style.getExactPosData().getMaxLines();
                if (maxLines < 1) {
                    maxLines = 1;
                }
                VerticalAlignment valign = VerticalAlignment.TOP;
                if (this.style != null && this.style.getExactPosData() != null) {
                    if (this.style.getExactPosData().getVAlign() == 0) {
                        valign = VerticalAlignment.TOP;
                    } else if (this.style.getExactPosData().getVAlign() == 1) {
                        valign = VerticalAlignment.MIDDLE;
                    } else if (this.style.getExactPosData().getVAlign() == 2) {
                        valign = VerticalAlignment.BOTTOM;
                    }
                    if (this.style.getVAlign() != null) {
                        if (this.style.getVAlign() == 0) {
                            valign = VerticalAlignment.TOP;
                        } else if (this.style.getVAlign() == 1) {
                            valign = VerticalAlignment.MIDDLE;
                        } else if (this.style.getVAlign() == 2) {
                            valign = VerticalAlignment.BOTTOM;
                        }
                    }
                }
                this.showText(content, maxLines, valign, true);
            } else {
                this.showText(content, 1, VerticalAlignment.BOTTOM, false);
            }
        }

        private void showText(PdfCanvas canvas, int maxLines, VerticalAlignment valign, boolean autoWrap) {
            IRenderer renderer;
            LayoutResult result;
            boolean epMaxLines1;
            if (this.txt.length() == 0) {
                return;
            }
            PDFTextWrap.TabStopParagraph paragraph = new PDFTextWrap.TabStopParagraph(this.txt, this.pdfFont);
            float minW = this.pdfFont.getWidth("" + this.txt.charAt(0)) + 1.0f;
            this.widthPix = Math.max(this.widthPix, minW);
            float x = this.xPix;
            float y = this.yPix;
            float w = this.widthPix;
            float h = 1000.0f;
            boolean bl = epMaxLines1 = this.style != null && this.style.getExactPosData() != null && this.style.getExactPosData().getMaxLines() == 1;
            if (autoWrap && ((result = (renderer = paragraph.createRendererSubTree()).setParent((IRenderer)Grid.this.m_document.getRenderer()).layout(new LayoutContext(new LayoutArea(1, new Rectangle(this.widthPix, 1000.0f))))) == null || result.getOccupiedArea() == null || result.getOccupiedArea().getBBox() == null)) {
                autoWrap = false;
            }
            if (autoWrap) {
                paragraph.setMarginTop(0.1f * this.pdfFont.getSize());
                paragraph.setMarginBottom(0.0f);
            } else {
                paragraph.setMarginTop(0.0f);
                paragraph.setMarginBottom(0.0f);
                paragraph.setPaddingBottom(0.0f);
                paragraph.setPaddingTop(0.0f);
                paragraph.setFixedLeading(0.0f);
                h = 5.0f * this.heightPix;
                y = (float)((double)y + (4.1 * (double)this.heightPix + (double)(this.pdfFont.m_size / 2.0f)));
            }
            if (this.style != null && this.style.getExactPosData() != null) {
                paragraph.setMultipliedLeading(this.style.getExactPosData().getLeading() * 0.75f);
            }
            if (this.align == 0) {
                paragraph.setTextAlignment(TextAlignment.LEFT);
                if (!autoWrap || epMaxLines1) {
                    w += 1000.0f;
                }
            } else if (this.align == 1) {
                paragraph.setTextAlignment(TextAlignment.CENTER);
                if (!autoWrap || epMaxLines1) {
                    x -= 500.0f;
                    w += 1000.0f;
                }
            } else if (this.align == 2) {
                paragraph.setTextAlignment(TextAlignment.RIGHT);
                if (!autoWrap || epMaxLines1) {
                    x -= 1000.0f;
                    w += 1000.0f;
                }
            }
            paragraph.setWidth(w);
            if (autoWrap) {
                renderer = paragraph.createRendererSubTree();
                result = renderer.setParent((IRenderer)Grid.this.m_document.getRenderer()).layout(new LayoutContext(new LayoutArea(1, new Rectangle(w, 1000.0f))));
                float height = result.getOccupiedArea().getBBox().getHeight();
                String[] lines = paragraph.toString().split("\n");
                int nLines = lines.length;
                float heightPerLine = height / (float)nLines;
                float maxHeight = (float)maxLines * heightPerLine;
                if (nLines > maxLines && !epMaxLines1) {
                    String newTxt = "";
                    for (int i = 0; i < maxLines; ++i) {
                        newTxt = newTxt + lines[i] + "\n";
                    }
                    paragraph = new PDFTextWrap.TabStopParagraph(newTxt, this.pdfFont);
                    paragraph.setMarginTop(0.1f * this.pdfFont.getSize());
                    paragraph.setMarginBottom(0.0f);
                    if (this.style != null && this.style.getExactPosData() != null) {
                        paragraph.setMultipliedLeading(this.style.getExactPosData().getLeading() * 0.75f);
                    }
                    if (this.align == 0) {
                        paragraph.setTextAlignment(TextAlignment.LEFT);
                    } else if (this.align == 1) {
                        paragraph.setTextAlignment(TextAlignment.CENTER);
                    } else if (this.align == 2) {
                        paragraph.setTextAlignment(TextAlignment.RIGHT);
                    }
                    paragraph.setWidth(w);
                }
                if (valign == VerticalAlignment.MIDDLE) {
                    y = (float)((double)y + 0.5 * (double)(maxHeight - this.heightPix));
                } else if (valign == VerticalAlignment.BOTTOM) {
                    y += maxHeight - this.heightPix;
                }
            }
            Rectangle rect = new Rectangle(x, y - h, w, h);
            Canvas c = new Canvas(canvas, rect);
            if (autoWrap) {
                c.add((IBlockElement)paragraph);
            } else {
                Div div = new Div();
                div.setHeight(h);
                div.setVerticalAlignment(VerticalAlignment.BOTTOM);
                div.add((IBlockElement)paragraph);
                c.add((IBlockElement)div);
            }
            c.close();
        }

        public void adjustFontSize(SizedFont font, float fontSize) {
            if (!font.m_fixed) {
                font.m_size = fontSize;
            }
        }
    }

    public class Block
    implements Comparable<Block> {
        int x;
        int width;
        float yPix;
        float prefWidthPix;
        float xPix;
        float widthPix;
        float heightPix;
        Style style;

        public Block(int x, float y, int width, Style style) {
            if (x + width > 1000) {
                width = 1000 - x - 1;
            }
            this.style = style;
            if (style != null && style.getExactPosData() != null) {
                this.x = -1;
                this.width = -1;
                this.xPix = style.getExactPosData().getXpos() + Grid.this.m_leftMargin;
                this.yPix = style.getExactPosData().getYpos() + Grid.this.m_currentYPos;
                this.widthPix = style.getExactPosData().getWidth();
                this.heightPix = style.getExactPosData().getHeight();
                this.prefWidthPix = this.widthPix;
            } else {
                this.x = x - 1;
                this.yPix = y;
                this.width = width;
                this.heightPix = Grid.this.m_charHeight;
                if (style != null && style.getHeight() > 1) {
                    this.heightPix = (float)style.getHeight() * Grid.this.m_charHeight;
                }
                if (y > Grid.this.m_startYPix) {
                    Grid.this.m_startYPix = y;
                }
                if (y - this.heightPix < Grid.this.m_endYPix) {
                    Grid.this.m_endYPix = y - this.heightPix;
                }
                if (this.x + this.width > Grid.this.m_width) {
                    Grid.this.m_width = this.x + this.width;
                }
            }
        }

        protected void setLineStyle(PdfCanvas content, Style.BorderType lineStyle, float thickness) {
            if (lineStyle == Style.BorderType.dashed) {
                content.setLineDash(3.0f * thickness, 1.0f * thickness, 0.0f);
            } else if (lineStyle == Style.BorderType.dotted) {
                content.setLineDash(thickness, thickness, 0.0f);
            } else {
                content.setLineDash(thickness, 0.0f, 0.0f);
            }
        }

        @Override
        public int compareTo(Block b) {
            float s1 = b.width;
            float s2 = this.width;
            return (int)(s2 - s1);
        }

        public int getX() {
            return this.x;
        }

        public int getWidth() {
            return this.width;
        }

        public float getPreferredWidth() {
            return this.prefWidthPix;
        }

        public Color getForegroundColor() {
            return this.style == null ? null : this.style.getFgColor();
        }

        public double getThickness() {
            double thickness = this.style == null ? 0.0 : this.style.getThickness();
            thickness = Math.max((double)0.3f, thickness);
            return thickness;
        }

        public Style.BorderType getLineStyle() {
            return this.style == null ? Style.BorderType.solid : this.style.getLineStyle();
        }

        public Color getBackgroundColor() {
            return this.style == null ? null : this.style.getBgColor();
        }

        public Color getBackgroundColor1() {
            return this.style == null ? null : this.style.getBgColor1();
        }

        public Color getBackgroundColor2() {
            return this.style == null ? null : this.style.getBgColor2();
        }

        public Color getBackgroundColor3() {
            return this.style == null ? null : this.style.getBgColor3();
        }

        public Color getBackgroundColor4() {
            return this.style == null ? null : this.style.getBgColor4();
        }

        protected void writeBackground(PdfCanvas content, boolean debugExtra, float height, Color color) throws IOException {
            float w;
            float h;
            if (this.getBackgroundColor() != null) {
                content.setFillColor(this.getBackgroundColor());
                content.rectangle((double)this.xPix, (double)(this.yPix - height), (double)this.widthPix, (double)height);
                content.fill();
                content.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor1() != null) {
                h = 0.5f * height;
                w = 0.5f * this.widthPix;
                content.setFillColor(this.getBackgroundColor1());
                content.rectangle((double)this.xPix, (double)(this.yPix - h), (double)w, (double)h);
                content.fill();
                content.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor2() != null) {
                h = 0.5f * height;
                w = 0.5f * this.widthPix;
                content.setFillColor(this.getBackgroundColor2());
                content.rectangle((double)(this.xPix + w), (double)(this.yPix - h), (double)w, (double)h);
                content.fill();
                content.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor3() != null) {
                h = 0.5f * height;
                w = 0.5f * this.widthPix;
                content.setFillColor(this.getBackgroundColor3());
                content.rectangle((double)(this.xPix + w), (double)(this.yPix - height), (double)w, (double)h);
                content.fill();
                content.setFillColor(ColorConstants.BLACK);
            }
            if (this.getBackgroundColor4() != null) {
                h = 0.5f * height;
                w = 0.5f * this.widthPix;
                content.setFillColor(this.getBackgroundColor4());
                content.rectangle((double)this.xPix, (double)(this.yPix - height), (double)w, (double)h);
                content.fill();
                content.setFillColor(ColorConstants.BLACK);
            }
        }

        private void writeBorder(PdfCanvas content, Style.Border b, float x0, float y0, float x1, float y1) {
            float thickness = Math.max(0.3f, (float)b.getThickness());
            this.setLineStyle(content, b.getType(), thickness);
            content.setStrokeColor(b.getColor());
            content.setLineWidth(thickness);
            content.moveTo((double)x0, (double)y0);
            content.lineTo((double)x1, (double)y1);
            content.stroke();
        }

        protected void write(PdfCanvas content, boolean debugExtra, float height, Color color) throws IOException {
            if (this.style != null) {
                float y1;
                float y0;
                float h;
                float d;
                content.saveState();
                if (this.style.getBorderLeft() != null) {
                    d = (float)this.style.getBorderLeft().getThickness();
                    h = 0.5f * d;
                    y0 = this.yPix - height;
                    y1 = this.yPix;
                    if (this.style.getBorderTop() != null) {
                        y1 = this.yPix + d;
                    }
                    if (this.style.getBorderBottom() != null) {
                        y0 = this.yPix - height - d;
                    }
                    this.writeBorder(content, this.style.getBorderLeft(), this.xPix - h, y0, this.xPix - h, y1);
                }
                if (this.style.getBorderTop() != null) {
                    d = (float)this.style.getBorderTop().getThickness();
                    h = 0.5f * d;
                    this.writeBorder(content, this.style.getBorderTop(), this.xPix, this.yPix + h, this.xPix + this.widthPix, this.yPix + h);
                }
                if (this.style.getBorderRight() != null) {
                    d = (float)this.style.getBorderRight().getThickness();
                    h = 0.5f * d;
                    y0 = this.yPix - height;
                    y1 = this.yPix;
                    if (this.style.getBorderTop() != null) {
                        y1 = this.yPix + d;
                    }
                    if (this.style.getBorderBottom() != null) {
                        y0 = this.yPix - height - d;
                    }
                    this.writeBorder(content, this.style.getBorderRight(), this.xPix + this.widthPix + h, y0, this.xPix + this.widthPix + h, y1);
                }
                if (this.style.getBorderBottom() != null) {
                    d = (float)this.style.getBorderBottom().getThickness();
                    h = 0.5f * d;
                    this.writeBorder(content, this.style.getBorderBottom(), this.xPix, this.yPix - height - h, this.xPix + this.widthPix, this.yPix - height - h);
                }
                content.restoreState();
            }
            if (Grid.this.m_debug) {
                float w = this.widthPix;
                content.setStrokeColor(color);
                content.setLineWidth(0.0f);
                float dx = 0.2f;
                float dy = 0.2f;
                if (this instanceof ImageBlock) {
                    dx = -0.5f;
                    dy = -0.5f;
                }
                if (debugExtra) {
                    if (this.prefWidthPix > this.widthPix + 1.0f) {
                        dy = 0.5f;
                        dx = 0.3f;
                        Color c = ColorConstants.RED;
                        content.setStrokeColor(c);
                        w = this.prefWidthPix;
                    } else {
                        return;
                    }
                }
                content.moveTo((double)(this.xPix + dx), (double)(this.yPix - dy));
                content.lineTo((double)(this.xPix - dx + w), (double)(this.yPix - dy));
                content.lineTo((double)(this.xPix - dx + w), (double)(this.yPix + dy - height));
                content.lineTo((double)(this.xPix + dx), (double)(this.yPix + dy - height));
                content.lineTo((double)(this.xPix + dx), (double)(this.yPix - dy));
                content.stroke();
            }
        }
    }

    public static class SizedFont {
        private PdfFont m_font;
        private FontProvider m_provider;
        private float m_size;
        private boolean m_fixed;
        private boolean m_monospace;
        private boolean m_bold = false;
        private boolean m_underline = false;
        private boolean m_italic = false;
        private Color m_color;

        public SizedFont(SizedFont font, float size, boolean fixed, boolean monospace, boolean bold) {
            this.m_font = font.m_font;
            this.m_provider = font.m_provider;
            this.m_size = size;
            this.m_fixed = fixed;
            this.m_monospace = monospace;
            this.m_bold = bold;
        }

        public SizedFont(PdfFont font, float size, boolean fixed, boolean monospace, boolean bold) {
            this.m_font = font;
            this.m_size = size;
            this.m_fixed = fixed;
            this.m_monospace = monospace;
            this.m_bold = bold;
        }

        public SizedFont(FontProvider provider, float size, boolean fixed, boolean monospace, boolean bold) {
            this.m_provider = provider;
            this.m_size = size;
            this.m_fixed = fixed;
            this.m_monospace = monospace;
            this.m_bold = bold;
        }

        public void setUnderline(boolean ul) {
            this.m_underline = ul;
        }

        public void setItalic(boolean italic) {
            this.m_italic = italic;
        }

        public void setColor(Color color) {
            this.m_color = color;
        }

        public Color getColor() {
            return this.m_color;
        }

        public float getWidth(String txt) {
            List nextGlyphs;
            int nrOfGlyphs;
            if (this.getProvider() == null) {
                return this.m_font.getWidth(txt, this.m_size);
            }
            int w = 0;
            String currentSubsString = txt;
            FontSelectorStrategy strategy = this.getProvider().getStrategy(currentSubsString, this.getFamilies());
            while ((nrOfGlyphs = (nextGlyphs = strategy.nextGlyphs()).size()) > 0) {
                PdfFont nextFont = strategy.getCurrentFont();
                String sub = currentSubsString.substring(0, nrOfGlyphs);
                w = (int)((float)w + nextFont.getWidth(sub, this.m_size));
                currentSubsString = currentSubsString.substring(nrOfGlyphs);
            }
            return w;
        }

        public boolean isUnderline() {
            return this.m_underline;
        }

        public boolean isBold() {
            return this.m_bold;
        }

        public boolean isItalic() {
            return this.m_italic;
        }

        public boolean isMonospace() {
            return this.m_monospace;
        }

        public PdfFont getFont() {
            return this.m_font;
        }

        public FontProvider getProvider() {
            return this.m_provider;
        }

        public float getSize() {
            return this.m_size;
        }

        public ArrayList<String> getFamilies() {
            if (this.m_monospace && this.m_bold) {
                return PDFTextWrap.MONO_BOLD;
            }
            if (this.m_monospace) {
                return PDFTextWrap.MONO;
            }
            if (this.m_bold) {
                return PDFTextWrap.BOLD;
            }
            return PDFTextWrap.EMPTY;
        }
    }
}

