/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.util.HashMap;
import java.util.Iterator;

public class CellWidths {
    private HashMap<String, float[]> m_cellWidths = new HashMap();
    private HashMap<String, Float> m_fontSize = new HashMap();
    private boolean m_fitsOnPage = true;

    public void save(String key, float[] widths) {
        this.m_cellWidths.put(key, widths);
    }

    public float[] load(String key) {
        return this.m_cellWidths.get(key);
    }

    public float getFontSize(int width) {
        if (this.m_fontSize.containsKey(width)) {
            return this.m_fontSize.get(width).floatValue();
        }
        return -1.0f;
    }

    public void setFontSize(String key, float fontSize) {
        if (fontSize > 0.0f) {
            this.m_fontSize.put(key, Float.valueOf(fontSize));
        }
    }

    public boolean fitsOnPage(float pageWidth, float leftMargin, float rightMargin) {
        Iterator<float[]> iterator = this.m_cellWidths.values().iterator();
        while (iterator.hasNext()) {
            boolean fits = this.fitsOnPage(iterator.next(), pageWidth, leftMargin, rightMargin);
            if (fits) continue;
            this.m_fitsOnPage = false;
            return false;
        }
        return true;
    }

    public boolean fitsOnPage(float[] widths, float pageWidth, float leftMargin, float rightMargin) {
        float currentWidth = 0.0f;
        for (int i = 0; i < widths.length; ++i) {
            currentWidth += widths[i];
        }
        float wantedWidth = pageWidth - leftMargin - rightMargin;
        float factor = wantedWidth / currentWidth;
        boolean fits = factor >= 1.0f;
        return fits;
    }

    public void clear() {
        this.m_cellWidths.clear();
    }

    public boolean fitsOnPage() {
        return this.m_fitsOnPage;
    }
}

