/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2HTML;
import com.ssaglobal.bml.Style;

public class CellLayout
implements Comparable<CellLayout>,
Cloneable {
    private int m_col;
    private int m_width;
    private String m_text;
    private Style m_style;
    private Style m_backup;
    private BML2HTML.BarCode m_barCode;

    public CellLayout(int col, int width) {
        this.m_col = col;
        this.m_width = width;
    }

    @Override
    public int compareTo(CellLayout cell) {
        return this.m_col - cell.m_col;
    }

    public CellLayout copy() {
        try {
            return (CellLayout)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "[col=" + this.m_col + "; width=" + this.m_width + "; text=" + this.m_text + "]";
    }

    public int getCol() {
        return this.m_col;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setWidth(int w) {
        this.m_width = w;
    }

    public void setText(String txt) {
        this.m_text = txt;
    }

    public boolean hasText() {
        return this.m_text != null && !this.m_text.isEmpty();
    }

    public String getText() {
        return this.m_text;
    }

    public boolean canOverlap() {
        return false;
    }

    public boolean hasE() {
        return true;
    }

    public void setStyle(Style style) {
        this.m_style = style;
    }

    public Style getStyle() {
        return this.m_style;
    }

    public void backup() {
        if (this.m_style != null) {
            this.m_backup = this.m_style.copy();
        }
    }

    public void restore() {
        if (this.m_backup != null) {
            this.m_style = this.m_backup;
            this.m_backup = null;
        }
    }

    public boolean hasBgColor() {
        return this.m_style != null && this.m_style.hasBgColor();
    }

    public boolean hasSomeBorder() {
        return this.m_style != null && (this.m_style.getBorderLeft() != null || this.m_style.getBorderRight() != null || this.m_style.getBorderTop() != null || this.m_style.getBorderBottom() != null);
    }

    public boolean isExpandable() {
        return !this.hasSomeBorder() && !this.hasBgColor();
    }

    public void setBarCode(BML2HTML.BarCode bc) {
        this.m_barCode = bc;
    }

    public BML2HTML.BarCode getBarCode() {
        return this.m_barCode;
    }
}

