/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BML2BIRTData;
import com.ssaglobal.bml.BML2BIRTDesign;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.birt.core.framework.Platform;

public class BML2BIRT {
    public static void main(String[] args) {
        String dir = ".";
        File d = new File(dir);
        File[] files = d.listFiles();
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            try {
                String bml;
                if (!file.getAbsolutePath().endsWith(".xml") || (bml = file.getAbsolutePath()).endsWith("_temp.xml") || bml.endsWith("_data.xml")) continue;
                String designFile = bml.substring(0, bml.length() - 4) + ".rptdesign";
                String dataFile = bml.substring(0, bml.length() - 4) + ".csv";
                String version = "28";
                String user = "";
                System.out.println("Converting " + designFile + "...");
                BML2BIRTDesign.convertBML(version, bml, designFile, "template.rptdesign");
                System.out.println("Converting " + dataFile + "...");
                BML2BIRTData.convertBML(user, version, bml, dataFile);
                System.out.println("Finished");
                continue;
            }
            catch (Throwable e) {
                System.out.println("Error converting: " + file.getAbsolutePath());
                e.printStackTrace();
            }
        }
        Platform.shutdown();
    }

    static String BML2String(String a_bmlFile) throws IOException {
        StringBuffer xml = new StringBuffer();
        FileInputStream fis = new FileInputStream(a_bmlFile);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        while (line != null) {
            xml.append(line);
            xml.append(System.getProperty("line.separator"));
            line = br.readLine();
        }
        br.close();
        isr.close();
        fis.close();
        String endtag = "</report>";
        int index = xml.lastIndexOf(endtag);
        if (index < 0) {
            xml.append(endtag);
            xml.append(System.getProperty("line.separator"));
        }
        while (xml.length() > 0 && xml.charAt(0) != '<') {
            xml = xml.deleteCharAt(0);
        }
        return xml.toString();
    }
}

