/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.NamespaceConstant;
import com.itextpdf.licensing.base.UpdateContextManagerEvent;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import java.util.Arrays;
import java.util.Collections;

final class ProductManager {
    private static final String PDF_CALLIGRAPH_NAMESPACE = "com.itextpdf.typography";
    private static final String PDF_RENDER_NAMESPACE = "com.itextpdf.pdfrender";
    private static final String PDF_OFFICE_NAMESPACE = "com.itextpdf.pdfoffice";
    private static final String PDF_OPTIMIZER_NAMESPACE = "com.itextpdf.pdfoptimizer";
    private static final String PDF_XFA_NAMESPACE = "com.itextpdf.tool.xml";
    private static final String DITO_NAMESPACE = "com.itextpdf.dito";
    private static final String PDF_2_DATA_NAMESPACE = "com.itextpdf.pdf2data";
    private static final String PDF_CALLIGRAPH_PRODUCT = "pdfCalligraph";
    private static final String PDF_RENDER_PRODUCT = "pdfRender";
    private static final String PDF_OFFICE_PRODUCT = "pdfOffice";
    private static final String PDF_XFA_PRODUCT = "pdfXfa";
    private static final String PDF_OPTIMIZER_PRODUCT = "pdfOptimizer";
    private static final String DITO_SDK_PRODUCT = "dito-sdk";
    private static final String PDF_2_DATA_PRODUCT = "pdf2Data";

    private ProductManager() {
    }

    static boolean isCoreOrCoreIndependentProduct(LicenseFile licenseFile) {
        if (licenseFile == null) {
            throw new LicenseKeyException("License file was corrupted.");
        }
        String product = licenseFile.getProduct();
        return "itext-core".equals(product) || DITO_SDK_PRODUCT.equals(product) || PDF_2_DATA_PRODUCT.equals(product);
    }

    static void registerProductsContext() {
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(DITO_NAMESPACE), Collections.singletonList(DITO_SDK_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_2_DATA_NAMESPACE), Collections.singletonList(PDF_2_DATA_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_CALLIGRAPH_NAMESPACE), Collections.singletonList(PDF_CALLIGRAPH_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_RENDER_NAMESPACE), Collections.singletonList(PDF_RENDER_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_XFA_NAMESPACE), Collections.singletonList(PDF_XFA_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_OFFICE_NAMESPACE), Collections.singletonList(PDF_OFFICE_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList(PDF_OPTIMIZER_NAMESPACE), Collections.singletonList(PDF_OPTIMIZER_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(NamespaceConstant.ITEXT_CORE_NAMESPACES, Arrays.asList("itext-core", PDF_CALLIGRAPH_PRODUCT)));
        EventManager.getInstance().onEvent((IEvent)new UpdateContextManagerEvent(Collections.singletonList("com.itextpdf.html2pdf"), Arrays.asList("pdfHtml", PDF_CALLIGRAPH_PRODUCT)));
    }

    static void registerWhitelistedNamespaces() {
    }
}

