/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.utils.oauth10;

import com.infor.erpln.utils.oauth10.UsedNonce;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class UsedNonceCache {
    private final int m_maxAge;
    private final Set<UsedNonce> m_usedNonce = new TreeSet<UsedNonce>();
    private long m_timeToVisit;

    public UsedNonceCache(int maxAge) {
        this.m_maxAge = maxAge;
        this.m_timeToVisit = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(UsedNonce nonce) {
        boolean valid = false;
        if (nonce != null) {
            Set<UsedNonce> set = this.m_usedNonce;
            synchronized (set) {
                if (this.m_usedNonce.add(nonce)) {
                    this.checkExpiry(nonce.getTimestamp());
                    valid = true;
                }
            }
        }
        return valid;
    }

    int size() {
        return this.m_usedNonce.size();
    }

    private void checkExpiry(long currentTime) {
        if (currentTime >= this.m_timeToVisit) {
            this.m_timeToVisit = this.removeExpired(currentTime);
        }
    }

    private long removeExpired(long currentTime) {
        UsedNonce next = null;
        UsedNonce oldest = new UsedNonce(currentTime - (long)this.m_maxAge, "");
        Iterator<UsedNonce> iterator = this.m_usedNonce.iterator();
        while (iterator.hasNext()) {
            UsedNonce current = iterator.next();
            if (oldest.compareTo(current) <= 0) {
                next = current;
                break;
            }
            iterator.remove();
        }
        return next != null ? next.getTimestamp() + (long)this.m_maxAge : 0L;
    }
}

